/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;

class ParameterFunction
implements Function {
    static final FunctionName NAME = new FunctionNameImpl("parameter", FunctionNameImpl.parameter((String)"parameterMap", Map.class), new Parameter[]{FunctionNameImpl.parameter((String)"argumentName", String.class), FunctionNameImpl.parameter((String)"values", Object.class, (int)0, (int)Integer.MAX_VALUE)});
    Literal fallbackValue;
    List<Expression> parameters;

    ParameterFunction(Literal fallbackValue, List<Expression> parameters) {
        this.fallbackValue = fallbackValue;
        this.parameters = parameters;
    }

    public Literal getFallbackValue() {
        return this.fallbackValue;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        ArrayList<Object> value;
        if (this.parameters.isEmpty()) {
            throw new IllegalArgumentException("The parameter function requires at least one parameter, the argument name");
        }
        String name = (String)this.parameters.get(0).evaluate((Object)object, String.class);
        if (name == null) {
            throw new IllegalArgumentException("The first function parameter should be a string, the name of a process argument");
        }
        if (this.parameters.size() == 1) {
            value = object;
        } else if (this.parameters.size() == 2) {
            value = this.parameters.get(1).evaluate((Object)object);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 1; i < this.parameters.size(); ++i) {
                Object o = this.parameters.get(i).evaluate(object);
                values.add(o);
            }
            value = values;
        }
        return Collections.singletonMap(name, value);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        return (T)Converters.convert((Object)this.evaluate(object), context);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fallbackValue == null ? 0 : this.fallbackValue.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterFunction other = (ParameterFunction)obj;
        if (this.fallbackValue == null ? other.fallbackValue != null : !this.fallbackValue.equals(other.fallbackValue)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

