/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.factory;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.feature.NameImpl;
import org.geotools.process.factory.AnnotationDrivenProcessFactory;
import org.geotools.process.factory.DescribeProcess;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class StaticMethodsProcessFactory<T>
extends AnnotationDrivenProcessFactory {
    Class<T> targetClass;

    public StaticMethodsProcessFactory(InternationalString title, String namespace, Class<T> targetClass) {
        super(title, namespace);
        this.targetClass = targetClass;
    }

    @Override
    protected DescribeProcess getProcessDescription(Name name) {
        Method method = this.method(name.getLocalPart());
        if (method == null) {
            return null;
        }
        DescribeProcess info = method.getAnnotation(DescribeProcess.class);
        return info;
    }

    @Override
    public Method method(String name) {
        for (Method method : this.targetClass.getMethods()) {
            DescribeProcess dp;
            if (!name.equalsIgnoreCase(method.getName()) || (dp = method.getAnnotation(DescribeProcess.class)) == null) continue;
            return method;
        }
        return null;
    }

    @Override
    public Set<Name> getNames() {
        LinkedHashSet<Name> names = new LinkedHashSet<Name>();
        for (Method method : this.targetClass.getMethods()) {
            DescribeProcess dp = method.getAnnotation(DescribeProcess.class);
            if (dp == null) continue;
            NameImpl name = new NameImpl(this.namespace, method.getName());
            if (names.contains(name)) {
                throw new IllegalStateException(this.targetClass.getName() + " has two methods named " + method.getName() + ", both annotated with DescribeProcess, this is an ambiguity. Please a different name");
            }
            names.add((Name)name);
        }
        return names;
    }

    @Override
    protected Object createProcessBean(Name name) {
        return null;
    }
}

