/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.parser.node.Band;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.GetSourceValue;
import it.geosolutions.jaiext.jiffle.parser.node.ScalarLiteral;
import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffleop.JiffleDescriptor;
import it.geosolutions.jaiext.jiffleop.JiffleRIF;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.jai.Registry;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

@DescribeProcess(title="Jiffle map algebra", description="Map algebra powered by Jiffle")
public class JiffleProcess
implements RasterProcess {
    static final Logger LOGGER;
    public static final String IN_COVERAGE = "coverage";
    public static final String IN_SCRIPT = "script";
    public static final String IN_DEST_NAME = "destName";
    public static final String IN_SOURCE_NAME = "sourceName";
    public static final String IN_OUTPUT_TYPE = "outputType";
    public static final String OUTPUT_BAND_COUNT = "bandCount";
    public static final String OUTPUT_BAND_NAMES = "bandNames";
    public static final String OUT_RESULT = "result";
    public static final String TX_BANDS = "bands";

    @DescribeResult(name="result", description="The map algebra output")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Source raster(s)") GridCoverage2D[] coverages, @DescribeParameter(name="script", description="The script performing the map algebra, in Jiffle language") String script, @DescribeParameter(name="destName", description="Name of the output, as used in the script (defaults to 'dest' if not specified)", min=0) String destName, @DescribeParameter(name="sourceName", description="Name of the inputs, as used in the script (default to src, src1, src2, ... if not specified)", min=0) String[] sourceNames, @DescribeParameter(name="outputType", description="Output data type, BYTE, USHORT, SHORT, INT, FLOAT, DOUBLE. Defaults to DOUBLE if not specified", min=0) Range.DataType dataType, @DescribeParameter(name="bandCount", description="Number of output bands. If not specified, will try to infer from the script, which will be possible only if the output band indices are literals.", min=0, minValue=1.0) Integer outputBandCount, @DescribeParameter(name="bandNames", description="Comma separate list of output band names. If not specified, will use 'jiffle' for single banded output, 'jiffle1', 'jiffle2', and so on for multi-band outputs", min=0) String outputBandNames, ProgressListener progressListener) throws ProcessException, JiffleException {
        Integer awtDataType;
        if (coverages.length == 0) {
            throw new IllegalArgumentException("Need at least one coverage in input");
        }
        RenderedImage[] sources = new RenderedImage[coverages.length];
        GridCoverage2D reference = coverages[0];
        sources[0] = reference.getRenderedImage();
        for (int i = 1; i < sources.length; ++i) {
            GridCoverage2D coverage = coverages[i];
            double[] nodata = CoverageUtilities.getBackgroundValues((GridCoverage2D)coverage);
            ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)coverage);
            sources[i] = coverage.getGridGeometry().equals((Object)reference.getGridGeometry()) ? coverage.getRenderedImage() : GridCoverage2DRIA.create((GridCoverage2D)coverage, (GridCoverage2D)reference, (double[])nodata, (Hints)GeoTools.getDefaultHints(), (ROI)roi);
        }
        Range[] nodatas = new Range[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            GridCoverage2D coverage = coverages[i];
            NoDataContainer coverageNoData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
            if (coverageNoData == null) continue;
            nodatas[i] = coverageNoData.getAsRange();
        }
        if (Arrays.stream(nodatas).filter(n -> n != null).count() == 0L) {
            nodatas = null;
        }
        BandTransform[] bandTransforms = null;
        if (sources.length == 1) {
            BandTransform bt = this.getRenderingTransformationBandTransform(script, sourceNames, sources[0]);
            bandTransforms = new BandTransform[]{bt};
        }
        Integer n2 = awtDataType = dataType == null ? null : Integer.valueOf(dataType.getDataType());
        if (outputBandCount == null && outputBandNames != null) {
            outputBandCount = outputBandNames.split("\\s*,\\s*").length;
        }
        RenderedOp result = JiffleDescriptor.create((RenderedImage[])sources, (String[])sourceNames, (String)destName, (String)script, null, (Integer)awtDataType, (Integer)outputBandCount, null, (BandTransform[])bandTransforms, (Range[])nodatas, (RenderingHints)GeoTools.getDefaultHints());
        GridSampleDimension[] sampleDimensions = this.getSampleDimensions(result, outputBandNames);
        GridCoverageFactory factory = new GridCoverageFactory(GeoTools.getDefaultHints());
        return factory.create((CharSequence)"jiffle", (RenderedImage)result, reference.getEnvelope(), sampleDimensions, (GridCoverage[])coverages, null);
    }

    private GridSampleDimension[] getSampleDimensions(RenderedOp result, String outputBandNames) {
        SampleModel sm = result.getSampleModel();
        Stream<String> names = this.getSampleDimensionNames(sm.getNumBands(), outputBandNames);
        SampleDimensionType sourceType = TypeMap.getSampleDimensionType((SampleModel)sm, (int)0);
        NumberRange range = TypeMap.getRange((SampleDimensionType)sourceType);
        double[] nodata = null;
        double min = range.getMinimum();
        double max = range.getMaximum();
        return (GridSampleDimension[])names.map(n -> new GridSampleDimension((CharSequence)n, sourceType, null, nodata, min, max, 1.0, 0.0, null)).toArray(GridSampleDimension[]::new);
    }

    private Stream<String> getSampleDimensionNames(int numBands, String outputBandNames) {
        if (outputBandNames == null) {
            return this.getDefaultBandNames(numBands);
        }
        String[] split = outputBandNames.split("\\s*,\\s*");
        if (split.length < numBands) {
            String[] defaultBands = (String[])this.getDefaultBandNames(numBands).toArray(String[]::new);
            System.arraycopy(split, 0, defaultBands, 0, split.length);
            return Arrays.stream(defaultBands);
        }
        return Arrays.stream(split);
    }

    private Stream<String> getDefaultBandNames(int numBands) {
        if (numBands == 1) {
            return Stream.of("jiffle");
        }
        return IntStream.range(1, numBands + 1).mapToObj(n -> "jiffle" + n);
    }

    private BandTransform getRenderingTransformationBandTransform(String script, String[] sourceNames, RenderedImage source) throws JiffleException {
        int[] scriptBands = this.getTransformationBands(script, sourceNames);
        if (scriptBands == null) {
            return null;
        }
        if (source.getSampleModel().getNumBands() > scriptBands[scriptBands.length - 1]) {
            return null;
        }
        int maxReadBand = Arrays.stream(scriptBands).max().getAsInt();
        int[] map = new int[maxReadBand + 1];
        boolean mapRequired = false;
        for (int i = 0; i < scriptBands.length; ++i) {
            int scriptBand2 = scriptBands[i];
            map[scriptBand2] = i;
            mapRequired |= scriptBand2 != i;
        }
        if (!mapRequired) {
            return null;
        }
        return (x, y, scriptBand) -> map[scriptBand];
    }

    public GeneralParameterValue[] customizeReadParams(@DescribeParameter(name="script", description="The script performing the map algebra, in Jiffle language") String script, @DescribeParameter(name="destName", description="Name of the output, as used in the script (defaults to 'dest' if not specified)", min=0) String destName, @DescribeParameter(name="sourceName", description="Name of the inputs, as used in the script (default to src, src1, src2, ... if not specified)", min=0) String[] sourceNames, @DescribeParameter(name="bands", description="Bands read by the transformation", min=0) int[] usedBands, GridCoverageReader reader, GeneralParameterValue[] params) {
        try {
            ParameterValueGroup readerParams = reader.getFormat().getReadParameters();
            ParameterValue bands = readerParams.parameter(AbstractGridFormat.BANDS.getName(null));
            if (bands == null) {
                LOGGER.log(Level.FINE, "The reader does not support band selection, reading all");
                return params;
            }
            if (!(reader instanceof GridCoverage2DReader)) {
                LOGGER.log(Level.FINE, "The reader is not a 2D one, reading all bands");
                return params;
            }
            GridCoverage2DReader r2d = (GridCoverage2DReader)reader;
            ImageLayout layout = r2d.getImageLayout();
            if (layout == null || layout.getSampleModel(null) == null) {
                LOGGER.log(Level.FINE, "Cannot determine the reader bands, reading them all");
                return params;
            }
            SampleModel sampleModel = layout.getSampleModel(null);
            if (usedBands == null) {
                usedBands = this.getTransformationBands(script, sourceNames);
            }
            if (usedBands == null || usedBands.length >= sampleModel.getNumBands()) {
                return params;
            }
            return this.mergeBandParam(params, usedBands);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to determine if we can read less bands based on the Jiffle script, continuing reading all source bands", e);
            return params;
        }
    }

    private GeneralParameterValue[] mergeBandParam(GeneralParameterValue[] params, int[] bands) {
        if (params != null) {
            for (GeneralParameterValue param : params) {
                if (!param.getDescriptor().getName().equals(AbstractGridFormat.BANDS.getName())) continue;
                ((ParameterValue)param).setValue((Object)bands);
                return params;
            }
        }
        ArrayList<GeneralParameterValue> list = new ArrayList<GeneralParameterValue>(params == null ? Collections.emptyList() : Arrays.asList(params));
        ParameterValue value = AbstractGridFormat.BANDS.createValue();
        value.setValue((Object)bands);
        list.add((GeneralParameterValue)value);
        return list.toArray(new GeneralParameterValue[list.size()]);
    }

    private int[] getTransformationBands(String script, String[] sourceNames) throws JiffleException {
        Set positions;
        String sourceName = "src";
        if (sourceNames != null && sourceNames.length > 0) {
            sourceName = sourceNames[0];
        }
        if ((positions = Jiffle.getReadPositions((String)script, Arrays.asList(sourceName))).isEmpty()) {
            return null;
        }
        HashSet<Integer> bands = new HashSet<Integer>();
        for (GetSourceValue position : positions) {
            Band band = position.getPos().getBand();
            Expression index = band.getIndex();
            if (index == null) {
                bands.add(0);
                continue;
            }
            if (index instanceof ScalarLiteral) {
                bands.add(Integer.valueOf(((ScalarLiteral)band.getIndex()).getValue()));
                continue;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Cannot determine read bands, the source read spec use an expression for the band, not a literal: " + position);
            }
            return null;
        }
        return bands.stream().mapToInt(b -> b).sorted().toArray();
    }

    static {
        Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new JiffleDescriptor(), (RenderedImageFactory)new JiffleRIF(), (String)"it.geosolutions.jaiext");
        LOGGER = Logging.getLogger(JiffleProcess.class);
    }
}

