/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="Select Coverages", description="Returns a raster generated by the selection of some bands from the input raster.")
public class BandSelectProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="A selection on the input rasters")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input GridCoverage", min=1) GridCoverage2D coverage, @DescribeParameter(name="SampleDimensions", description="Input sample dimension indexes", min=1) int[] sampleDims, @DescribeParameter(name="VisibleSampleDimension", description="Input visible sample dimension index", min=0) Integer visibleSampleDim) throws ProcessException {
        ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("SampleDimensions").setValue((Object)sampleDims);
        param.parameter("VisibleSampleDimension").setValue((Object)visibleSampleDim);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

