/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.process.ProcessException;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.ClassChanger;
import org.geotools.util.Utilities;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageUtilities {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";
    public static final String MINY = "MINY";
    public static final String MINX = "MINX";

    private CoverageUtilities() {
    }

    public static ROI prepareROI(Geometry roi, AffineTransform mt2d) throws ProcessException {
        Geometry rasterSpaceGeometry;
        try {
            rasterSpaceGeometry = JTS.transform((Geometry)roi, (MathTransform)new AffineTransform2D(mt2d.createInverse()));
        }
        catch (MismatchedDimensionException e) {
            throw new ProcessException((Throwable)e);
        }
        catch (TransformException e) {
            throw new ProcessException((Throwable)e);
        }
        catch (NoninvertibleTransformException e) {
            throw new ProcessException((Throwable)e);
        }
        Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)rasterSpaceGeometry, (double)1.0);
        return new ROIGeometry(simplifiedGeometry);
    }

    public static SimpleFeatureType createFeatureType(GridCoverage2D gc2d, Class<? extends Geometry> geometryClass) {
        Utilities.ensureNonNull((String)"gc2d", (Object)gc2d);
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(gc2d.getName().toString());
        ftBuilder.setNamespaceURI("http://www.geotools.org/");
        ftBuilder.setCRS(gc2d.getCoordinateReferenceSystem2D());
        ftBuilder.setDefaultGeometry("the_geom");
        ftBuilder.add("the_geom", geometryClass);
        if (!geometryClass.equals(Point.class)) {
            ftBuilder.add("value", Double.class);
        } else {
            GridSampleDimension[] sampleDimensions;
            for (GridSampleDimension sd : sampleDimensions = gc2d.getSampleDimensions()) {
                Class bandClass;
                SampleDimensionType sdType = sd.getSampleDimensionType();
                int dataBuffType = TypeMap.getDataBufferType((SampleDimensionType)sdType);
                switch (dataBuffType) {
                    case 0: {
                        bandClass = Byte.class;
                        break;
                    }
                    case 5: {
                        bandClass = Double.class;
                        break;
                    }
                    case 4: {
                        bandClass = Float.class;
                        break;
                    }
                    case 3: {
                        bandClass = Integer.class;
                        break;
                    }
                    case 1: 
                    case 2: {
                        bandClass = Short.class;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ftBuilder.add(sd.getDescription().toString(), bandClass);
            }
        }
        return ftBuilder.buildFeatureType();
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, Number noDataValue) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, Number noDataValue, Class clazz) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, null, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, int[] outputPixelValues, Number noDataValue) {
        return CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, noDataValue, noDataValue.getClass());
    }

    public static RangeLookupTable getRangeLookupTable(List<Range> classificationRanges, int[] outputPixelValues, Number noDataValue, Class<? extends Number> clazz) {
        RangeLookupTable.Builder rltBuilder = new RangeLookupTable.Builder();
        int size = classificationRanges.size();
        boolean useCustomOutputPixelValues = outputPixelValues != null && outputPixelValues.length == size;
        Class widestClass = noDataValue.getClass();
        for (int i = 0; i < size; ++i) {
            Range range = classificationRanges.get(i);
            Class<?> rangeClass = range.getMin().getClass();
            if (widestClass != rangeClass) {
                widestClass = ClassChanger.getWidestClass(widestClass, rangeClass);
            }
            int reference = useCustomOutputPixelValues ? outputPixelValues[i] : i + 1;
            rltBuilder.add(range, CoverageUtilities.convert(reference, noDataValue.getClass()));
        }
        rltBuilder.add(new Range(CoverageUtilities.getClassMinimum(widestClass), true, CoverageUtilities.getClassMaximum(widestClass), true), noDataValue);
        return rltBuilder.build();
    }

    public static it.geosolutions.jaiext.rlookup.RangeLookupTable getRangeLookupTableJAIEXT(List<Range> classificationRanges, int[] outputPixelValues, Number noDataValue, int transferType) {
        Class noDataClass;
        RangeLookupTable.Builder rltBuilder = new RangeLookupTable.Builder();
        int size = classificationRanges.size();
        boolean useCustomOutputPixelValues = outputPixelValues != null && outputPixelValues.length == size;
        Class widestClass = noDataClass = Range.DataType.classFromType((int)transferType);
        for (int i = 0; i < size; ++i) {
            Range range = classificationRanges.get(i);
            Class<?> rangeClass = range.getMin().getClass();
            if (widestClass != rangeClass) {
                widestClass = ClassChanger.getWidestClass((Class)widestClass, rangeClass);
            }
            int rangeType = Range.DataType.dataTypeFromClass(rangeClass);
            int reference = useCustomOutputPixelValues ? outputPixelValues[i] : i + 1;
            it.geosolutions.jaiext.range.Range rangeJaiext = RangeFactory.convert((it.geosolutions.jaiext.range.Range)RangeFactory.create((double)range.getMin().doubleValue(), (boolean)range.isMinIncluded(), (double)range.getMax().doubleValue(), (boolean)range.isMaxIncluded()), (int)rangeType);
            rltBuilder.add(rangeJaiext, CoverageUtilities.convert(reference, noDataClass));
        }
        int rangeType = Range.DataType.dataTypeFromClass((Class)widestClass);
        it.geosolutions.jaiext.range.Range rangeJaiext = RangeFactory.convert((it.geosolutions.jaiext.range.Range)RangeFactory.create((double)CoverageUtilities.getClassMinimum(widestClass).doubleValue(), (double)CoverageUtilities.getClassMaximum(widestClass).doubleValue()), (int)rangeType);
        rltBuilder.add(rangeJaiext, noDataValue);
        return rltBuilder.build();
    }

    private static Number getClassMinimum(Class<? extends Number> numberClass) {
        if (numberClass == null) {
            return null;
        }
        if (Double.class.equals(numberClass)) {
            return Double.MIN_VALUE;
        }
        if (Float.class.equals(numberClass)) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (Long.class.equals(numberClass)) {
            return Long.MIN_VALUE;
        }
        if (Integer.class.equals(numberClass)) {
            return Integer.MIN_VALUE;
        }
        if (Short.class.equals(numberClass)) {
            return (short)Short.MIN_VALUE;
        }
        if (Byte.class.equals(numberClass)) {
            return (byte)-128;
        }
        throw new UnsupportedOperationException("Class " + numberClass + " can't be used in a value Range");
    }

    private static Number getClassMaximum(Class<? extends Number> numberClass) {
        if (numberClass == null) {
            return null;
        }
        if (Double.class.equals(numberClass)) {
            return Double.MAX_VALUE;
        }
        if (Float.class.equals(numberClass)) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        if (Long.class.equals(numberClass)) {
            return Long.MAX_VALUE;
        }
        if (Integer.class.equals(numberClass)) {
            return Integer.MAX_VALUE;
        }
        if (Short.class.equals(numberClass)) {
            return (short)Short.MAX_VALUE;
        }
        if (Byte.class.equals(numberClass)) {
            return (byte)127;
        }
        throw new UnsupportedOperationException("Class " + numberClass + " can't be used in a value Range");
    }

    public static Number convert(Number val, Class<? extends Number> type) {
        if (val == null) {
            return null;
        }
        if (Double.class.equals(type)) {
            if (val instanceof Double) {
                return val;
            }
            return val.doubleValue();
        }
        if (Float.class.equals(type)) {
            if (val instanceof Float) {
                return val;
            }
            return Float.valueOf(val.floatValue());
        }
        if (Integer.class.equals(type)) {
            if (val instanceof Integer) {
                return val;
            }
            return val.intValue();
        }
        if (Byte.class.equals(type)) {
            if (val instanceof Byte) {
                return val;
            }
            return val.byteValue();
        }
        if (Short.class.equals(type)) {
            if (val instanceof Short) {
                return val;
            }
            return val.shortValue();
        }
        throw new UnsupportedOperationException("Class " + type + " can't be used in a value Range");
    }

    public static HashMap<String, Double> getRegionParamsFromGridCoverage(GridCoverage2D gridCoverage) {
        HashMap<String, Double> envelopeParams = new HashMap<String, Double>();
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        int minX = gridRange.x;
        int minY = gridRange.y;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        envelopeParams.put(MINY, Double.valueOf(minY));
        envelopeParams.put(MINX, Double.valueOf(minX));
        return envelopeParams;
    }
}

