/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.BaseSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.AffineProcess;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.GridConvergenceAngleCalc;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

@DescribeProcess(title="Raster As Point Collection", description="Returns a collection of point features for the pixels of a raster.  The band values are provided as attributes.")
public class RasterAsPointCollectionProcess
implements RasterProcess {
    @DescribeResult(name="result", description="Point features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D gc2d, @DescribeParameter(name="targetCRS", description="CRS in which the points will be displayed", min=0) CoordinateReferenceSystem targetCRS, @DescribeParameter(name="scale", description="scale", min=0, defaultValue="1.0f") Float scaleFactor, @DescribeParameter(name="interpolation", description="interpolation", min=0, defaultValue="InterpolationNearest") Interpolation interpolation, @DescribeParameter(name="emisphere", description="Add Emishpere", min=0, defaultValue="False") Boolean emisphere) throws ProcessException {
        if (gc2d == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        GridEnvelope2D gridEnv = gc2d.getGridGeometry().getGridRange2D();
        double coverageWidth = gridEnv.getWidth();
        double coverageHeight = gridEnv.getHeight();
        if (scaleFactor != null && (Math.abs(coverageWidth * (double)(scaleFactor.floatValue() - 1.0f)) >= 1.0 || Math.abs(coverageHeight * (double)(scaleFactor.floatValue() - 1.0f)) >= 1.0)) {
            Interpolation interp = interpolation != null ? interpolation : new InterpolationNearest();
            double scaleX = scaleFactor.floatValue();
            double scaleY = scaleFactor.floatValue();
            RenderedImage imageToBescaled = gc2d.getRenderedImage();
            if (imageToBescaled != null) {
                SampleModel sampleModel = imageToBescaled.getSampleModel();
                int height = sampleModel.getHeight();
                int width = sampleModel.getWidth();
                if ((float)height * scaleFactor.floatValue() < 1.0f) {
                    scaleY = 1.0 / (double)height;
                }
                if ((float)width * scaleFactor.floatValue() < 1.0f) {
                    scaleX = 1.0 / (double)width;
                }
            }
            gc2d = new AffineProcess().execute(gc2d, scaleX, scaleY, null, null, null, null, null, interp);
        }
        try {
            return new RasterAsPointFeatureCollection(gc2d, emisphere, targetCRS);
        }
        catch (IOException e) {
            throw new ProcessException("Unable to wrap provided grid coverage", (Throwable)e);
        }
    }

    private static final class RasterAsPointFeatureIterator
    implements SimpleFeatureIterator {
        private final double[] temp;
        private final SimpleFeatureBuilder fb;
        private final RasterAsPointFeatureCollection fc;
        private int index = 0;
        private final int size;
        private final RectIter iterator;
        private final Coordinate sourceCoordinate = new Coordinate();
        private DirectPosition2D sourceCRSPosition;
        private DirectPosition2D targetCRSPosition;

        public RasterAsPointFeatureIterator(RasterAsPointFeatureCollection fc) {
            Utilities.ensureNonNull((String)"fc", (Object)((Object)fc));
            this.fc = fc;
            this.fb = new SimpleFeatureBuilder((SimpleFeatureType)fc.getSchema());
            this.size = fc.size;
            this.iterator = RectIterFactory.create((RenderedImage)fc.gc2d.getRenderedImage(), null);
            this.iterator.startLines();
            if (this.iterator.finishedLines()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            this.iterator.startPixels();
            if (this.iterator.finishedPixels()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            this.temp = new double[fc.numBands];
            if (fc.gridConvergenceAngleCorrectionNeeded) {
                this.sourceCRSPosition = new DirectPosition2D();
                this.targetCRSPosition = new DirectPosition2D(fc.targetCRS);
            }
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            if (this.iterator.finishedPixels()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            if (this.iterator.finishedLines()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            int id = this.index;
            this.sourceCoordinate.x = 0.5 + (double)this.fc.rasterBounds.x + (double)(this.index % this.fc.rasterBounds.width);
            this.sourceCoordinate.y = 0.5 + (double)this.fc.rasterBounds.y + (double)(this.index / this.fc.rasterBounds.width);
            Point point = RasterAsPointFeatureCollection.geometryFactory.createPoint(this.sourceCoordinate);
            try {
                point = (Point)JTS.transform((Geometry)point, (MathTransform)this.fc.mt2D);
                this.fb.add((Object)point);
                this.iterator.getPixel(this.temp);
                for (double d : this.temp) {
                    this.fb.add((Object)d);
                }
                this.emisphereAttributeManagement(point);
                this.gridConvergenceAngleManagement(point);
            }
            catch (Exception e) {
                NoSuchElementException nse = new NoSuchElementException();
                nse.initCause(e);
                throw nse;
            }
            if (this.iterator.nextPixelDone() && !this.iterator.nextLineDone()) {
                this.iterator.startPixels();
            }
            SimpleFeature returnValue = this.fb.buildFeature(String.valueOf(id));
            ++this.index;
            return returnValue;
        }

        private void gridConvergenceAngleManagement(Point point) throws Exception {
            if (this.fc.gridConvergenceAngleCorrectionNeeded) {
                this.sourceCRSPosition.setLocation(point.getX(), point.getY());
                this.fc.reprojectionTransformation.transform((DirectPosition)this.sourceCRSPosition, (DirectPosition)this.targetCRSPosition);
                double convAngle = this.fc.gridConvergenceAngleManager.getConvergenceAngle(this.targetCRSPosition);
                this.fb.add((Object)convAngle);
            }
        }

        private void emisphereAttributeManagement(Point point) throws IOException {
            if (this.fc.emisphere) {
                Point wgs84Point = point;
                if (this.fc.transformToWGS84 != null) {
                    try {
                        wgs84Point = (Point)JTS.transform((Geometry)point, (MathTransform)this.fc.transformToWGS84);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                this.fb.add((Object)(wgs84Point.getY() >= 0.0 ? "N" : "S"));
            }
        }
    }

    private static final class RasterAsPointFeatureCollection
    extends BaseSimpleFeatureCollection {
        static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory((Hints)GeoTools.getDefaultHints());
        final GridCoverage2D gc2d;
        final int size;
        final MathTransform2D mt2D;
        private ReferencedEnvelope bounds;
        final Rectangle rasterBounds;
        final int numBands;
        private boolean emisphere;
        private MathTransform transformToWGS84;
        private CoordinateReferenceSystem targetCRS;
        private MathTransform reprojectionTransformation;
        private boolean gridConvergenceAngleCorrectionNeeded;
        private GridConvergenceAngleCalc gridConvergenceAngleManager;

        public RasterAsPointFeatureCollection(GridCoverage2D gc2d) throws IOException {
            this(gc2d, false, gc2d.getCoordinateReferenceSystem2D());
        }

        public RasterAsPointFeatureCollection(GridCoverage2D gc2d, boolean emisphere, CoordinateReferenceSystem targetCRS) throws IOException {
            super(RasterAsPointFeatureCollection.modify(CoverageUtilities.createFeatureType(gc2d, Point.class), emisphere, targetCRS));
            this.gc2d = gc2d;
            this.emisphere = emisphere;
            this.targetCRS = targetCRS;
            RenderedImage raster = gc2d.getRenderedImage();
            this.size = raster.getWidth() * raster.getHeight();
            this.mt2D = gc2d.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            this.rasterBounds = PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds();
            XRectangle2D rasterBounds_ = new XRectangle2D((double)raster.getMinX() + 0.5, (double)raster.getMinY() + 0.5, (double)(raster.getWidth() - 1), (double)(raster.getHeight() - 1));
            try {
                this.bounds = new ReferencedEnvelope(CRS.transform((MathTransform2D)this.mt2D, (Rectangle2D)rasterBounds_, null), gc2d.getCoordinateReferenceSystem2D());
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            this.numBands = gc2d.getNumSampleDimensions();
            CoordinateReferenceSystem coverageCRS = gc2d.getCoordinateReferenceSystem2D();
            this.emisphereManagement(coverageCRS);
            this.gridConvergenceAngle(coverageCRS);
        }

        private void gridConvergenceAngle(CoordinateReferenceSystem coverageCRS) throws IOException {
            if (this.targetCRS != null && !CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.targetCRS)) {
                try {
                    this.reprojectionTransformation = CRS.findMathTransform((CoordinateReferenceSystem)coverageCRS, (CoordinateReferenceSystem)this.targetCRS, (boolean)true);
                    boolean bl = this.gridConvergenceAngleCorrectionNeeded = !this.reprojectionTransformation.isIdentity();
                    if (this.gridConvergenceAngleCorrectionNeeded) {
                        this.gridConvergenceAngleManager = new GridConvergenceAngleCalc(this.targetCRS);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }

        private void emisphereManagement(CoordinateReferenceSystem coverageCRS) throws IOException {
            if (this.emisphere && !CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)coverageCRS)) {
                try {
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coverageCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
                    if (!transform.isIdentity()) {
                        this.transformToWGS84 = transform;
                    }
                }
                catch (FactoryException e) {
                    throw new IOException(e);
                }
            }
        }

        private static SimpleFeatureType modify(SimpleFeatureType featureType, boolean emisphere, CoordinateReferenceSystem targetCRS) {
            if (!emisphere && targetCRS == null) {
                return featureType;
            }
            SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
            ftBuilder.setName(featureType.getName());
            ftBuilder.setCRS(featureType.getCoordinateReferenceSystem());
            ftBuilder.setDefaultGeometry(featureType.getGeometryDescriptor().getLocalName());
            for (AttributeDescriptor atd : featureType.getAttributeDescriptors()) {
                ftBuilder.add(atd);
            }
            if (emisphere) {
                ftBuilder.add("emisphere", String.class);
            }
            if (targetCRS != null) {
                ftBuilder.add("gridConvergenceAngleCorrection", Double.class);
            }
            return ftBuilder.buildFeatureType();
        }

        public SimpleFeatureIterator features() {
            return new RasterAsPointFeatureIterator(this);
        }

        public int size() {
            return this.size;
        }

        public ReferencedEnvelope getBounds() {
            return new ReferencedEnvelope(this.bounds);
        }
    }
}

