/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import it.geosolutions.jaiext.classbreaks.ClassBreaksRIF;
import it.geosolutions.jaiext.classbreaks.Classification;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.operator.BandSelectDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.ProcessException;
import org.geotools.process.classify.ClassificationMethod;
import org.geotools.process.classify.ClassificationStats;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.renderer.i18n.Errors;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="coverageClassStats", description="Calculates statistics from coverage values classified into bins/classes.")
public class CoverageClassStats
implements RasterProcess {
    @DescribeResult(name="results", description="The classified results")
    public Results execute(@DescribeParameter(name="coverage", description="The coverage to analyze") GridCoverage2D coverage, @DescribeParameter(name="stats", description="The statistics to calculate for each class", collectionType=Statistic.class, min=0) Set<Statistic> stats, @DescribeParameter(name="band", description="The band to calculate breaks/statistics for", min=0) Integer band, @DescribeParameter(name="classes", description="The number of breaks/classes", min=0) Integer classes, @DescribeParameter(name="method", description="The classification method", min=0) ClassificationMethod method, @DescribeParameter(name="noData", description="The pixel value to be ommitted from any calculation", min=0) Double noData, ProgressListener progressListener) throws ProcessException, IOException {
        if (coverage == null) {
            throw new ProcessException(Errors.format((int)143, (Object)"coverage"));
        }
        if (classes == null) {
            classes = 10;
        }
        if (classes < 1) {
            throw new ProcessException(Errors.format((int)58, (Object)"classes", (Object)classes));
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        if (band == null) {
            band = 0;
        }
        int numBands = sourceImage.getSampleModel().getNumBands();
        if (band < 0 || band >= numBands) {
            throw new ProcessException(Errors.format((int)58, (Object)"band", (Object)band));
        }
        if (numBands > 1) {
            sourceImage = BandSelectDescriptor.create((RenderedImage)sourceImage, (int[])new int[]{band}, null);
        }
        if (method == null) {
            method = ClassificationMethod.EQUAL_INTERVAL;
        }
        if (stats == null || stats.isEmpty()) {
            stats = Collections.singleton(Statistic.MEAN);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImage);
        pb.set(classes, 0);
        pb.set(this.toJAIExtMethod(method), 1);
        pb.set(null, 2);
        pb.set(null, 3);
        pb.set(new Integer[]{0}, 4);
        pb.set(1, 5);
        pb.set(1, 6);
        pb.set(noData, 7);
        RenderedImage op = new ClassBreaksRIF().create(pb, null);
        Classification c = (Classification)op.getProperty("Classification");
        Double[] breaks = (Double[])c.getBreaks()[0];
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < breaks.length - 1; ++i) {
            ranges.add(Range.create((Number)breaks[i], (boolean)true, (Number)breaks[i + 1], (i == breaks.length - 2 ? 1 : 0) != 0));
        }
        ParameterBlockJAI pbj = new ParameterBlockJAI("ZonalStats");
        pbj.addSource((Object)sourceImage);
        pbj.setParameter("stats", (Object)stats.toArray(new Statistic[stats.size()]));
        pbj.setParameter("bands", (Object)new Integer[]{band});
        pbj.setParameter("ranges", ranges);
        pbj.setParameter("rangesType", (Object)Range.Type.INCLUDE);
        pbj.setParameter("rangeLocalStats", true);
        op = JAI.create((String)"ZonalStats", (ParameterBlock)pbj);
        ZonalStats zonalStats = (ZonalStats)op.getProperty("ZonalStatsProperty");
        return new Results(stats, zonalStats);
    }

    private it.geosolutions.jaiext.classbreaks.ClassificationMethod toJAIExtMethod(ClassificationMethod method) {
        if (method == null) {
            return null;
        }
        return it.geosolutions.jaiext.classbreaks.ClassificationMethod.valueOf((String)method.name());
    }

    public static class Results
    implements ClassificationStats {
        Statistic firstStat;
        Set<Statistic> stats;
        ZonalStats zonalStats;
        List<Result> ranges;

        public Results(Set<Statistic> stats, ZonalStats zonalStats) {
            this.stats = stats;
            this.zonalStats = zonalStats;
            this.firstStat = stats.iterator().next();
            this.ranges = zonalStats.statistic(this.firstStat).results();
        }

        public int size() {
            return this.ranges.size();
        }

        public Set<Statistic> getStats() {
            return this.stats;
        }

        public Range range(int i) {
            return (Range)this.ranges.get(i).getRanges().iterator().next();
        }

        public Double value(int i, Statistic stat) {
            return ((Result)this.zonalStats.statistic(stat).results().get(i)).getValue();
        }

        public Long count(int i) {
            return ((Result)this.zonalStats.statistic(this.firstStat).results().get(i)).getNumAccepted();
        }

        ZonalStats getZonalStats() {
            return this.zonalStats;
        }
    }
}

