/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.io.IOException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;

@DescribeProcess(title="Style Coverage", description="Styles a raster using a given SLD and raster symbolizer.")
public class StyleCoverage
implements RasterProcess {
    @DescribeResult(name="result", description="Styled image")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="style", description="Styled Layer Descriptor (SLD) style containing a raster symbolizer") Style style) throws IOException {
        RasterSymbolizer symbolizer = (RasterSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(coverage, null);
        rsh.visit(symbolizer);
        return (GridCoverage2D)rsh.execute();
    }
}

