/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.process.geometry.PolyLabeller;
import org.geotools.util.Converters;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class PolygonLabelFunction
implements Function {
    static FunctionName NAME = new FunctionNameImpl("labelPoint", PointShapeFactory.Point.class, new Parameter[]{FunctionNameImpl.parameter((String)"polygon", Geometry.class), FunctionNameImpl.parameter((String)"tolerance", Double.class)});
    private final List<Expression> parameters;
    private final Literal fallback;

    public PolygonLabelFunction(List<Expression> parameters, Literal fallback) {
        if (parameters == null) {
            throw new NullPointerException("parameters required");
        }
        if (parameters.isEmpty() || parameters.size() > 2) {
            throw new IllegalArgumentException("labelPoint((multi)polygon, tolerance) requires one or two parameters (tolerance is optional)");
        }
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, PointShapeFactory.Point.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression geometryExpression = this.parameters.get(0);
        Geometry polygon = (Geometry)geometryExpression.evaluate(object, Geometry.class);
        Double tolerance = null;
        if (this.parameters.size() == 2) {
            tolerance = (Double)this.parameters.get(1).evaluate(object, Double.class);
        }
        Point point = PolyLabeller.getPolylabel(polygon, tolerance);
        return (T)Converters.convert((Object)point, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

