/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.List;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.process.geometry.PolyLabeller;
import org.geotools.util.Converters;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;

public class PolygonLabelFunction
implements Function {
    static FunctionName NAME = new FunctionNameImpl("labelPoint", PointShapeFactory.Point.class, new Parameter[]{FunctionNameImpl.parameter((String)"polygon", Geometry.class), FunctionNameImpl.parameter((String)"tolerance", Double.TYPE)});
    private final List<Expression> parameters;
    private final Literal fallback;

    public PolygonLabelFunction(List<Expression> parameters, Literal fallback) {
        if (parameters == null) {
            throw new NullPointerException("parameters required");
        }
        if (parameters.size() != 2) {
            throw new IllegalArgumentException("labelPoint((multi)polygon, tolerance) requires two parameters only");
        }
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, PointShapeFactory.Point.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression geometryExpression = this.parameters.get(0);
        Geometry polygon = (Geometry)geometryExpression.evaluate(object, Geometry.class);
        Expression toleranceExpression = this.parameters.get(1);
        double tolerance = (Double)toleranceExpression.evaluate(object, Double.TYPE);
        Geometry point = PolyLabeller.getPolylabel(polygon, tolerance);
        return (T)Converters.convert((Object)point, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

