/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.process.geometry.Cell;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PolyLabeller {
    private static final Logger LOGGER = Logging.getLogger(PolyLabeller.class);
    static GeometryBuilder GB = new GeometryBuilder();

    static Geometry getPolylabel(Geometry polygon, double precision) {
        MultiPolygon multiPolygon;
        if (polygon instanceof Polygon) {
            multiPolygon = GB.multiPolygon(new Polygon[]{(Polygon)polygon});
        } else if (polygon instanceof MultiPolygon) {
            multiPolygon = (MultiPolygon)polygon;
        } else {
            throw new IllegalStateException("Input polygon must be a Polygon or MultiPolygon");
        }
        if (polygon.isEmpty() || polygon.getArea() <= 0.0) {
            throw new IllegalStateException("Can not label empty geometries");
        }
        Envelope env = multiPolygon.getEnvelopeInternal();
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double height = env.getHeight();
        double cellSize = Math.min(width, height);
        double h = cellSize / 2.0;
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(new Cell(x + h, y + h, h, multiPolygon));
            }
        }
        Cell bestCell = PolyLabeller.getCentroidCell(multiPolygon);
        int numProbes = cellQueue.size();
        while (!cellQueue.isEmpty()) {
            Cell cell = (Cell)cellQueue.remove();
            if (cell.getD() > bestCell.getD()) {
                bestCell = cell;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("found best " + (double)Math.round(10000.0 * cell.getD()) / 10000.0 + " after " + numProbes + " probes");
                }
            }
            if (cell.getMax() - bestCell.getD() <= precision) continue;
            h = cell.getH() / 2.0;
            cellQueue.add(new Cell(cell.getX() - h, cell.getY() - h, h, multiPolygon));
            cellQueue.add(new Cell(cell.getX() + h, cell.getY() - h, h, multiPolygon));
            cellQueue.add(new Cell(cell.getX() - h, cell.getY() + h, h, multiPolygon));
            cellQueue.add(new Cell(cell.getX() + h, cell.getY() + h, h, multiPolygon));
            numProbes += 4;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("num probes: " + numProbes);
            LOGGER.finer("best distance: " + bestCell.getD());
        }
        return bestCell.getPoint();
    }

    private static Cell getCentroidCell(MultiPolygon poly) {
        Point p = poly.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, poly);
    }
}

