/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.NoSuchElementException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="Inclusion of Feature Collections", description="Returns a feature collection consisting of the features from the first collection which are spatially contained in at least one feature of the second collection.")
public class InclusionFeatureCollection
implements VectorProcess {
    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="first", description="First feature collection") SimpleFeatureCollection firstFeatures, @DescribeParameter(name="second", description="Second feature collection") SimpleFeatureCollection secondFeatures) {
        return new IncludedFeatureCollection(firstFeatures, secondFeatures);
    }

    static class IncludedFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        SimpleFeatureCollection firstFeatures;
        SimpleFeatureCollection secondFeatures;
        SimpleFeatureBuilder fb;
        SimpleFeature next;
        String dataGeomName;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

        public IncludedFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureCollection firstFeatures, SimpleFeatureCollection secondFeatures, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.firstFeatures = firstFeatures;
            this.secondFeatures = secondFeatures;
            this.fb = new SimpleFeatureBuilder(schema);
            this.dataGeomName = ((SimpleFeatureType)this.firstFeatures.getSchema()).getGeometryDescriptor().getLocalName();
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasNext() {
            while (this.next == null && this.delegate.hasNext()) {
                SimpleFeature f = (SimpleFeature)this.delegate.next();
                for (Object attribute : f.getAttributes()) {
                    if (!(attribute instanceof Geometry)) continue;
                    Geometry geom = (Geometry)attribute;
                    Contains overFilter = this.ff.contains((Expression)this.ff.property(this.dataGeomName), (Expression)this.ff.literal((Object)geom));
                    SimpleFeatureCollection subFeatureCollectionInclusion = this.secondFeatures.subCollection((Filter)overFilter);
                    if (subFeatureCollectionInclusion.size() <= 0) continue;
                    this.next = f;
                }
            }
            return this.next != null;
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("hasNext() returned false!");
            }
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }
    }

    static class IncludedFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        SimpleFeatureCollection features;

        public IncludedFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureCollection features) {
            super(delegate);
            this.features = features;
        }

        public SimpleFeatureIterator features() {
            return new IncludedFeatureIterator(this.delegate.features(), this.delegate, this.features, this.getSchema());
        }
    }
}

