/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@DescribeProcess(title="Simplify", description="Simplifies feature geometry by reducing vertices using Douglas-Peucker simplification.")
public class SimplifyProcess
implements VectorProcess {
    @DescribeResult(name="result", description="The simplified feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="distance", description="Simplification distance tolerance") double distance, @DescribeParameter(name="preserveTopology", description="If True, ensures that simplified features are topologically valid", defaultValue="false") boolean preserveTopology) throws ProcessException {
        if (distance < 0.0) {
            throw new ProcessException("Invalid distance, it should be a positive number");
        }
        return new SimplifyingFeatureCollection(features, distance, preserveTopology);
    }

    static class SimplifyingFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        double distance;
        boolean preserveTopology;
        SimpleFeatureBuilder fb;

        public SimplifyingFeatureIterator(SimpleFeatureIterator delegate, double distance, boolean preserveTopology, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.distance = distance;
            this.preserveTopology = preserveTopology;
            this.fb = new SimpleFeatureBuilder(schema);
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature f = (SimpleFeature)this.delegate.next();
            for (Object attribute : f.getAttributes()) {
                if (attribute instanceof Geometry) {
                    attribute = this.preserveTopology ? TopologyPreservingSimplifier.simplify((Geometry)((Geometry)attribute), (double)this.distance) : DouglasPeuckerSimplifier.simplify((Geometry)((Geometry)attribute), (double)this.distance);
                }
                this.fb.add(attribute);
            }
            return this.fb.buildFeature(f.getID());
        }
    }

    static class SimplifyingFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        double distance;
        boolean preserveTopology;

        public SimplifyingFeatureCollection(SimpleFeatureCollection delegate, double distance, boolean preserveTopology) {
            super(delegate);
            this.distance = distance;
            this.preserveTopology = preserveTopology;
        }

        public SimpleFeatureIterator features() {
            return new SimplifyingFeatureIterator(this.delegate.features(), this.distance, this.preserveTopology, this.getSchema());
        }
    }
}

