/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.DecoratingFeatureIterator;
import org.geotools.feature.collection.PushBackFeatureIterator;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.SortByImpl;
import org.geotools.metadata.i18n.Errors;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.vector.VectorProcess;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.xml.sax.helpers.NamespaceSupport;

@DescribeProcess(title="Group candidate selection", description="Given a collection of features for each group defined only the feature having the MIN or MAX value for the chosen attribute will be included in the final output")
public class GroupCandidateSelectionProcess
implements VectorProcess {
    protected FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public FeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") FeatureCollection features, @DescribeParameter(name="aggregation", description="The aggregate operation to be computed, it can be MAX or MIN", min=1) String aggregation, @DescribeParameter(name="operationAttribute", description="The feature's attribute to be used to compute the aggregation", min=1) String operationAttribute, @DescribeParameter(name="groupingAttributes", description="The feature's attributes defining groups for which perform the filtering based on the aggregation operation and the operation attribute.Consistent results are guaranteed only if the vector process is fed with features already sorted  by these attributes", min=1) List<String> groupingAttributes) {
        try {
            if (features == null) {
                throw new ProcessException(Errors.format((int)143, (Object)"features"));
            }
            if (operationAttribute == null) {
                throw new ProcessException(Errors.format((int)143, (Object)"operationAttribute"));
            }
            if (groupingAttributes == null || groupingAttributes.size() == 0) {
                throw new ProcessException(Errors.format((int)143, (Object)"groupingAttributes"));
            }
            if (aggregation == null) {
                throw new ProcessException(Errors.format((int)143, (Object)"aggregation"));
            }
            Operations op = Operations.valueOf(aggregation);
            FeatureType schema = features.getSchema();
            NamespaceSupport ns = this.declareNamespaces(schema);
            List<PropertyName> groupingPn = groupingAttributes.stream().map(g -> this.validatePropertyName((PropertyName)new AttributeExpressionImpl(g, ns), schema)).collect(Collectors.toList());
            PropertyName opValue = this.validatePropertyName(this.ff.property(operationAttribute, ns), schema);
            return new GroupCandidateSelectionFeatureCollection((FeatureCollection<FeatureType, Feature>)features, groupingPn, opValue, op);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessException(Errors.format((int)12, (Object)"aggregation", (Object)aggregation));
        }
    }

    public Query invertQuery(@DescribeParameter(name="operationAttribute", description="The feature's attribute to be used to compute the aggregation", min=1) String operationAttribute, @DescribeParameter(name="groupingAttributes", description="The feature's attributes defining groups for which perform the filtering based on the aggregation operation and the operation attribute.Consistent results are guaranteed only if the vector process is fed with features already sorted  by these attributes", min=1) List<String> groupingAttributes, Query targetQuery, GridGeometry gridGeometry) {
        List properties = targetQuery.getProperties();
        SortBy[] sorts = targetQuery.getSortBy();
        Query q = targetQuery != null ? new Query(targetQuery) : new Query();
        SortBy[] sortBy = this.buildNewSortBy(sorts, groupingAttributes);
        q.setSortBy(sortBy);
        List<PropertyName> propertiesToAdd = Stream.of(sortBy).map(s -> s.getPropertyName()).collect(Collectors.toList());
        PropertyName operationAttributeProp = this.ff.property(operationAttribute);
        propertiesToAdd.add(operationAttributeProp);
        List<PropertyName> pns = this.getNewProperties(propertiesToAdd, properties);
        q.setProperties(pns);
        return q;
    }

    private SortBy[] buildNewSortBy(SortBy[] sorts, List<String> groupingAttributes) {
        ArrayList<SortByImpl> newSorts = new ArrayList<SortByImpl>(groupingAttributes.size());
        List properties = groupingAttributes.stream().map(s -> this.ff.property(s)).collect(Collectors.toList());
        for (int i = 0; i < properties.size(); ++i) {
            PropertyName pn = (PropertyName)properties.get(i);
            if (this.sortByAlreadyExists(sorts, pn)) continue;
            newSorts.add(new SortByImpl(pn, SortOrder.ASCENDING));
        }
        if (newSorts.size() > 0) {
            if (sorts == null) {
                return newSorts.toArray(new SortBy[newSorts.size()]);
            }
            return (SortBy[])ArrayUtils.addAll((Object[])sorts, (Object[])newSorts.toArray(new SortBy[newSorts.size()]));
        }
        return sorts;
    }

    private List<PropertyName> getNewProperties(List<PropertyName> toAdd, List<PropertyName> originalProperties) {
        HashSet<PropertyName> properties = new HashSet<PropertyName>();
        if (originalProperties != null) {
            properties.addAll(originalProperties);
        }
        if (toAdd != null) {
            properties.addAll(toAdd);
        }
        return new ArrayList<PropertyName>(properties);
    }

    private boolean sortByAlreadyExists(SortBy[] sorts, PropertyName pn) {
        if (sorts == null) {
            return false;
        }
        for (SortBy s : sorts) {
            if (!s.getPropertyName().equals(pn)) continue;
            return true;
        }
        return false;
    }

    private PropertyName validatePropertyName(PropertyName pn, FeatureType schema) {
        if (pn.evaluate((Object)schema) == null) {
            throw new ProcessException("Unable to resolve " + pn.getPropertyName() + " against the FeatureType");
        }
        return pn;
    }

    private NamespaceSupport declareNamespaces(FeatureType type) {
        NamespaceSupport namespaceSupport = null;
        Map namespaces = (Map)type.getUserData().get("declaredNamespacesMap");
        if (namespaces != null) {
            namespaceSupport = new NamespaceSupport();
            for (Map.Entry entry : namespaces.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                namespaceSupport.declarePrefix(prefix, namespace);
            }
        }
        return namespaceSupport;
    }

    static enum Operations {
        MAX("MAX"),
        MIN("MIN");

        private String operation;

        private Operations(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    static class GroupCandidateSelectionIterator
    extends DecoratingFeatureIterator<Feature> {
        private List<PropertyName> groupByAttributes;
        private PropertyName operationAttribute;
        private Operations aggregation;
        private Feature next;

        public GroupCandidateSelectionIterator(PushBackFeatureIterator iterator, List<PropertyName> groupByAttributes, PropertyName operationValue, Operations aggregation) {
            super((FeatureIterator)iterator);
            this.groupByAttributes = groupByAttributes;
            this.operationAttribute = operationValue;
            this.aggregation = aggregation;
        }

        public boolean hasNext() {
            List<Object> groupingValues = new ArrayList<Object>(this.groupByAttributes.size());
            Feature bestFeature = null;
            while (super.hasNext()) {
                Feature f = super.next();
                if (bestFeature == null) {
                    groupingValues = this.getGroupingValues(groupingValues, f);
                    bestFeature = f;
                    continue;
                }
                if (this.featureComparison(groupingValues, f)) {
                    bestFeature = this.updateBestFeature(f, bestFeature);
                    continue;
                }
                ((PushBackFeatureIterator)this.delegate).pushBack();
                break;
            }
            this.next = bestFeature;
            return this.next != null;
        }

        private boolean featureComparison(List<Object> groupingValues, Feature f) {
            ArrayList<Object> toCompareValues = new ArrayList<Object>(groupingValues.size());
            for (PropertyName p : this.groupByAttributes) {
                Object val = p.evaluate((Object)f);
                if (val == null) continue;
                toCompareValues.add(p.evaluate((Object)f));
            }
            if (toCompareValues.size() == 0) {
                toCompareValues = null;
            }
            if (groupingValues == null && toCompareValues == null) {
                return true;
            }
            return groupingValues != null && toCompareValues != null && groupingValues.equals(toCompareValues);
        }

        private List<Object> getGroupingValues(List<Object> groupingValues, Feature f) {
            for (PropertyName p : this.groupByAttributes) {
                Object result = p.evaluate((Object)f);
                groupingValues.add(result);
            }
            if (groupingValues.size() == 0) {
                return null;
            }
            return groupingValues;
        }

        private Feature updateBestFeature(Feature best, Feature f) {
            Comparable bestValue = this.getComparableFromEvaluation(best);
            Comparable value = this.getComparableFromEvaluation(f);
            if (value == null) {
                return best;
            }
            if (bestValue == null) {
                return f;
            }
            if (this.aggregation.equals((Object)Operations.MAX)) {
                return this.findBestMax(best, f, bestValue, value);
            }
            return this.findBestMin(best, f, bestValue, value);
        }

        private Feature findBestMax(Feature best, Feature f, Comparable bestValue, Comparable value) {
            if (bestValue.compareTo(value) < 0) {
                return f;
            }
            return best;
        }

        private Feature findBestMin(Feature best, Feature f, Comparable bestValue, Comparable value) {
            if (bestValue.compareTo(value) > 0) {
                return f;
            }
            return best;
        }

        private Comparable getComparableFromEvaluation(Feature f) {
            Object o = this.operationAttribute.evaluate((Object)f);
            if (o instanceof Property) {
                o = ((Property)o).getValue();
            }
            return (Comparable)o;
        }

        public Feature next() throws NoSuchElementException {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Feature f = this.next;
            this.next = null;
            return f;
        }

        public void close() {
            this.delegate.close();
            this.delegate = null;
            this.next = null;
        }
    }

    static class GroupCandidateSelectionFeatureCollection
    extends DecoratingFeatureCollection<FeatureType, Feature> {
        List<PropertyName> groupingAttributes;
        PropertyName operationAttribute;
        Operations aggregation;

        public GroupCandidateSelectionFeatureCollection(FeatureCollection<FeatureType, Feature> delegate, List<PropertyName> groupingAttributes, PropertyName operationAttribute, Operations aggregation) {
            super(delegate);
            this.groupingAttributes = groupingAttributes;
            this.operationAttribute = operationAttribute;
            this.aggregation = aggregation;
        }

        public FeatureIterator<Feature> features() {
            return new GroupCandidateSelectionIterator(new PushBackFeatureIterator(this.delegate.features()), this.groupingAttributes, this.operationAttribute, this.aggregation);
        }
    }
}

