/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import com.google.common.base.Throwables;
import java.awt.Rectangle;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.gce.pgraster.Mosaic;
import org.geotools.gce.pgraster.PGRasterConfig;
import org.geotools.gce.pgraster.PGRasterFormat;
import org.geotools.gce.pgraster.RasterColumn;
import org.geotools.gce.pgraster.RasterOverview;
import org.geotools.gce.pgraster.ReadRequest;
import org.geotools.gce.pgraster.SQL;
import org.geotools.gce.pgraster.Tile;
import org.geotools.gce.pgraster.TileData;
import org.geotools.gce.pgraster.TileDecoder;
import org.geotools.geometry.GeneralBounds;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class PGRasterReader
extends AbstractGridCoverage2DReader {
    static final Logger LOG = Logging.getLogger(PGRasterReader.class);
    static final GeometryFactory GEOMS = new GeometryFactory();
    final PGRasterConfig config;
    final PGRasterFormat format;
    final RasterColumn raster;
    ExecutorService exec;

    public PGRasterReader(PGRasterConfig config, PGRasterFormat format, Hints hints) throws IOException {
        super((Object)config, hints);
        this.config = config;
        this.format = format;
        try {
            this.raster = RasterColumn.lookup(config);
        }
        catch (SQLException e) {
            throw new IOException("Error looking up raster column", e);
        }
        this.coverageName = config.name != null ? config.name : this.raster.table;
        this.crs = this.raster.crs;
        this.originalEnvelope = GeneralBounds.toGeneralEnvelope((Bounds)this.raster.bounds());
        if (this.raster.scale != null) {
            this.originalGridRange = new GridEnvelope2D(new Rectangle((int)(this.originalEnvelope.getSpan(0) / this.raster.scale.x), (int)(this.originalEnvelope.getSpan(1) / this.raster.scale.y)));
        }
        if (this.raster.scale != null) {
            this.highestRes = new double[]{this.raster.scale.x, this.raster.scale.y};
        }
        this.numOverviews = this.raster.overviews.size();
        if (this.numOverviews > 0) {
            if (this.raster.scale != null) {
                this.overViewResolutions = new double[this.numOverviews][2];
                for (int i = 0; i < this.numOverviews; ++i) {
                    RasterOverview ov = this.raster.overviews.get(i);
                    this.overViewResolutions[i] = new double[]{this.raster.scale.x * (double)ov.factor.intValue(), this.raster.scale.y * (double)ov.factor.intValue()};
                }
            } else {
                this.numOverviews = 0;
            }
        }
        if (hints != null) {
            this.exec = (ExecutorService)hints.get((Object)Hints.EXECUTOR_SERVICE);
        }
    }

    public String name() {
        return this.coverageName;
    }

    public Format getFormat() {
        return this.format;
    }

    public String[] getMetadataNames() {
        if (this.raster.time != null) {
            return new String[]{"HAS_TIME_DOMAIN", "TIME_DOMAIN", "TIME_DOMAIN_MINIMUM", "TIME_DOMAIN_MAXIMUM"};
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getMetadataValue(String coverageName, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    GridCoverage2D compose(Iterator<TileData> tiles, ReadRequest read) throws IOException {
        Mosaic mosaic = new Mosaic(read, this.coverageFactory);
        while (tiles.hasNext()) {
            TileData data = tiles.next();
            try {
                Tile tile = new TileDecoder(data, read).call();
                mosaic.accept(tile);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw new IOException("Error decoding tile", e);
            }
        }
        return mosaic.coverage();
    }

    GridCoverage2D compose(Iterator<TileData> tiles, ReadRequest read, ExecutorService exec) throws IOException {
        ExecutorCompletionService<Tile> work = new ExecutorCompletionService<Tile>(exec);
        int count = 0;
        while (tiles.hasNext()) {
            ++count;
            work.submit(new TileDecoder(tiles.next(), read));
        }
        Mosaic mosaic = new Mosaic(read, this.coverageFactory);
        while (count > 0) {
            try {
                mosaic.accept((Tile)work.take().get());
                --count;
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw new IOException(e);
            }
        }
        return mosaic.coverage();
    }

    Polygon toPolygon(Envelope e) {
        return GEOMS.createPolygon(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMinY())});
    }

    Date queryDateExtreme(String minOrMax, RasterColumn raster) throws SQLException, ParseException {
        SQL sql = new SQL("SELECT ");
        raster.time.select(minOrMax, sql).append(" FROM ").table(raster);
        try (Connection cx = this.newConnection();
             PreparedStatement ps = cx.prepareStatement(sql.logAndGet(LOG));
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                Date date = PGRasterReader.dbDataFormat().parse(rs.getString(1));
                return date;
            }
            LOG.warning("Empty table, unable to calculate " + minOrMax);
        }
        return null;
    }

    public void dispose() {
        this.config.close();
        super.dispose();
    }

    Connection newConnection() throws SQLException {
        Connection cx = this.config.dataSource.getConnection();
        if (this.config.enableDrivers != null) {
            try (Statement st = cx.createStatement();){
                st.execute(String.format("SET postgis.gdal_enabled_drivers = '%s'", this.config.enableDrivers));
            }
        }
        return cx;
    }

    static SimpleDateFormat dbDataFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        return df;
    }

    static SimpleDateFormat utcDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    private static /* synthetic */ void lambda$read$0(SQL sql, SimpleDateFormat df, Date d) {
        sql.append("'").append(df.format(d)).append("',");
    }
}

