/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.gce.pgraster.PGRasterConfig;
import org.geotools.gce.pgraster.RasterOverview;
import org.geotools.gce.pgraster.SQL;
import org.geotools.gce.pgraster.TimeColumn;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

class RasterColumn {
    static final Logger LOG = Logging.getLogger(RasterColumn.class);
    final String name;
    final String table;
    final String schema;
    final List<RasterOverview> overviews = new ArrayList<RasterOverview>();
    Integer srid;
    CoordinateReferenceSystem crs;
    Envelope extent;
    Point2D.Double scale;
    Dimension size;
    Integer numBands;
    TimeColumn time;

    static RasterColumn lookup(PGRasterConfig config) throws SQLException {
        try (Connection cx = config.dataSource.getConnection();){
            SQL sql = new SQL().append("SELECT r_table_schema, r_table_name, r_raster_column, srid, num_bands, ").append("ST_AsText(extent) as extent, scale_x, scale_y").append(" FROM raster_columns").append(" WHERE r_table_name = ?");
            if (config.schema != null) {
                sql.append(" AND r_table_schema = ?");
            }
            if (config.column != null) {
                sql.append(" AND r_raster_column = ?");
            }
            RasterColumn col = null;
            try (PreparedStatement st = cx.prepareStatement(sql.logAndGet(LOG));){
                st.setString(1, config.table);
                if (config.schema != null) {
                    st.setString(2, config.schema);
                }
                if (config.column != null) {
                    st.setString(2 + (config.schema == null ? 0 : 1), config.column);
                }
                try (ResultSet rc = st.executeQuery();){
                    while (rc.next()) {
                        TimeColumn time;
                        int numBands;
                        String extent;
                        if (col != null) {
                            throw new IllegalArgumentException("Multiple raster columns found for table '" + col.tableKey() + "', please specify one in config");
                        }
                        col = new RasterColumn(rc);
                        int srid = rc.getInt("srid");
                        if (srid == 0) {
                            srid = RasterColumn.fetchSrid(col, cx);
                        }
                        if (srid != 0) {
                            col.srid = srid;
                            try {
                                col.crs = CRS.decode((String)("EPSG:" + srid));
                            }
                            catch (Exception e) {
                                LOG.log(Level.WARNING, "Error looking up SRS for srid = " + srid, e);
                            }
                        }
                        if (col.crs == null) {
                            LOG.warning("Unable to determine crs for raster column: " + col.key());
                        }
                        if ((extent = rc.getString("extent")) == null) {
                            extent = RasterColumn.fetchExtent(col, cx);
                        }
                        if (extent != null) {
                            col.extent = RasterColumn.parseExtent(extent);
                        }
                        if (col.extent == null) {
                            LOG.warning("Unable to determine extent for raster column: " + col.key());
                        }
                        Point2D.Double scale = new Point2D.Double(rc.getDouble("scale_x"), rc.getDouble("scale_y"));
                        if (scale.x == 0.0 || scale.y == 0.0) {
                            scale = RasterColumn.fetchScale(col, cx);
                        }
                        if (scale != null && scale.x > 0.0) {
                            col.scale = scale;
                            col.scale.y = Math.abs(col.scale.y);
                        }
                        if (col.scale == null) {
                            LOG.warning("Unable to determine scale for raster column: " + col.key());
                        }
                        if (col.extent != null && col.scale != null) {
                            col.size = new Dimension((int)(col.extent.getWidth() / col.scale.x), (int)(col.extent.getHeight() / col.scale.y));
                        }
                        if ((numBands = rc.getInt("num_bands")) == 0) {
                            numBands = RasterColumn.fetchNumBands(col, cx);
                        }
                        if (numBands > 0) {
                            col.numBands = numBands;
                        }
                        if (!config.time.enabled || (time = RasterColumn.fetchTime(col, config.time, cx)) == null) continue;
                        col.time = time;
                    }
                }
                if (col == null) {
                    String dump = "schema = " + config.schema + ", table = " + config.table + ", column = " + config.column;
                    throw new IllegalArgumentException("No raster column found for config: " + dump);
                }
            }
            sql = new SQL().append("SELECT * FROM raster_overviews").append(" WHERE r_table_name = ?").append(" AND r_table_schema = ?").append(" AND r_raster_column = ?").append(" ORDER BY overview_factor ASC");
            try (CallableStatement ps = cx.prepareCall(sql.logAndGet(LOG));){
                ps.setString(1, col.table);
                ps.setString(2, col.schema);
                ps.setString(3, col.name);
                try (ResultSet ov = ps.executeQuery();){
                    while (ov.next()) {
                        RasterOverview overview = new RasterOverview(ov);
                        overview.extent = RasterColumn.fetchAndParseExtent(overview, cx);
                        col.overview(overview);
                    }
                }
            }
            RasterColumn rasterColumn = col;
            return rasterColumn;
        }
    }

    static int fetchSrid(RasterColumn col, Connection cx) throws SQLException {
        SQL sql = new SQL().append("SELECT srid FROM (").append("SELECT DISTINCT st_srid(").name(col.name).append(") as srid").append(" FROM ").table(col).append(") AS a WHERE srid IS NOT NULL");
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery(sql.logAndGet(LOG));){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    static String fetchExtent(RasterColumn col, Connection cx) throws SQLException {
        SQL sql = new SQL().append("SELECT ST_AsText(ST_Extent(ST_Envelope(").name(col.name).append("::geometry))) AS extent").append(" FROM ").table(col);
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery(sql.logAndGet(LOG));){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    static Envelope parseExtent(String extent) {
        try {
            return new WKTReader().read(extent).getEnvelopeInternal();
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, "Error parsing extent", e);
            return null;
        }
    }

    static Envelope fetchAndParseExtent(RasterColumn col, Connection cx) throws SQLException {
        String e = RasterColumn.fetchExtent(col, cx);
        if (e != null) {
            return RasterColumn.parseExtent(e);
        }
        return null;
    }

    static TimeColumn fetchTime(RasterColumn col, PGRasterConfig.TimeConfig time, Connection cx) throws SQLException {
        SQL sql = new SQL().append("SELECT column_name, data_type").append(" FROM ").append("information_schema.columns").append(" WHERE table_schema = ? AND table_name = ?").append(" AND (").append(" data_type = 'date' OR data_type LIKE 'timestamp %'").append(" )");
        if (time.column != null) {
            sql.append(" AND column_name = ?");
        }
        try (PreparedStatement ps = cx.prepareStatement(sql.logAndGet(LOG));){
            TimeColumn timeColumn;
            block22: {
                ResultSet rs;
                block18: {
                    TimeColumn timeColumn2;
                    block21: {
                        TimeColumn t;
                        block19: {
                            TimeColumn timeColumn3;
                            block20: {
                                ps.setString(1, col.schema);
                                ps.setString(2, col.table);
                                if (time.column != null) {
                                    ps.setString(3, time.column);
                                }
                                rs = ps.executeQuery();
                                try {
                                    if (!rs.next()) break block18;
                                    t = new TimeColumn(rs);
                                    if (!rs.next()) break block19;
                                    LOG.warning("Multiple time columns found for table " + col.tableKey());
                                    timeColumn3 = null;
                                    if (rs == null) break block20;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return timeColumn3;
                        }
                        timeColumn2 = t;
                        if (rs == null) break block21;
                        rs.close();
                    }
                    return timeColumn2;
                }
                timeColumn = null;
                if (rs == null) break block22;
                rs.close();
            }
            return timeColumn;
        }
    }

    static Point2D.Double fetchScale(RasterColumn col, Connection cx) throws SQLException {
        SQL sql = new SQL().append("SELECT ST_ScaleX(").name(col.name).append(") as scale_x,").append(" ST_ScaleY(").name(col.name).append(") as scale_y").append(" FROM ").table(col).append(" LIMIT 1");
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery(sql.logAndGet(LOG));){
            if (rs.next()) {
                Point2D.Double double_ = new Point2D.Double(rs.getDouble(1), rs.getDouble(2));
                return double_;
            }
        }
        return null;
    }

    static int fetchNumBands(RasterColumn col, Connection cx) throws SQLException {
        SQL sql = new SQL().append("SELECT max(ST_NumBands(").name(col.name).append(")) as num_bands").append(" FROM ").table(col).append(" LIMIT 1");
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery(sql.logAndGet(LOG));){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    RasterColumn(String name, String table, String schema) {
        this.name = name;
        this.table = table;
        this.schema = schema;
    }

    RasterColumn(ResultSet rs) throws SQLException {
        this(rs.getString("r_raster_column"), rs.getString("r_table_name"), rs.getString("r_table_schema"));
    }

    String key() {
        return this.schema + "." + this.table + "." + this.name;
    }

    String tableKey() {
        return this.schema + "." + this.table;
    }

    ReferencedEnvelope bounds() {
        return this.extent != null ? new ReferencedEnvelope(this.extent, this.crs) : null;
    }

    void overview(RasterOverview ov) {
        ov.srid = this.srid;
        ov.time = this.time;
        if (ov.extent == null) {
            ov.extent = this.extent;
        }
        if (this.scale != null) {
            ov.scale = new Point2D.Double(this.scale.x * (double)ov.factor.intValue(), this.scale.y * (double)ov.factor.intValue());
            if (this.size != null) {
                ov.size = new Dimension(this.size.width / ov.factor, this.size.height / ov.factor);
            }
        }
        ov.numBands = this.numBands;
        this.overviews.add(ov);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RasterColumn that = (RasterColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.table, that.table) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.table, this.schema);
    }
}

