/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.gce.pgraster.PGRasterConfig;
import org.geotools.gce.pgraster.PGRasterReader;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class PGRasterFormat
extends AbstractGridFormat {
    static final Logger LOG = Logging.getLogger(PGRasterFormat.class);

    public PGRasterFormat() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "PGRaster");
        info.put("description", "PostGIS Raster Mosaic Plugin");
        info.put("vendor", "OpenNRM");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, TIME, OVERVIEW_POLICY}));
        this.writeParameters = null;
    }

    public PGRasterReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public PGRasterReader getReader(Object source, Hints hints) {
        try {
            PGRasterConfig config = this.toConfig(source);
            return config != null ? new PGRasterReader(config, this, hints) : null;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error loading reader", ex);
            return null;
        }
    }

    public boolean accepts(Object source, Hints hints) {
        if (source instanceof DataSource) {
            return true;
        }
        return this.toConfigFile(source) != null;
    }

    File toConfigFile(Object source) {
        File file;
        if (source instanceof Path) {
            source = ((Path)source).toFile();
        }
        if (source instanceof String) {
            source = new File(source.toString());
        }
        if (source instanceof File && (file = (File)source).getName().toLowerCase().endsWith(".xml")) {
            return file;
        }
        return null;
    }

    PGRasterConfig toConfig(Object source) {
        if (source instanceof PGRasterConfig) {
            return (PGRasterConfig)source;
        }
        File file = this.toConfigFile(source);
        if (file != null) {
            return new PGRasterConfig(file);
        }
        return null;
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw this.writeNotSupported();
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw this.writeNotSupported();
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw this.writeNotSupported();
    }

    private UnsupportedOperationException writeNotSupported() {
        return new UnsupportedOperationException("Write support not implemented");
    }
}

