/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.sql.SQLException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PGRasterConfig
implements Closeable {
    static final Logger LOG = Logging.getLogger(PGRasterConfig.class);
    String name;
    DataSource dataSource;
    String schema;
    String table;
    String column;
    String enableDrivers;
    TimeConfig time = new TimeConfig();

    static Document parse(File cfgfile) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating XML parser");
        }
        try {
            return db.parse(cfgfile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing pgraster config", e);
        }
    }

    PGRasterConfig(File configFile) {
        this(PGRasterConfig.parse(configFile));
    }

    PGRasterConfig(Document config) {
        Element root = config.getDocumentElement();
        if (!"pgraster".equalsIgnoreCase(root.getNodeName())) {
            throw new IllegalArgumentException("Not a postgis raster configuration, root element must be 'pgraster'");
        }
        this.name = this.first(root, "name").map(this::nodeValue).orElse(null);
        this.enableDrivers = this.first(root, "enableDrivers").map(this::nodeValue).orElse(null);
        Element db = this.first(config.getDocumentElement(), "database").orElseThrow(() -> new IllegalArgumentException("Config has no database element"));
        Object dataSource = null;
        String jndi = this.first(db, "jndi").map(this::nodeValue).orElse(null);
        if (jndi != null) {
            try {
                dataSource = (DataSource)GeoTools.jndiLookup((String)jndi);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Error performing JNDI lookup for: " + jndi, e);
            }
        }
        if (dataSource == null) {
            BasicDataSource source = new BasicDataSource();
            source.setDriverClassName("org.postgresql.Driver");
            String host = this.first(db, "host").map(this::nodeValue).orElse("localhost");
            Integer port = this.first(db, "port").map(this::nodeValue).map(Integer::parseInt).orElse(5432);
            String name = this.first(db, "name").map(this::nodeValue).orElseThrow(() -> new IllegalArgumentException("database 'name' not specified"));
            source.setUrl("jdbc:postgresql://" + host + ":" + port + "/" + name);
            this.first(db, "user").map(this::nodeValue).ifPresent(arg_0 -> ((BasicDataSource)source).setUsername(arg_0));
            this.first(db, "passwd").map(this::nodeValue).ifPresent(arg_0 -> ((BasicDataSource)source).setPassword(arg_0));
            this.first(db, "pool").ifPresent(p -> {
                this.first((Element)p, "min").map(this::nodeValue).map(Integer::parseInt).ifPresent(arg_0 -> ((BasicDataSource)source).setMinIdle(arg_0));
                this.first((Element)p, "max").map(this::nodeValue).map(Integer::parseInt).ifPresent(arg_0 -> ((BasicDataSource)source).setMaxActive(arg_0));
            });
            dataSource = new PGRasterDataSource(source);
        }
        this.dataSource = dataSource;
        Element ras = this.first(config.getDocumentElement(), "raster").orElseThrow(() -> new IllegalArgumentException("Config has no 'raster' element"));
        this.schema = this.first(ras, "schema").map(this::nodeValue).orElse("public");
        this.table = this.first(ras, "table").map(this::nodeValue).orElseThrow(() -> new IllegalArgumentException("column must specify a 'table' element"));
        this.column = this.first(ras, "column").map(this::nodeValue).orElse(null);
        this.first(config.getDocumentElement(), "time").ifPresent(el -> {
            this.first((Element)el, "enabled").map(this::nodeValue).map(Boolean::parseBoolean).ifPresent(it -> {
                this.time.enabled = it;
            });
            this.first((Element)el, "column").map(this::nodeValue).ifPresent(it -> {
                this.time.column = it;
            });
        });
    }

    @VisibleForTesting
    PGRasterConfig() {
    }

    Optional<Element> first(Element el, String name) {
        NodeList matches = el.getElementsByTagName(name);
        if (matches.getLength() > 0) {
            return Optional.of((Element)matches.item(0));
        }
        return Optional.empty();
    }

    String nodeValue(Element el) {
        return el.getFirstChild().getNodeValue();
    }

    @Override
    public void close() {
        if (this.dataSource instanceof PGRasterDataSource) {
            try {
                ((PGRasterDataSource)((Object)this.dataSource)).close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Error closing data source", e);
            }
        }
    }

    static class PGRasterDataSource
    extends DBCPDataSource {
        PGRasterDataSource(BasicDataSource wrapped) {
            super(wrapped);
        }
    }

    static class TimeConfig {
        boolean enabled = true;
        String column;

        TimeConfig() {
        }
    }
}

