/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.geotools.gce.pgraster.ReadRequest;
import org.geotools.gce.pgraster.Tile;
import org.geotools.gce.pgraster.TileData;
import org.locationtech.jts.geom.Envelope;

public class TileDecoder
implements Callable<Tile> {
    final TileData data;
    final ReadRequest read;

    TileDecoder(TileData data, ReadRequest read) {
        this.data = data;
        this.read = read;
    }

    @Override
    public Tile call() throws Exception {
        Tile tile;
        Envelope bounds = this.data.bounds;
        if (!this.read.nativeBounds.intersects(bounds)) {
            return Tile.NULL;
        }
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.data.bytes));
        if (!this.read.nativeBounds.contains(bounds)) {
            Envelope clippedBounds = bounds.intersection((Envelope)this.read.nativeBounds);
            double scaleX = (double)image.getWidth() / bounds.getWidth();
            double scaleY = (double)image.getHeight() / bounds.getHeight();
            int x = (int)Math.round((clippedBounds.getMinX() - bounds.getMinX()) * scaleX);
            int y = (int)Math.round((clippedBounds.getMaxY() - bounds.getMinY()) * scaleY);
            y = image.getHeight() - y;
            int w = (int)Math.round((double)image.getWidth() / bounds.getWidth() * clippedBounds.getWidth());
            int h = (int)Math.round((double)image.getHeight() / bounds.getHeight() * clippedBounds.getHeight());
            if (w > 0 && h > 0) {
                image = image.getSubimage(x, y, w, h);
                tile = new Tile(image, clippedBounds);
            } else {
                tile = Tile.NULL;
            }
        } else {
            tile = new Tile(image, bounds);
        }
        return tile;
    }
}

