/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.temporal;

import static org.opengis.annotation.Specification.ISO_19108;

import org.opengis.annotation.UML;

/**
 * Represents a single non-decomposable element of topology and its relationships to other
 * topological primitives within a topological complex.
 *
 * @author Alexander Petkov
 */
@UML(identifier = "TM_TopologicalPrimitive", specification = ISO_19108)
public interface TemporalTopologicalPrimitive {}
