/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr.jni;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.geotools.data.ogr.OGR;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Version;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JniOGR
implements OGR {
    private static final Method GET_FIELD_METHOD;
    private static final boolean USE_FLOAT_SECONDS;

    Vector<String> vector(String[] opts) {
        return opts != null && opts.length > 0 ? new Vector<String>(Arrays.asList(opts)) : null;
    }

    public boolean IsGEOSEnabled() {
        boolean isGEOSEnabled = false;
        Geometry g1 = Geometry.CreateFromWkt((String)"POINT (1 1)");
        Geometry g2 = Geometry.CreateFromWkt((String)"POINT (2 2)");
        try {
            g1.Touches(g2);
            if (!this.GetLastErrorMsg().toLowerCase().contains("GEOS support not enabled".toLowerCase())) {
                isGEOSEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isGEOSEnabled;
    }

    public String getVersion() {
        return gdal.VersionInfo((String)"RELEASE_NAME");
    }

    public int GetDriverCount() {
        return ogr.GetDriverCount();
    }

    public Object GetDriver(int i) {
        return ogr.GetDriver((int)i);
    }

    public Object GetDriverByName(String name) {
        return ogr.GetDriverByName((String)name);
    }

    public Object OpenShared(String dataSourceName, int mode) {
        return ogr.OpenShared((String)dataSourceName, (int)mode);
    }

    public Object Open(String dataSourceName, int mode) {
        return ogr.Open((String)dataSourceName, (int)mode);
    }

    public void CheckError(int code) throws IOException {
        if (code == 0) {
            return;
        }
        String error = this.GetLastErrorMsg();
        switch (code) {
            case 5: {
                throw new IOException("OGR reported a currupt data error: " + error);
            }
            case 6: {
                throw new IOException("OGR reported a generic failure: " + error);
            }
            case 1: {
                throw new IOException("OGR reported not enough data was provided in the last call: " + error);
            }
            case 2: {
                throw new IOException("OGR reported not enough memory is available: " + error);
            }
            case 3: {
                throw new IOException("OGR reported a unsupported geometry type error: " + error);
            }
            case 4: {
                throw new IOException("OGR reported a unsupported operation error: " + error);
            }
            case 7: {
                throw new IOException("OGR reported a unsupported SRS error: " + error);
            }
        }
        throw new IOException("OGR reported an unrecognized error code: " + code);
    }

    public String GetLastErrorMsg() {
        return gdal.GetLastErrorMsg();
    }

    public String DriverGetName(Object driver) {
        return ((Driver)driver).GetName();
    }

    public Object DriverOpen(Object driver, String dataSourceName, int mode) {
        return ((Driver)driver).Open(dataSourceName, mode);
    }

    public Object DriverCreateDataSource(Object driver, String dataSourceName, String[] opts) {
        return ((Driver)driver).CreateDataSource(dataSourceName, this.vector(opts));
    }

    public void DriverRelease(Object driver) {
        ((Driver)driver).delete();
    }

    public Object DataSourceGetDriver(Object dataSource) {
        return ((DataSource)dataSource).GetDriver();
    }

    public int DataSourceGetLayerCount(Object dataSource) {
        return ((DataSource)dataSource).GetLayerCount();
    }

    public Object DataSourceGetLayer(Object dataSource, int i) {
        return ((DataSource)dataSource).GetLayer(i);
    }

    public Object DataSourceGetLayerByName(Object dataSource, String name) {
        return ((DataSource)dataSource).GetLayerByName(name);
    }

    public void DataSourceRelease(Object dataSource) {
        ((DataSource)dataSource).delete();
    }

    public Object DataSourceCreateLayer(Object dataSource, String name, Object srs, long geomType, String[] opts) {
        return ((DataSource)dataSource).CreateLayer(name, (SpatialReference)srs, (int)geomType, this.vector(opts));
    }

    public Object DataSourceExecuteSQL(Object dataSource, String sql, Object spatialFilter) {
        return ((DataSource)dataSource).ExecuteSQL(sql, (Geometry)spatialFilter);
    }

    public Object LayerGetLayerDefn(Object layer) {
        return ((Layer)layer).GetLayerDefn();
    }

    public int LayerGetFieldCount(Object layerDefn) {
        return ((FeatureDefn)layerDefn).GetFieldCount();
    }

    public Object LayerGetFieldDefn(Object layerDefn, int i) {
        return ((FeatureDefn)layerDefn).GetFieldDefn(i);
    }

    public String LayerGetName(Object layer) {
        return ((Layer)layer).GetName();
    }

    public long LayerGetGeometryType(Object layerDefn) {
        return ((FeatureDefn)layerDefn).GetGeomType();
    }

    public Object LayerGetSpatialRef(Object layer) {
        return ((Layer)layer).GetSpatialRef();
    }

    public Object LayerGetExtent(Object layer) {
        return ((Layer)layer).GetExtent();
    }

    public long LayerGetFeatureCount(Object layer) {
        return ((Layer)layer).GetFeatureCount();
    }

    public void LayerRelease(Object layer) {
        ((Layer)layer).delete();
    }

    public void LayerReleaseLayerDefn(Object layerDefn) {
        ((FeatureDefn)layerDefn).delete();
    }

    public boolean LayerCanDeleteFeature(Object layer) {
        return ((Layer)layer).TestCapability("DeleteFeature");
    }

    public boolean LayerCanWriteRandom(Object layer) {
        return ((Layer)layer).TestCapability("RandomWrite");
    }

    public boolean LayerCanWriteSequential(Object layer) {
        return ((Layer)layer).TestCapability("SequentialWrite");
    }

    public boolean LayerCanCreateField(Object layer) {
        return ((Layer)layer).TestCapability("CreateField");
    }

    public boolean LayerCanIgnoreFields(Object layer) {
        return ((Layer)layer).TestCapability("IgnoreFields");
    }

    public void LayerCreateField(Object layer, Object fieldDefn, int approx) {
        ((Layer)layer).CreateField((FieldDefn)fieldDefn, approx);
    }

    public void LayerSyncToDisk(Object layer) {
        ((Layer)layer).SyncToDisk();
    }

    public Object LayerNewFeature(Object layerDefn) {
        return new Feature((FeatureDefn)layerDefn);
    }

    public ReferencedEnvelope toEnvelope(Object extent, CoordinateReferenceSystem crs) {
        double[] d = (double[])extent;
        return new ReferencedEnvelope(d[0], d[1], d[2], d[3], crs);
    }

    public void LayerSetSpatialFilter(Object layer, Object geometry) {
        ((Layer)layer).SetSpatialFilter((Geometry)geometry);
    }

    public void LayerSetAttributeFilter(Object layer, String attFilter) {
        ((Layer)layer).SetAttributeFilter(attFilter);
    }

    public int LayerSetIgnoredFields(Object layer, String[] fields) {
        return ((Layer)layer).SetIgnoredFields(this.vector(fields));
    }

    public void LayerResetReading(Object layer) {
        ((Layer)layer).ResetReading();
    }

    public Object LayerGetNextFeature(Object layer) {
        return ((Layer)layer).GetNextFeature();
    }

    public boolean LayerDeleteFeature(Object layer, long fid) {
        return ((Layer)layer).DeleteFeature((long)((int)fid)) == 0;
    }

    public int LayerSetFeature(Object layer, Object feature) {
        return ((Layer)layer).SetFeature((Feature)feature);
    }

    public int LayerCreateFeature(Object layer, Object feature) {
        return ((Layer)layer).CreateFeature((Feature)feature);
    }

    public String LayerGetFIDColumnName(Object layer) {
        return ((Layer)layer).GetFIDColumn();
    }

    public String FieldGetName(Object field) {
        return ((FieldDefn)field).GetName();
    }

    public long FieldGetType(Object field) {
        return ((FieldDefn)field).GetFieldType();
    }

    public int FieldGetWidth(Object field) {
        return ((FieldDefn)field).GetWidth();
    }

    public void FieldSetWidth(Object field, int width) {
        ((FieldDefn)field).SetWidth(width);
    }

    public void FieldSetJustifyRight(Object field) {
        ((FieldDefn)field).SetJustify(2);
    }

    public void FieldSetPrecision(Object field, int precision) {
        ((FieldDefn)field).SetPrecision(precision);
    }

    public boolean FieldIsIntegerType(long type) {
        return type == 0L;
    }

    public boolean FieldIsRealType(long type) {
        return type == 2L;
    }

    public boolean FieldIsBinaryType(long type) {
        return type == 8L;
    }

    public boolean FieldIsDateType(long type) {
        return type == 9L;
    }

    public boolean FieldIsTimeType(long type) {
        return type == 10L;
    }

    public boolean FieldIsDateTimeType(long type) {
        return type == 11L;
    }

    public boolean FieldIsIntegerListType(long type) {
        return type == 1L;
    }

    public boolean FieldIsRealListType(long type) {
        return type == 3L;
    }

    public Object CreateStringField(String name) {
        return new FieldDefn(name, 4);
    }

    public Object CreateIntegerField(String name) {
        return new FieldDefn(name, 0);
    }

    public Object CreateRealField(String name) {
        return new FieldDefn(name, 2);
    }

    public Object CreateBinaryField(String name) {
        return new FieldDefn(name, 8);
    }

    public Object CreateDateField(String name) {
        return new FieldDefn(name, 9);
    }

    public Object CreateTimeField(String name) {
        return new FieldDefn(name, 10);
    }

    public Object CreateDateTimeField(String name) {
        return new FieldDefn(name, 11);
    }

    public long FeatureGetFID(Object feature) {
        return ((Feature)feature).GetFID();
    }

    public boolean FeatureIsFieldSet(Object feature, int i) {
        return ((Feature)feature).IsFieldSet(i);
    }

    public void FeatureSetGeometryDirectly(Object feature, Object geometry) {
        ((Feature)feature).SetGeometryDirectly((Geometry)geometry);
    }

    public Object FeatureGetGeometry(Object feature) {
        return ((Feature)feature).GetGeometryRef();
    }

    public void FeatureUnsetField(Object feature, int i) {
        ((Feature)feature).UnsetField(i);
    }

    public void FeatureSetFieldInteger(Object feature, int field, int value) {
        ((Feature)feature).SetField(field, value);
    }

    public void FeatureSetFieldDouble(Object feature, int field, double value) {
        ((Feature)feature).SetField(field, value);
    }

    public void FeatureSetFieldBinary(Object feature, int field, int length, byte[] value) {
    }

    public void FeatureSetFieldDateTime(Object feature, int field, int year, int month, int day, int hour, int minute, int second, int tz) {
        ((Feature)feature).SetField(field, year, month, day, hour, minute, (float)second, tz);
    }

    public void FeatureSetFieldString(Object feature, int field, String str) {
        ((Feature)feature).SetField(field, str);
    }

    public String FeatureGetFieldAsString(Object feature, int i) {
        return ((Feature)feature).GetFieldAsString(i);
    }

    public int FeatureGetFieldAsInteger(Object feature, int i) {
        return ((Feature)feature).GetFieldAsInteger(i);
    }

    public double FeatureGetFieldAsDouble(Object feature, int i) {
        return ((Feature)feature).GetFieldAsDouble(i);
    }

    public void FeatureGetFieldAsDateTime(Object feature, int i, int[] year, int[] month, int[] day, int[] hour, int[] minute, int[] second, int[] tzFlag) {
        try {
            if (USE_FLOAT_SECONDS) {
                float[] secondFloat = new float[second.length];
                GET_FIELD_METHOD.invoke(feature, i, year, month, day, hour, minute, secondFloat, tzFlag);
                for (int j = 0; j < second.length; ++j) {
                    second[j] = (int)secondFloat[j];
                }
            } else {
                GET_FIELD_METHOD.invoke(feature, i, year, month, day, hour, minute, second, tzFlag);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception found while retrieving a datetime field, using float seconds: " + USE_FLOAT_SECONDS + " and method " + GET_FIELD_METHOD, e);
        }
    }

    public void FeatureDestroy(Object feature) {
        ((Feature)feature).delete();
    }

    public long GetPointType() {
        return 1L;
    }

    public long GetPoint25DType() {
        return -2147483647L;
    }

    public long GetLinearRingType() {
        return 101L;
    }

    public long GetLineStringType() {
        return 2L;
    }

    public long GetLineString25DType() {
        return -2147483646L;
    }

    public long GetPolygonType() {
        return 3L;
    }

    public long GetPolygon25DType() {
        return -2147483645L;
    }

    public long GetMultiPointType() {
        return 4L;
    }

    public long GetMultiLineStringType() {
        return 5L;
    }

    public long GetMultiLineString25DType() {
        return -2147483643L;
    }

    public long GetMultiPolygonType() {
        return 6L;
    }

    public long GetMultiPolygon25DType() {
        return -2147483642L;
    }

    public long GetGeometryCollectionType() {
        return 7L;
    }

    public long GetGeometryCollection25DType() {
        return -2147483641L;
    }

    public long GetGeometryNoneType() {
        return 100L;
    }

    public long GetGeometryUnknownType() {
        return 0L;
    }

    public int GeometryGetWkbSize(Object geom) {
        return ((Geometry)geom).WkbSize();
    }

    public int GeometryExportToWkb(Object geom, byte[] wkb) {
        return ((Geometry)geom).ExportToWkb(wkb, 0);
    }

    public Object GeometryCreateFromWkb(byte[] wkb, int[] ret) {
        return Geometry.CreateFromWkb((byte[])wkb);
    }

    public String GeometryExportToWkt(Object geom, int[] ret) {
        return ((Geometry)geom).ExportToWkt();
    }

    public Object GeometryCreateFromWkt(String wkt, int[] ret) {
        return Geometry.CreateFromWkt((String)wkt);
    }

    public void GeometryDestroy(Object geometry) {
        ((Geometry)geometry).delete();
    }

    public String SpatialRefGetAuthorityCode(Object spatialRef, String authority) {
        return ((SpatialReference)spatialRef).GetAuthorityCode(authority);
    }

    public String SpatialRefExportToWkt(Object spatialRef) {
        return ((SpatialReference)spatialRef).ExportToWkt();
    }

    public void SpatialRefRelease(Object spatialRef) {
        ((SpatialReference)spatialRef).delete();
    }

    public Object NewSpatialRef(String wkt) {
        return new SpatialReference(wkt);
    }

    static {
        if (ogr.GetDriverCount() == 0) {
            ogr.RegisterAll();
        }
        Method getFieldAsDateTime = null;
        for (Method method : Feature.class.getDeclaredMethods()) {
            if (!method.getName().equals("GetFieldAsDateTime") || method.getParameterTypes().length != 8 || !Integer.TYPE.equals(method.getParameterTypes()[0])) continue;
            getFieldAsDateTime = method;
        }
        if (getFieldAsDateTime == null) {
            throw new RuntimeException("Could not locate the desired GetFieldAsDateTime method from Feature");
        }
        GET_FIELD_METHOD = getFieldAsDateTime;
        USE_FLOAT_SECONDS = new Version(gdal.VersionInfo((String)"RELEASE_NAME")).compareTo(new Version("2.0.0")) >= 0;
    }
}

