/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.TestData;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.URLs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public abstract class TestCaseSupport {
    static final String STATE_POP = "shapes/statepop.shp";
    static final String MIXED = "mif/mixed.MIF";
    protected static boolean verbose = false;
    private Class<? extends OGRDataStoreFactory> dataStoreFactoryClass;
    protected OGRDataStoreFactory dataStoreFactory;
    protected OGR ogr;
    private final List<File> tmpFiles = new ArrayList<File>();
    private static Boolean AVAILABLE;

    protected TestCaseSupport(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        this.dataStoreFactoryClass = dataStoreFactoryClass;
    }

    protected OGRDataStoreFactory createDataStoreFactory() {
        try {
            return this.dataStoreFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean gdalAvailable() {
        if (AVAILABLE == null) {
            try {
                this.createDataStoreFactory().isAvailable(false);
                AVAILABLE = true;
            }
            catch (Throwable e) {
                AVAILABLE = false;
            }
        }
        return AVAILABLE;
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((String)"Skipping test, GDAL is not available", (boolean)this.gdalAvailable());
        this.dataStoreFactory = this.createDataStoreFactory();
        this.ogr = this.dataStoreFactory.createOGR();
    }

    @After
    public void tearDown() throws Exception {
        Iterator<File> f = this.tmpFiles.iterator();
        while (f.hasNext()) {
            File targetFile = f.next();
            targetFile.deleteOnExit();
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "dbf"));
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "shx"));
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "qix"));
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "fix"));
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "prj"));
            this.dieDieDIE(TestCaseSupport.sibling(targetFile, "shp.xml"));
            f.remove();
        }
    }

    private void dieDieDIE(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    private static File sibling(File f, String ext) {
        return new File(f.getParent(), TestCaseSupport.sibling(f.getName(), ext));
    }

    private static String sibling(String name, String ext) {
        int s = name.lastIndexOf(46);
        if (s >= 0) {
            name = name.substring(0, s);
        }
        return name + "." + ext;
    }

    protected Geometry readGeometry(String wktResource) throws IOException {
        try (LineNumberReader stream = TestData.openReader((String)("wkt/" + wktResource + ".wkt"));){
            WKTReader reader = new WKTReader();
            try {
                Geometry geometry = reader.read((Reader)stream);
                return geometry;
            }
            catch (ParseException pe) {
                IOException e = new IOException("parsing error in resource " + wktResource);
                e.initCause(pe);
                throw e;
            }
        }
    }

    protected SimpleFeature firstFeature(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) {
        try (FeatureIterator features = fc.features();){
            SimpleFeature simpleFeature = (SimpleFeature)features.next();
            return simpleFeature;
        }
    }

    protected File getTempFile(String filePrefix, String extension) throws IOException {
        File tmpFile = File.createTempFile(filePrefix, extension, new File("./target"));
        Assert.assertTrue((boolean)tmpFile.isFile());
        this.markTempFile(tmpFile);
        return tmpFile;
    }

    private void markTempFile(File tmpFile) {
        this.tmpFiles.add(tmpFile);
    }

    protected void copy(String name, String[] requiredExtensions, String[] optionalExtensions) throws IOException {
        for (String requiredExtension : requiredExtensions) {
            Assert.assertTrue((boolean)TestData.copy((Object)this, (String)TestCaseSupport.sibling(name, requiredExtension)).canRead());
        }
        for (String optionalExtension : optionalExtensions) {
            try {
                Assert.assertTrue((boolean)TestData.copy((Object)this, (String)TestCaseSupport.sibling(name, optionalExtension)).canRead());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    protected String getAbsolutePath(String testData) throws IOException {
        if (testData.endsWith(".shp")) {
            this.copy(testData, new String[]{"shp", "dbf", "shx"}, new String[]{"prj"});
        } else if (testData.endsWith(".MIF")) {
            this.copy(testData, new String[]{"MIF", "MID"}, new String[0]);
        } else if (testData.endsWith(".tab")) {
            this.copy(testData, new String[]{"tab", "dat", "id", "map"}, new String[0]);
        }
        File f = URLs.urlToFile((URL)TestData.url((Object)this, (String)testData));
        return f.getAbsolutePath();
    }

    protected boolean ogrSupports(String format) {
        return this.dataStoreFactory.getAvailableDrivers().contains(format);
    }
}

