/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.data.ogr.FilterToRestrictedWhere;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.locationtech.jts.geom.Geometry;

class OGRFilterTranslator {
    static final FilterCapabilities ATTRIBUTE_FILTER_CAPABILITIES = new FilterCapabilities();
    static final FilterCapabilities GEOMETRY_FILTER_CAPABILITIES;
    static final FilterCapabilities STRICT_GEOMETRY_FILTER_CAPABILITIES;
    static final FilterCapabilities EXTENDED_FILTER_CAPABILITIES;
    private SimpleFeatureType schema;
    private Filter filter;

    public OGRFilterTranslator(SimpleFeatureType schema, Filter filter) {
        this.schema = schema;
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        this.filter = (Filter)filter.accept((FilterVisitor)simplifier, null);
    }

    public boolean isFilterFullySupported() {
        if (this.filter == Filter.INCLUDE || this.filter == Filter.EXCLUDE) {
            return true;
        }
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(ATTRIBUTE_FILTER_CAPABILITIES, this.schema, null);
        this.filter.accept((FilterVisitor)visitor, null);
        Filter postFilter = visitor.getFilterPost();
        return postFilter == Filter.INCLUDE || postFilter instanceof BBOX;
    }

    public Filter getPostFilter() {
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(STRICT_GEOMETRY_FILTER_CAPABILITIES, this.schema, null);
        this.filter.accept((FilterVisitor)visitor, null);
        Filter preFilter = visitor.getFilterPre();
        if (preFilter == null || preFilter instanceof BBOX) {
            visitor = new PostPreProcessFilterSplittingVisitor(EXTENDED_FILTER_CAPABILITIES, this.schema, null);
            this.filter.accept((FilterVisitor)visitor, null);
            return visitor.getFilterPost();
        }
        visitor = new PostPreProcessFilterSplittingVisitor(ATTRIBUTE_FILTER_CAPABILITIES, this.schema, null);
        this.filter.accept((FilterVisitor)visitor, null);
        return visitor.getFilterPost();
    }

    public Geometry getSpatialFilter() {
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(GEOMETRY_FILTER_CAPABILITIES, this.schema, null);
        this.filter.accept((FilterVisitor)visitor, null);
        Filter preFilter = visitor.getFilterPre();
        if (preFilter instanceof BinarySpatialOperator) {
            BinarySpatialOperator bso = (BinarySpatialOperator)preFilter;
            Expression geomExpression = null;
            if (bso.getExpression1() instanceof PropertyName && bso.getExpression2() instanceof Literal) {
                geomExpression = bso.getExpression2();
            } else if (bso.getExpression1() instanceof Literal && bso.getExpression2() instanceof PropertyName) {
                geomExpression = bso.getExpression1();
            }
            if (geomExpression != null) {
                Geometry geom = (Geometry)geomExpression.evaluate(null, Geometry.class);
                return geom;
            }
        }
        return null;
    }

    public String getAttributeFilter() {
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(ATTRIBUTE_FILTER_CAPABILITIES, this.schema, null);
        this.filter.accept((FilterVisitor)visitor, null);
        Filter preFilter = visitor.getFilterPre();
        if (preFilter != Filter.EXCLUDE && preFilter != Filter.INCLUDE) {
            FilterToRestrictedWhere sqlConverter = new FilterToRestrictedWhere(this.schema);
            preFilter.accept((FilterVisitor)sqlConverter, null);
            return sqlConverter.getRestrictedWhere();
        }
        return null;
    }

    public Filter getFilter() {
        return this.filter;
    }

    static {
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsBetween.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsEqualTo.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsNotEqualTo.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsGreaterThan.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsLessThan.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsGreaterThanOrEqualTo.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsLessThanOrEqualTo.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(PropertyIsLessThanOrEqualTo.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(Or.class);
        ATTRIBUTE_FILTER_CAPABILITIES.addType(And.class);
        GEOMETRY_FILTER_CAPABILITIES = new FilterCapabilities();
        GEOMETRY_FILTER_CAPABILITIES.addType(BBOX.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Contains.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Crosses.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Equals.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Intersects.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Overlaps.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Touches.class);
        GEOMETRY_FILTER_CAPABILITIES.addType(Within.class);
        STRICT_GEOMETRY_FILTER_CAPABILITIES = new FilterCapabilities();
        STRICT_GEOMETRY_FILTER_CAPABILITIES.addType(BBOX.class);
        EXTENDED_FILTER_CAPABILITIES = new FilterCapabilities();
        EXTENDED_FILTER_CAPABILITIES.addAll(ATTRIBUTE_FILTER_CAPABILITIES);
        EXTENDED_FILTER_CAPABILITIES.addAll(STRICT_GEOMETRY_FILTER_CAPABILITIES);
    }
}

