/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.ogr.FeatureMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.locationtech.jts.geom.GeometryFactory;

class OGRFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    OGRDataSource dataSource;
    Object layer;
    SimpleFeatureType schema;
    Object curr;
    private FeatureMapper mapper;
    boolean layerCompleted;
    OGR ogr;

    public OGRFeatureReader(OGRDataSource dataSource, Object layer, SimpleFeatureType targetSchema, SimpleFeatureType originalSchema, GeometryFactory gf, OGR ogr) {
        this.dataSource = dataSource;
        this.layer = layer;
        this.schema = targetSchema;
        ogr.LayerResetReading(layer);
        this.layerCompleted = false;
        this.mapper = new FeatureMapper(targetSchema, layer, gf, ogr);
        this.ogr = ogr;
    }

    public void close() throws IOException {
        if (this.curr != null) {
            this.ogr.FeatureDestroy(this.curr);
            this.curr = null;
        }
        if (this.layer != null) {
            this.ogr.LayerRelease(this.layer);
            this.layer = null;
        }
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
        this.schema = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public boolean hasNext() throws IOException {
        if (this.layerCompleted) {
            return false;
        }
        if (this.curr == null) {
            this.curr = this.ogr.LayerGetNextFeature(this.layer);
        }
        if (this.curr != null) {
            return true;
        }
        this.layerCompleted = true;
        return false;
    }

    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There are no more Features to be read");
        }
        SimpleFeature f = this.mapper.convertOgrFeature(this.curr);
        this.ogr.FeatureDestroy(this.curr);
        this.curr = null;
        return f;
    }
}

