/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.awt.RenderingHints;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class FilterToRestrictedWhere
implements FilterVisitor,
ExpressionVisitor {
    static final Logger LOGGER = Logging.getLogger(FilterToRestrictedWhere.class);
    protected static final String IO_ERROR = "io problem writing filter";
    protected SimpleFeatureType featureType;
    StringWriter out = new StringWriter();

    public FilterToRestrictedWhere(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public String getRestrictedWhere() {
        return this.out.toString();
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        AttributeDescriptor attType = (AttributeDescriptor)expr.evaluate((Object)this.featureType);
        Class context = attType != null ? attType.getType().getBinding() : String.class;
        this.out.write("((");
        expr.accept((ExpressionVisitor)this, extraData);
        this.out.write(">=");
        lowerbounds.accept((ExpressionVisitor)this, (Object)context);
        this.out.write(") AND (");
        expr.accept((ExpressionVisitor)this, extraData);
        this.out.write("<=");
        upperbounds.accept((ExpressionVisitor)this, (Object)context);
        this.out.write("))");
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"AND");
    }

    public Object visit(Or filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"OR");
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        String type = (String)extraData;
        this.out.write("(");
        Iterator list = filter.getChildren().iterator();
        while (list.hasNext()) {
            ((Filter)list.next()).accept((FilterVisitor)this, extraData);
            if (!list.hasNext()) continue;
            this.out.write(" " + type + " ");
        }
        this.out.write(")");
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">");
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<");
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<=");
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "!=");
        return extraData;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        AttributeDescriptor attType;
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class leftContext = null;
        Class rightContext = null;
        if (left instanceof PropertyName && (attType = (AttributeDescriptor)left.evaluate((Object)this.featureType)) != null) {
            rightContext = attType.getType().getBinding();
        }
        if (rightContext == null && right instanceof PropertyName && (attType = (AttributeDescriptor)right.evaluate((Object)this.featureType)) != null) {
            leftContext = attType.getType().getBinding();
        }
        String type = (String)extraData;
        left.accept((ExpressionVisitor)this, leftContext);
        this.out.write(" " + type + " ");
        right.accept((ExpressionVisitor)this, (Object)rightContext);
    }

    public Object visit(PropertyName expression, Object extraData) throws RuntimeException {
        AttributeDescriptor attribute = null;
        try {
            attribute = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error occurred mapping " + expression + " to feature type", e);
        }
        String name = null;
        name = attribute != null ? attribute.getLocalName() : expression.getPropertyName();
        this.out.write(name);
        return extraData;
    }

    public Object visit(Literal expression, Object context) throws RuntimeException {
        Class target = null;
        if (context instanceof Class) {
            target = (Class)context;
        }
        Object literal = this.evaluateLiteral(expression, target);
        this.writeLiteral(literal);
        return context;
    }

    protected Object evaluateLiteral(Literal expression, Class<?> target) {
        Object literal = null;
        if (target != null) {
            literal = Number.class.isAssignableFrom(target) ? Converters.convert((Object)expression.evaluate(null), target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true)) : expression.evaluate(null, target);
        }
        if (literal == null) {
            literal = expression.evaluate(null);
        }
        if (literal == null) {
            literal = expression.getValue();
        }
        return literal;
    }

    protected void writeLiteral(Object literal) {
        if (literal == null) {
            this.out.write("NULL");
        } else if (literal instanceof Number || literal instanceof Boolean) {
            this.out.write(String.valueOf(literal));
        } else {
            String encoding = (String)Converters.convert((Object)literal, String.class, null);
            if (encoding == null) {
                encoding = literal.toString();
            }
            String escaped = encoding.replaceAll("'", "''");
            this.out.write("'" + escaped + "'");
        }
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Function expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visitNullFilter(Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Id filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Not filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(BBOX filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Contains filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Disjoint filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Equals filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Intersects filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Within filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(After after, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Before before, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(During during, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("Can't encode this expression");
    }
}

