/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.data.ogr.FeatureMapper;
import org.geotools.data.ogr.FeatureTypeMapper;
import org.geotools.data.ogr.GeometryMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.geotools.data.ogr.OGRDataSourcePool;
import org.geotools.data.ogr.OGRFeatureSource;
import org.geotools.data.ogr.OGRFeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class OGRDataStore
extends ContentDataStore {
    OGRDataSourcePool dataSourcePool;
    OGR ogr;
    String ogrSourceName;
    String ogrDriver;

    public OGRDataStore(String ogrName, String ogrDriver, URI namespace, OGR ogr, OGRDataSourcePool dataSourcePool) {
        if (namespace != null) {
            this.setNamespaceURI(namespace.toString());
        }
        this.ogrSourceName = ogrName;
        this.ogrDriver = ogrDriver;
        this.ogr = ogr;
        this.dataSourcePool = dataSourcePool;
    }

    public OGRDataStore(String ogrName, String ogrDriver, URI namespace, OGR ogr) throws IOException {
        this(ogrName, ogrDriver, namespace, ogr, new OGRDataSourcePool(ogr, ogrName, ogrDriver, Collections.emptyMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Name> createTypeNames() throws IOException {
        OGRDataSource dataSource = null;
        Object layer = null;
        try {
            dataSource = this.openOGRDataSource(false);
            ArrayList<Name> result = new ArrayList<Name>();
            int count = dataSource.getLayerCount();
            for (int i = 0; i < count; ++i) {
                layer = dataSource.getLayer(i, false);
                String name = this.ogr.LayerGetName(layer);
                if (name != null) {
                    result.add((Name)new NameImpl(this.getNamespaceURI(), name));
                }
                this.ogr.LayerRelease(layer);
            }
            ArrayList<Name> arrayList = result;
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            throw throwable;
        }
    }

    OGRDataSource openOGRDataSource(boolean update) throws IOException {
        return this.dataSourcePool.getDataSource(update);
    }

    Object openOGRLayer(OGRDataSource dataSource, String layerName, boolean allowPriming) throws IOException {
        Object layer = dataSource.getLayerByName(layerName, allowPriming);
        if (layer == null) {
            throw new IOException("OGR could not find layer '" + layerName + "'");
        }
        return layer;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        if (this.supportsInPlaceWrite(entry.getTypeName())) {
            return new OGRFeatureStore(entry, Query.ALL, this.ogr);
        }
        return new OGRFeatureSource(entry, Query.ALL, this.ogr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsInPlaceWrite(String typeName) throws IOException {
        boolean bl;
        Object rawDs;
        Object l;
        OGRDataSource ds;
        block9: {
            ds = null;
            l = null;
            try {
                rawDs = this.ogr.Open(this.ogrSourceName, 1);
                if (rawDs != null) break block9;
                boolean bl2 = false;
                if (l != null) {
                    this.ogr.LayerRelease(l);
                }
                if (ds != null) {
                    ds.close();
                }
                return bl2;
            }
            catch (Throwable throwable) {
                if (l != null) {
                    this.ogr.LayerRelease(l);
                }
                if (ds != null) {
                    ds.close();
                }
                throw throwable;
            }
        }
        ds = new OGRDataSource(this.ogr, null, rawDs, true);
        l = this.openOGRLayer(ds, typeName, false);
        boolean canDelete = this.ogr.LayerCanDeleteFeature(l);
        boolean canWriteRandom = this.ogr.LayerCanWriteRandom(l);
        boolean canWriteSequential = this.ogr.LayerCanWriteSequential(l);
        boolean bl3 = bl = canDelete && canWriteRandom && canWriteSequential;
        if (l != null) {
            this.ogr.LayerRelease(l);
        }
        if (ds != null) {
            ds.close();
        }
        return bl;
    }

    public void createSchema(SimpleFeatureType schema) throws IOException {
        this.createSchema(schema, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType schema, boolean approximateFields, String[] options) throws IOException {
        OGRDataSource dataSource = null;
        Object layer = null;
        try {
            dataSource = this.dataSourcePool.openOrCreateDataSource(options);
            FeatureTypeMapper mapper = new FeatureTypeMapper(this.ogr);
            layer = this.createNewLayer(schema, dataSource, options, mapper);
            Object driver = dataSource.getDriver();
            String driverName = this.ogr.DriverGetName(driver);
            this.ogr.DriverRelease(driver);
            if (!(driverName.equalsIgnoreCase("georss") || driverName.equalsIgnoreCase("gpx") || driverName.equalsIgnoreCase("sosi") || this.ogr.LayerCanCreateField(layer))) {
                throw new DataSourceException("OGR reports it's not possible to create fields on this layer");
            }
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor ad = schema.getDescriptor(i);
                if (ad == schema.getGeometryDescriptor()) continue;
                Object fieldDefinition = mapper.getOGRFieldDefinition(ad);
                this.ogr.LayerCreateField(layer, fieldDefinition, approximateFields ? 1 : 0);
            }
            this.ogr.LayerSyncToDisk(layer);
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
        }
        catch (Throwable throwable) {
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureCollection data, boolean approximateFields, String[] options) throws IOException {
        OGRDataSource dataSource = null;
        Object layer = null;
        SimpleFeatureType schema = (SimpleFeatureType)data.getSchema();
        try {
            dataSource = this.dataSourcePool.openOrCreateDataSource(options);
            FeatureTypeMapper mapper = new FeatureTypeMapper(this.ogr);
            layer = this.createNewLayer(schema, dataSource, options, mapper);
            Object driver = dataSource.getDriver();
            String driverName = this.ogr.DriverGetName(driver);
            this.ogr.DriverRelease(driver);
            if (!(driverName.equalsIgnoreCase("georss") || driverName.equalsIgnoreCase("gpx") || driverName.equalsIgnoreCase("sosi") || driverName.equalsIgnoreCase("geojson") || this.ogr.LayerCanCreateField(layer))) {
                throw new DataSourceException("OGR reports it's not possible to create fields on this layer");
            }
            HashMap<String, String> nameMap = new HashMap<String, String>();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor ad = schema.getDescriptor(i);
                if (ad == schema.getGeometryDescriptor()) continue;
                Object fieldDefinition = mapper.getOGRFieldDefinition(ad);
                this.ogr.LayerCreateField(layer, fieldDefinition, approximateFields ? 1 : 0);
                String newName = this.ogr.FieldGetName(fieldDefinition);
                nameMap.put(newName, ad.getLocalName());
            }
            Object layerDefinition = this.ogr.LayerGetLayerDefn(layer);
            HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
            int count = this.ogr.LayerGetFieldCount(layerDefinition);
            for (int i = 0; i < count; ++i) {
                Object fd = this.ogr.LayerGetFieldDefn(layerDefinition, i);
                String newName = this.ogr.FieldGetName(fd);
                if (newName == null) continue;
                String oldName = (String)nameMap.get(newName);
                if (oldName == null) {
                    oldName = (String)nameMap.get(newName.toLowerCase());
                }
                if (oldName == null) {
                    oldName = (String)nameMap.get(newName.toUpperCase());
                }
                for (int j = 0; j < schema.getAttributeCount(); ++j) {
                    if (!schema.getDescriptor(j).getLocalName().equals(oldName)) continue;
                    indexMap.put(j, i);
                }
            }
            GeometryMapper.WKB geomMapper = new GeometryMapper.WKB(new GeometryFactory(), this.ogr);
            try (SimpleFeatureIterator features = data.features();){
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    Object ogrFeature = this.ogr.LayerNewFeature(layerDefinition);
                    for (int i = 0; i < schema.getAttributeCount(); ++i) {
                        Object value = feature.getAttribute(i);
                        if (value instanceof Geometry) {
                            Object geometry = ((GeometryMapper)geomMapper).parseGTGeometry((Geometry)value);
                            this.ogr.FeatureSetGeometryDirectly(ogrFeature, geometry);
                            continue;
                        }
                        int ogrIndex = (Integer)indexMap.get(i);
                        FeatureMapper.setFieldValue(layerDefinition, ogrFeature, ogrIndex, value, this.ogr);
                    }
                    this.ogr.CheckError(this.ogr.LayerCreateFeature(layer, ogrFeature));
                    this.ogr.FeatureDestroy(ogrFeature);
                }
            }
            this.ogr.LayerSyncToDisk(layer);
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
        }
        catch (Throwable throwable) {
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            throw throwable;
        }
    }

    private Object createNewLayer(SimpleFeatureType schema, OGRDataSource dataSource, String[] options, FeatureTypeMapper mapper) throws IOException, DataSourceException {
        GeometryDescriptor geomType = schema.getGeometryDescriptor();
        long ogrGeomType = mapper.getOGRGeometryType(geomType);
        Object spatialReference = mapper.getSpatialReference(geomType.getCoordinateReferenceSystem());
        Object layer = dataSource.createLayer(schema.getTypeName(), spatialReference, ogrGeomType, options);
        if (layer == null) {
            throw new DataSourceException("Could not create the OGR layer: " + this.ogr.GetLastErrorMsg());
        }
        return layer;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.dataSourcePool.close();
        }
    }
}

