/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ogr.FeatureTypeMapper;
import org.geotools.data.ogr.GeometryMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRFeatureReader;
import org.geotools.data.ogr.OGRFilterTranslator;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class OGRFeatureSource
extends ContentFeatureSource {
    OGR ogr;

    public OGRFeatureSource(ContentEntry entry, Query query, OGR ogr) {
        super(entry, query);
        this.ogr = ogr;
    }

    public OGRDataStore getDataStore() {
        return (OGRDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        Object extent;
        Object layer;
        OGRDataSource dataSource;
        CoordinateReferenceSystem crs;
        block11: {
            crs = this.getSchema().getCoordinateReferenceSystem();
            OGRFilterTranslator filterTx = new OGRFilterTranslator(this.getSchema(), query.getFilter());
            if (Filter.EXCLUDE.equals(filterTx.getFilter())) {
                return new ReferencedEnvelope(crs);
            }
            if (!filterTx.isFilterFullySupported()) {
                return null;
            }
            dataSource = null;
            layer = null;
            try {
                String typeName = this.getEntry().getTypeName();
                dataSource = this.getDataStore().openOGRDataSource(false);
                layer = this.getDataStore().openOGRLayer(dataSource, typeName, true);
                this.setLayerFilters(layer, filterTx);
                extent = this.ogr.LayerGetExtent(layer);
                if (extent != null) break block11;
                ReferencedEnvelope referencedEnvelope = null;
                if (layer != null) {
                    this.ogr.LayerRelease(layer);
                }
                if (dataSource != null) {
                    dataSource.close();
                }
                return referencedEnvelope;
            }
            catch (Throwable throwable) {
                if (layer != null) {
                    this.ogr.LayerRelease(layer);
                }
                if (dataSource != null) {
                    dataSource.close();
                }
                throw throwable;
            }
        }
        ReferencedEnvelope referencedEnvelope = this.ogr.toEnvelope(extent, crs);
        if (layer != null) {
            this.ogr.LayerRelease(layer);
        }
        if (dataSource != null) {
            dataSource.close();
        }
        return referencedEnvelope;
    }

    private void setLayerFilters(Object layer, OGRFilterTranslator filterTx) throws IOException {
        Geometry spatialFilter = filterTx.getSpatialFilter();
        if (spatialFilter != null) {
            Object ogrGeometry = new GeometryMapper.WKB(new GeometryFactory(), this.ogr).parseGTGeometry(spatialFilter);
            this.ogr.LayerSetSpatialFilter(layer, ogrGeometry);
        } else {
            this.ogr.LayerSetSpatialFilter(layer, null);
        }
        String attFilter = filterTx.getAttributeFilter();
        if (attFilter != null) {
            this.ogr.LayerSetAttributeFilter(layer, attFilter);
        } else {
            this.ogr.LayerSetAttributeFilter(layer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        OGRFilterTranslator filterTx = new OGRFilterTranslator(this.getSchema(), query.getFilter());
        if (Filter.EXCLUDE.equals(filterTx.getFilter())) {
            return 0;
        }
        if (!filterTx.isFilterFullySupported()) {
            return -1;
        }
        OGRDataSource dataSource = null;
        Object layer = null;
        try {
            String typeName = this.getEntry().getTypeName();
            dataSource = this.getDataStore().openOGRDataSource(false);
            layer = this.getDataStore().openOGRLayer(dataSource, typeName, true);
            this.setLayerFilters(layer, filterTx);
            int n = (int)this.ogr.LayerGetFeatureCount(layer);
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            throw throwable;
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.getReaderInternal(null, null, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(OGRDataSource dataSource, Object layer, Query query) throws IOException {
        OGRFilterTranslator filterTx = new OGRFilterTranslator(this.getSchema(), query.getFilter());
        if (Filter.EXCLUDE.equals(filterTx.getFilter())) {
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        boolean cleanup = false;
        try {
            SimpleFeatureType sourceSchema;
            if (dataSource == null) {
                dataSource = this.getDataStore().openOGRDataSource(false);
                cleanup = true;
            }
            SimpleFeatureType querySchema = sourceSchema = this.getSchema();
            SimpleFeatureType targetSchema = sourceSchema;
            String[] properties = query.getPropertyNames();
            if (properties != null && properties.length > 0) {
                querySchema = targetSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sourceSchema, (String[])properties);
                if (query.getFilter() != Filter.INCLUDE) {
                    HashSet<String> queriedAttributes = new HashSet<String>(Arrays.asList(properties));
                    FilterAttributeExtractor extraAttributeExtractor = new FilterAttributeExtractor();
                    query.getFilter().accept((FilterVisitor)extraAttributeExtractor, null);
                    HashSet extraAttributeSet = new HashSet(extraAttributeExtractor.getAttributeNameSet());
                    extraAttributeSet.removeAll(queriedAttributes);
                    if (extraAttributeSet.size() > 0) {
                        String[] queryProperties = new String[properties.length + extraAttributeSet.size()];
                        System.arraycopy(properties, 0, queryProperties, 0, properties.length);
                        String[] extraAttributes = extraAttributeSet.toArray(new String[extraAttributeSet.size()]);
                        System.arraycopy(extraAttributes, 0, queryProperties, properties.length, extraAttributes.length);
                        querySchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sourceSchema, (String[])queryProperties);
                    }
                }
            }
            if (layer == null) {
                if (query.getSortBy() == null || query.getSortBy().length == 0) {
                    layer = dataSource.getLayerByName(this.getSchema().getTypeName(), true);
                    this.setLayerFilters(layer, filterTx);
                    this.setIgnoredFields(layer, querySchema, sourceSchema);
                } else {
                    Object driver = dataSource.getDriver();
                    String driverName = this.ogr.DriverGetName(driver);
                    this.ogr.DriverRelease(driver);
                    boolean isNonOgrSql = this.doesDriverUseNonOgrSql(driverName);
                    String fidColumnName = "FID";
                    if (isNonOgrSql) {
                        boolean needsFid = false;
                        for (SortBy sort : query.getSortBy()) {
                            if (!SortBy.NATURAL_ORDER.equals(sort) && !SortBy.REVERSE_ORDER.equals(sort)) continue;
                            needsFid = true;
                            break;
                        }
                        if (needsFid) {
                            layer = dataSource.getLayerByName(this.getSchema().getTypeName(), false);
                            fidColumnName = this.ogr.LayerGetFIDColumnName(layer);
                            this.ogr.LayerRelease(layer);
                            if (fidColumnName == null) {
                                throw new IOException("Cannot do natural order without an FID column!");
                            }
                        }
                    }
                    String sql = this.getLayerSql(querySchema == sourceSchema ? null : querySchema, filterTx.getAttributeFilter(), query.getSortBy(), isNonOgrSql, fidColumnName);
                    Object spatialFilterPtr = null;
                    Geometry spatialFilter = filterTx.getSpatialFilter();
                    if (spatialFilter != null) {
                        spatialFilterPtr = new GeometryMapper.WKB(new GeometryFactory(), this.ogr).parseGTGeometry(spatialFilter);
                    }
                    if ((layer = dataSource.executeSQL(sql, spatialFilterPtr)) == null) {
                        throw new IOException("Failed to query the source layer with SQL: " + sql);
                    }
                }
            } else {
                this.setLayerFilters(layer, filterTx);
                this.setIgnoredFields(layer, querySchema, sourceSchema);
            }
            GeometryFactory gf = this.getGeometryFactory(query);
            OGRFeatureReader reader = new OGRFeatureReader(dataSource, layer, querySchema, sourceSchema, gf, this.ogr);
            cleanup = false;
            if (!filterTx.isFilterFullySupported()) {
                reader = new FilteringFeatureReader((FeatureReader)reader, filterTx.getPostFilter());
            }
            if (targetSchema != querySchema) {
                reader = new ReTypeFeatureReader((FeatureReader)reader, targetSchema);
            }
            OGRFeatureReader oGRFeatureReader = reader;
            return oGRFeatureReader;
        }
        finally {
            if (cleanup) {
                if (layer != null) {
                    this.ogr.LayerRelease(layer);
                }
                if (dataSource != null) {
                    dataSource.close();
                }
            }
        }
    }

    private boolean doesDriverUseNonOgrSql(String driverName) {
        List<String> databaseDriverNames = Arrays.asList("MYSQL", "POSTGRESQL", "POSTGIS", "PG", "ORACLE", "OCI", "SQLITE", "ODBC", "ESRI PERSONAL GEODATABASE", "PGEO", "MS SQL SPATIAL", "MSSQLSPATIAL");
        return databaseDriverNames.contains(driverName.toUpperCase());
    }

    void clearIgnoredFields(Object layer) {
        if (this.ogr.LayerCanIgnoreFields(layer)) {
            this.ogr.LayerSetIgnoredFields(layer, null);
        }
    }

    void setIgnoredFields(Object layer, SimpleFeatureType querySchema, SimpleFeatureType sourceSchema) throws IOException {
        if (this.ogr.LayerCanIgnoreFields(layer)) {
            if (querySchema.equals(sourceSchema)) {
                this.ogr.LayerSetIgnoredFields(layer, null);
            } else {
                ArrayList<String> ignoredFields = new ArrayList<String>();
                ignoredFields.add("OGR_STYLE");
                if (querySchema.getGeometryDescriptor() == null) {
                    ignoredFields.add("OGR_GEOMETRY");
                }
                for (AttributeDescriptor ad : sourceSchema.getAttributeDescriptors()) {
                    String name;
                    if (ad instanceof GeometryDescriptor || querySchema.getDescriptor(name = ad.getLocalName()) != null) continue;
                    ignoredFields.add(name);
                }
                if (ignoredFields.size() > 0) {
                    String[] ignoredFieldsArr = ignoredFields.toArray(new String[ignoredFields.size()]);
                    this.ogr.CheckError(this.ogr.LayerSetIgnoredFields(layer, ignoredFieldsArr));
                }
            }
        }
    }

    private String getLayerSql(SimpleFeatureType targetSchema, String attributeFilter, SortBy[] sortBy, boolean isNonOgrSql, String fidColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (!isNonOgrSql) {
            sb.append("FID, ");
        }
        if (targetSchema == null) {
            sb.append("* ");
        } else {
            for (AttributeDescriptor attribute : targetSchema.getAttributeDescriptors()) {
                if (attribute instanceof GeometryDescriptor) continue;
                sb.append(attribute.getLocalName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" ");
        }
        sb.append("FROM ").append("'").append(this.getSchema().getTypeName()).append("' ");
        if (attributeFilter != null) {
            sb.append("WHERE ").append(attributeFilter);
        }
        if (sortBy != null && sortBy.length > 0) {
            sb.append("ORDER BY ");
            for (SortBy sort : sortBy) {
                if (sort == SortBy.NATURAL_ORDER) {
                    sb.append(fidColumnName).append(", ");
                    continue;
                }
                if (sort == SortBy.REVERSE_ORDER) {
                    sb.append(fidColumnName).append(" DESC, ");
                    continue;
                }
                sb.append(sort.getPropertyName().getPropertyName());
                if (sort.getSortOrder() == SortOrder.DESCENDING) {
                    sb.append(" DESC");
                }
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    GeometryFactory getGeometryFactory(Query query) {
        CoordinateSequenceFactory csFactory;
        Hints hints = query.getHints();
        GeometryFactory gf = null;
        if (hints != null && (gf = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY)) == null && (csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            gf = new GeometryFactory(csFactory);
        }
        if (gf == null) {
            gf = new GeometryFactory();
        }
        return gf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType buildFeatureType() throws IOException {
        String typeName = this.getEntry().getTypeName();
        String namespaceURI = this.getDataStore().getNamespaceURI();
        OGRDataSource dataSource = null;
        Object layer = null;
        try {
            dataSource = this.getDataStore().openOGRDataSource(false);
            layer = this.getDataStore().openOGRLayer(dataSource, typeName, false);
            SimpleFeatureType simpleFeatureType = new FeatureTypeMapper(this.ogr).getFeatureType(layer, typeName, namespaceURI);
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            return simpleFeatureType;
        }
        catch (Throwable throwable) {
            if (layer != null) {
                this.ogr.LayerRelease(layer);
            }
            if (dataSource != null) {
                dataSource.close();
            }
            throw throwable;
        }
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

