/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.ogr.FeatureMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class OGRDirectFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    private SimpleFeatureType featureType;
    private SimpleFeature original;
    private SimpleFeature live;
    private Object layer;
    private OGRDataSource dataSource;
    private FeatureMapper mapper;
    private boolean deletedFeatures;
    private Object layerDefinition;
    private OGR ogr;

    public OGRDirectFeatureWriter(OGRDataSource dataSource, Object layer, FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType originalSchema, GeometryFactory gf, OGR ogr) {
        this.reader = reader;
        this.featureType = (SimpleFeatureType)reader.getFeatureType();
        this.dataSource = dataSource;
        this.layer = layer;
        this.layerDefinition = ogr.LayerGetLayerDefn(layer);
        this.mapper = new FeatureMapper(this.featureType, layer, gf, ogr);
        this.deletedFeatures = false;
        this.ogr = ogr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.original = null;
                this.live = null;
                Object driver = this.dataSource.getDriver();
                String driverName = this.ogr.DriverGetName(driver);
                if ("ESRI Shapefile".equals(driverName) && this.deletedFeatures) {
                    String layerName = this.ogr.LayerGetName(this.layer);
                    this.dataSource.executeSQL("REPACK " + layerName, null);
                }
                this.ogr.LayerSyncToDisk(this.layer);
            }
            finally {
                this.reader.close();
            }
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public SimpleFeature next() throws IOException {
        if (this.live != null) {
            this.write();
        }
        if (this.reader.hasNext()) {
            this.original = (SimpleFeature)this.reader.next();
            this.live = SimpleFeatureBuilder.copy((SimpleFeature)this.original);
        } else {
            this.original = null;
            this.live = SimpleFeatureBuilder.template((SimpleFeatureType)this.featureType, null);
        }
        return this.live;
    }

    public void remove() throws IOException {
        long ogrId = this.mapper.convertGTFID(this.original);
        if (!this.ogr.LayerDeleteFeature(this.layer, ogrId)) {
            throw new IOException(this.ogr.GetLastErrorMsg());
        }
        this.deletedFeatures = true;
    }

    public void write() throws IOException {
        boolean changed;
        if (this.live == null) {
            throw new IOException("No current feature to write");
        }
        boolean bl = changed = !this.live.equals(this.original);
        if (changed || this.original == null) {
            if (this.original != null) {
                Object ogrFeature = this.mapper.convertGTFeature(this.layerDefinition, this.live);
                this.ogr.CheckError(this.ogr.LayerSetFeature(this.layer, ogrFeature));
            } else {
                Object ogrFeature = this.mapper.convertGTFeature(this.layerDefinition, this.live);
                this.ogr.CheckError(this.ogr.LayerCreateFeature(this.layer, ogrFeature));
                String geotoolsId = this.mapper.convertOGRFID(this.featureType, ogrFeature);
                ((FeatureIdImpl)this.live.getIdentifier()).setID(geotoolsId);
                this.ogr.FeatureDestroy(ogrFeature);
            }
        }
        this.live = null;
        this.original = null;
    }
}

