/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSourcePool;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.util.logging.Logging;

public abstract class OGRDataStoreFactory
implements DataStoreFactorySpi {
    protected static Logger LOGGER = Logging.getLogger(OGRDataStoreFactory.class);
    public static final DataAccessFactory.Param OGR_NAME = new DataAccessFactory.Param("DatasourceName", String.class, "Name of the file, or data source to try and open", true);
    public static final DataAccessFactory.Param OGR_DRIVER_NAME = new DataAccessFactory.Param("DriverName", String.class, "Name of the OGR driver to be used. Required to create a new data source, optional when opening an existing one", false, null);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);
    protected static final Integer DEFAULT_MAXCONN = 20;
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of pooled data source connections", false, (Object)DEFAULT_MAXCONN);
    protected static final Integer DEFAULT_MINCONN = 1;
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled data source connection connection", false, (Object)DEFAULT_MINCONN);
    protected static final int DEFAULT_MAXWAIT = 20;
    public static final DataAccessFactory.Param MAXWAIT = new DataAccessFactory.Param("Connection timeout", Integer.class, "number of seconds the pool will wait before timing out attempting to get a new data source (default, 20 seconds)", false, (Object)20);
    protected static final int DEFAULT_EVICTABLE_TIME = 300;
    public static final DataAccessFactory.Param MIN_EVICTABLE_TIME = new DataAccessFactory.Param("Max data source idle time", Integer.class, "number of seconds a data source needs to stay idle for the evictor to consider closing it", false, (Object)300);
    public static final int DEFAULT_EVICTOR_TESTS_PER_RUN = 3;
    public static final DataAccessFactory.Param EVICTOR_TESTS_PER_RUN = new DataAccessFactory.Param("Evictor tests per run", Integer.class, "number of data source checked by the idle connection evictor for each of its runs (defaults to 3)", false, (Object)3);
    public static final boolean DEFAULT_PRIME_DATASOURCE = false;
    public static final DataAccessFactory.Param PRIME_DATASOURCE = new DataAccessFactory.Param("Prime DataSources", Boolean.class, "Performs a full data read on data source creation, in some formats this generates a in memory cache, or a spatial index (check the OGR documentation for details)", false, (Object)false);
    static Boolean AVAILABLE = null;

    protected abstract OGR createOGR();

    public boolean canProcess(Map params) {
        boolean accept = false;
        String ogrName = null;
        String ogrDriver = null;
        try {
            ogrName = (String)OGR_NAME.lookUp(params);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ogrDriver = (String)OGR_DRIVER_NAME.lookUp(params);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        accept = this.canProcess(ogrName, ogrDriver);
        return accept;
    }

    public DataStore createDataStore(Map params) throws IOException {
        return this.createNewDataStore(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        String ogrName = (String)OGR_NAME.lookUp(params);
        String ogrDriver = (String)OGR_DRIVER_NAME.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        OGR ogr = this.createOGR();
        OGRDataStore ds = new OGRDataStore(ogrName, ogrDriver, namespace, ogr, new OGRDataSourcePool(ogr, ogrName, ogrDriver, params));
        return ds;
    }

    public String getDisplayName() {
        return "OGR";
    }

    public String getDescription() {
        return "Uses OGR as a data source";
    }

    public final boolean isAvailable() {
        return this.isAvailable(true);
    }

    public final boolean isAvailable(boolean handleError) {
        if (AVAILABLE == null) {
            try {
                AVAILABLE = this.doIsAvailable();
            }
            catch (Throwable t) {
                if (handleError) {
                    LOGGER.log(Level.WARNING, "Error initializing GDAL/OGR library", t);
                    return false;
                }
                throw new RuntimeException(t);
            }
        }
        return AVAILABLE;
    }

    protected abstract boolean doIsAvailable() throws Throwable;

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{OGR_NAME, OGR_DRIVER_NAME, NAMESPACEP, MAXCONN, MINCONN, MAXWAIT, MIN_EVICTABLE_TIME, EVICTOR_TESTS_PER_RUN, PRIME_DATASOURCE};
    }

    public boolean canProcess(String ogrName, String driverName) {
        OGR ogr = this.createOGR();
        if (ogrName == null) {
            return false;
        }
        Object dataset = ogr.OpenShared(ogrName, 0);
        if (dataset != null) {
            ogr.DataSourceRelease(dataset);
            return true;
        }
        if (driverName != null) {
            try {
                Object driver = ogr.GetDriverByName(driverName);
                if (driver != null) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error loading driver", e);
            }
        }
        return false;
    }

    public Set<String> getAvailableDrivers() {
        OGR ogr = this.createOGR();
        int count = ogr.GetDriverCount();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            Object driver = ogr.GetDriver(i);
            String name = ogr.DriverGetName(driver);
            result.add(name);
        }
        return result;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

