/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSourcePool;
import org.geotools.util.logging.Logging;

class OGRDataSource {
    static final Logger LOGGER = Logging.getLogger(OGRDataSource.class);
    protected static final String TRACE_ENABLED_KEY = "gt2.ogr.trace";
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.ogr.trace"));
    long creationTime;
    OGRDataSourcePool pool;
    OGR ogr;
    Object source;
    final boolean update;
    Exception tracer;
    boolean primeLayersEnabled;
    private Set<String> primedLayers = new HashSet<String>();

    public OGRDataSource(OGR ogr, OGRDataSourcePool pool, Object source, boolean update) {
        this.ogr = ogr;
        this.pool = pool;
        this.source = source;
        this.update = update;
        this.creationTime = System.nanoTime();
        if (TRACE_ENABLED.booleanValue()) {
            this.tracer = new Exception();
            this.tracer.fillInStackTrace();
        }
    }

    public int getLayerCount() {
        return this.ogr.DataSourceGetLayerCount(this.source);
    }

    public Object getLayer(int i, boolean allowPriming) {
        Object layer = this.ogr.DataSourceGetLayer(this.source, i);
        this.primeIfRequired(allowPriming, layer);
        return layer;
    }

    public void primeIfRequired(boolean allowPriming, Object layer) {
        String name;
        if (this.primeLayersEnabled && allowPriming && !this.primedLayers.contains(name = this.ogr.LayerGetName(layer))) {
            Object feature;
            this.ogr.LayerResetReading(layer);
            this.ogr.LayerSetAttributeFilter(layer, "0 = 1");
            while ((feature = this.ogr.LayerGetNextFeature(layer)) != null) {
                this.ogr.FeatureDestroy(feature);
            }
            this.primedLayers.add(name);
        }
    }

    public Object getDriver() {
        return this.ogr.DataSourceGetDriver(this.source);
    }

    public Object createLayer(String typeName, Object spatialReference, long ogrGeomType, String[] options) {
        return this.ogr.DataSourceCreateLayer(this.source, typeName, spatialReference, ogrGeomType, options);
    }

    public Object getLayerByName(String layerName, boolean allowPriming) {
        Object layer = this.ogr.DataSourceGetLayerByName(this.source, layerName);
        this.primeIfRequired(allowPriming, layer);
        return layer;
    }

    public void close() {
        if (this.source == null) {
            return;
        }
        if (this.pool != null) {
            try {
                this.pool.returnObject(this);
            }
            catch (Exception e) {
                this.destroy();
            }
        } else {
            this.destroy();
        }
    }

    public Object executeSQL(String sql, Object spatialFilter) {
        return this.ogr.DataSourceExecuteSQL(this.source, sql, spatialFilter);
    }

    public boolean isPrimeLayersEnabled() {
        return this.primeLayersEnabled;
    }

    public void setPrimeLayersEnabled(boolean primeLayersEnabled) {
        this.primeLayersEnabled = primeLayersEnabled;
    }

    protected void finalize() {
        if (this.source != null) {
            LOGGER.warning("There is code leaving feature readers/iterators open, this is leaking OGR DataSource native objects! To find out details, set the gt2.ogr.trace system variable to true");
            if (TRACE_ENABLED.booleanValue()) {
                LOGGER.log(Level.WARNING, "The unclosed reader originated on this stack trace", this.tracer);
            }
            this.close();
        }
    }

    void destroy() {
        if (this.source != null) {
            this.ogr.DataSourceRelease(this.source);
        }
        this.pool = null;
        this.source = null;
        this.ogr = null;
        this.tracer = null;
    }
}

