/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.data.ogr.TestCaseSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class OGRDataStoreFactoryTest
extends TestCaseSupport {
    protected OGRDataStoreFactoryTest(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        super(dataStoreFactoryClass);
    }

    @Test
    public void testLookup() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(OGRDataStoreFactory.OGR_NAME.key, this.getAbsolutePath("shapes/statepop.shp"));
        DataStore ds = null;
        try {
            ds = DataStoreFinder.getDataStore(map);
            Assert.assertNotNull((Object)ds);
            Assert.assertTrue((boolean)(ds instanceof OGRDataStore));
        }
        finally {
            this.disposeQuietly(ds);
        }
    }

    private void disposeQuietly(DataStore ds) {
        if (ds != null) {
            ds.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespace() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        URI namespace = new URI("http://jesse.com");
        map.put(OGRDataStoreFactory.NAMESPACEP.key, namespace);
        map.put(OGRDataStoreFactory.OGR_NAME.key, this.getAbsolutePath("shapes/statepop.shp"));
        DataStore store = null;
        try {
            store = this.dataStoreFactory.createDataStore(map);
            SimpleFeatureType schema = store.getSchema("shapes/statepop.shp".substring("shapes/statepop.shp".lastIndexOf(47) + 1, "shapes/statepop.shp".lastIndexOf(46)));
            Assert.assertEquals((Object)namespace.toString(), (Object)schema.getName().getNamespaceURI());
        }
        finally {
            this.disposeQuietly(store);
        }
    }

    @Test
    public void testNames() throws Exception {
        Set drivers = this.dataStoreFactory.getAvailableDrivers();
        Assert.assertFalse((boolean)drivers.isEmpty());
        Assert.assertTrue((boolean)drivers.contains("ESRI Shapefile"));
    }
}

