/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import org.geotools.data.ogr.OGR;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

abstract class GeometryMapper {
    protected OGR ogr;

    protected GeometryMapper(OGR ogr) {
        this.ogr = ogr;
    }

    abstract Geometry parseOgrGeometry(Object var1) throws IOException;

    abstract Object parseGTGeometry(Geometry var1) throws IOException;

    static class WKT
    extends GeometryMapper {
        GeometryFactory geomFactory;
        WKTReader wktReader;
        WKTWriter wktWriter;

        public WKT(GeometryFactory geomFactory, OGR ogr) {
            super(ogr);
            this.geomFactory = geomFactory;
            this.wktReader = new WKTReader(geomFactory);
            this.wktWriter = new WKTWriter();
        }

        @Override
        Geometry parseOgrGeometry(Object geom) throws IOException {
            int[] ret = new int[1];
            String wkt = this.ogr.GeometryExportToWkt(geom, ret);
            this.ogr.CheckError(ret[0]);
            try {
                return this.wktReader.read(wkt);
            }
            catch (ParseException pe) {
                throw new IOException("Could not parse the current Geometry in WKT format.", pe);
            }
        }

        @Override
        Object parseGTGeometry(Geometry geometry) throws IOException {
            String wkt = this.wktWriter.write(geometry);
            int[] ret = new int[1];
            Object result = this.ogr.GeometryCreateFromWkt(wkt, ret);
            this.ogr.CheckError(ret[0]);
            return result;
        }
    }

    static class WKB
    extends GeometryMapper {
        GeometryFactory geomFactory;
        WKBReader wkbReader;
        WKBWriter wkbWriter;

        public WKB(GeometryFactory geomFactory, OGR ogr) {
            super(ogr);
            this.geomFactory = geomFactory;
            this.wkbReader = new WKBReader(geomFactory);
            this.wkbWriter = new WKBWriter();
        }

        @Override
        Geometry parseOgrGeometry(Object geom) throws IOException {
            int wkbSize = this.ogr.GeometryGetWkbSize(geom);
            byte[] wkb = new byte[wkbSize];
            this.ogr.CheckError(this.ogr.GeometryExportToWkb(geom, wkb));
            try {
                Geometry g = this.wkbReader.read(wkb);
                return g;
            }
            catch (ParseException pe) {
                throw new IOException("Could not parse the current Geometry in WKB format.", pe);
            }
        }

        @Override
        Object parseGTGeometry(Geometry geometry) throws IOException {
            byte[] wkb = this.wkbWriter.write(geometry);
            int[] ret = new int[1];
            Object result = this.ogr.GeometryCreateFromWkb(wkb, ret);
            this.ogr.CheckError(ret[0]);
            return result;
        }
    }
}

