/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.net.URL;
import java.util.logging.Logger;
import org.geotools.TestData;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.data.ogr.TestCaseSupport;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.junit.Before;
import org.junit.Test;

public abstract class OGRPeformanceTest
extends TestCaseSupport {
    static final Logger LOGGER = Logging.getLogger(OGRPeformanceTest.class);
    static final String STATE_POP = "shapes/statepop.shp";

    protected OGRPeformanceTest(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        super(dataStoreFactoryClass);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        CRS.decode((String)"EPSG:4326");
    }

    @Test
    public void testOGRShapePerformance() throws Exception {
        OGRDataStore ods = new OGRDataStore(this.getAbsolutePath(STATE_POP), null, null, this.ogr);
        long start = System.currentTimeMillis();
        ods.getSchema(ods.getTypeNames()[0]);
        long end = System.currentTimeMillis();
        Query query = new Query(ods.getTypeNames()[0]);
        start = System.currentTimeMillis();
        try (FeatureReader ofr = ods.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            while (ofr.hasNext()) {
                ofr.next();
            }
        }
        end = System.currentTimeMillis();
        LOGGER.info("OGR: " + (double)(end - start) / 1000.0);
    }

    @Test
    public void testShapefilePerformance() throws Exception {
        URL url = TestData.url((String)STATE_POP);
        ShapefileDataStore sds = new ShapefileDataStore(url);
        long start = System.currentTimeMillis();
        sds.getSchema();
        long end = System.currentTimeMillis();
        LOGGER.info("SDS schema: " + (double)(end - start) / 1000.0);
        Query query = new Query(sds.getTypeNames()[0]);
        start = System.currentTimeMillis();
        try (FeatureReader sfr = sds.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            while (sfr.hasNext()) {
                sfr.next();
            }
        }
        end = System.currentTimeMillis();
        LOGGER.info("SDS: " + (double)(end - start) / 1000.0);
    }
}

