/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.TestData;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.data.ogr.TestCaseSupport;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;

public abstract class OGRDataStoreTest
extends TestCaseSupport {
    static final Logger LOGGER = Logging.getLogger(OGRDataStoreTest.class);
    private List<OGRDataStore> stores = new ArrayList<OGRDataStore>();

    protected OGRDataStoreTest(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        super(dataStoreFactoryClass);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        for (OGRDataStore store : this.stores) {
            store.dispose();
        }
    }

    @Test
    public void testGetTypeNames() throws FileNotFoundException, IOException {
        OGRDataStore store = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        Assert.assertEquals((long)1L, (long)store.getTypeNames().length);
        Assert.assertEquals((Object)"statepop", (Object)store.getTypeNames()[0]);
        store = this.createDataStore(this.getAbsolutePath("mif/mixed.MIF"), null);
        Assert.assertEquals((long)1L, (long)store.getTypeNames().length);
        Assert.assertEquals((Object)"mixed", (Object)store.getTypeNames()[0]);
    }

    @Test
    public void testSchemaPop() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        SimpleFeatureType schema = s.getSchema(s.getTypeNames()[0]);
        Assert.assertEquals((String)"Number of Attributes", (long)253L, (long)schema.getAttributeCount());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4269", (boolean)true), (Object)schema.getGeometryDescriptor().getCoordinateReferenceSystem()));
    }

    @Test
    public void testSchemaMix() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("mif/mixed.MIF"), null);
        SimpleFeatureType schema = s.getSchema(s.getTypeNames()[0]);
        Assert.assertEquals((String)"Number of Attributes", (long)11L, (long)schema.getAttributeCount());
        Assert.assertEquals(Geometry.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
    }

    @Test
    public void testOptimizedEnvelope() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        ReferencedEnvelope expectedBounds = sds.getFeatureSource().getBounds();
        ReferencedEnvelope actualBounds = s.getFeatureSource(typeName).getBounds();
        Assert.assertEquals((Object)expectedBounds, (Object)actualBounds);
        Assert.assertNotNull((Object)actualBounds);
    }

    @Test
    public void testCountWithOffsetLimit() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        ContentFeatureSource featureSource = s.getFeatureSource(typeName);
        Query query = new Query();
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        Assert.assertEquals((long)1L, (long)featureSource.getCount(query));
    }

    @Test
    public void testOptimizedCount() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        Assert.assertEquals((long)sds.getCount(Query.ALL), (long)s.getFeatureSource(typeName).getCount(Query.ALL));
    }

    @Test
    public void testLoadAndVerify() throws Exception {
        SimpleFeatureCollection features = this.loadFeatures("shapes/statepop.shp", Query.ALL);
        int count = features.size();
        Assert.assertTrue((String)"Have features", (count > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of Features loaded", (long)49L, (long)features.size());
        Assert.assertEquals((long)49L, (long)this.countFeatures(features));
        SimpleFeatureType schema = this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getFeatureType();
        Assert.assertNotNull((Object)schema.getGeometryDescriptor());
        Assert.assertEquals((String)"Number of Attributes", (long)253L, (long)schema.getAttributeCount());
        Assert.assertEquals((String)"Value of statename is wrong", (Object)this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getAttribute("STATE_NAME"), (Object)"Illinois");
        Assert.assertEquals((String)"Value of land area is wrong", (double)((Double)this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getAttribute("LAND_KM")), (double)143986.61, (double)0.001);
    }

    @Test
    public void testLoadAndCheckParentTypeIsPolygon() throws Exception {
        SimpleFeatureCollection features = this.loadFeatures("shapes/statepop.shp", Query.ALL);
        SimpleFeatureType schema = this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getFeatureType();
        Assert.assertEquals((Object)schema.getSuper(), (Object)BasicFeatureTypes.POLYGON);
    }

    @Test
    public void testShapefileComparison() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore ods = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        this.assertFeatureTypeEquals(sds.getSchema(), ods.getSchema(sds.getSchema().getTypeName()));
        Query query = new Query(sds.getSchema().getTypeName());
        try (FeatureReader sfr = sds.getFeatureReader(query, Transaction.AUTO_COMMIT);
             FeatureReader ofr = ods.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            SimpleFeature sf = null;
            SimpleFeature of = null;
            block10: while (true) {
                if (!sfr.hasNext()) {
                    Assert.assertFalse((boolean)ofr.hasNext());
                    break;
                }
                sf = (SimpleFeature)sfr.next();
                of = (SimpleFeature)ofr.next();
                int i = 0;
                while (true) {
                    if (i >= sds.getSchema().getAttributeCount()) continue block10;
                    Object shapeAtt = sf.getAttribute(i);
                    Object ogrAtt = of.getAttribute(i);
                    Assert.assertEquals((Object)shapeAtt, (Object)ogrAtt);
                    ++i;
                }
                break;
            }
        }
        sds.dispose();
        ods.dispose();
    }

    @Test
    public void testLoadGeometry() throws Exception {
        OGRDataStore ods = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = ods.getFeatureSource("statepop");
        Query query = new Query("statepop");
        query.setPropertyNames(new String[]{"the_geom"});
        SimpleFeatureCollection fc = fs.getFeatures(query);
        Assert.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        Assert.assertEquals((long)1L, (long)schema.getDescriptors().size());
        Assert.assertEquals(MultiPolygon.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        schema = feature.getFeatureType();
        Assert.assertEquals((long)1L, (long)schema.getDescriptors().size());
        Assert.assertEquals(MultiPolygon.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
        Assert.assertNotNull((Object)feature.getDefaultGeometry());
    }

    private void assertFeatureTypeEquals(SimpleFeatureType type1, SimpleFeatureType type2) {
        Assert.assertEquals((Object)type1.getTypeName(), (Object)type2.getTypeName());
        Assert.assertEquals((Object)type1.getSuper(), (Object)type2.getSuper());
        Assert.assertEquals((long)type1.getAttributeCount(), (long)type2.getAttributeCount());
        for (int i = 0; i < type1.getAttributeCount(); ++i) {
            AttributeDescriptor ad1 = type1.getDescriptor(i);
            AttributeDescriptor ad2 = type2.getDescriptor(i);
            Assert.assertEquals((Object)ad1.getName(), (Object)ad2.getName());
            Assert.assertEquals((Object)ad1.getType().getBinding(), (Object)ad2.getType().getBinding());
            Assert.assertEquals((Object)ad1.isNillable(), (Object)ad2.isNillable());
            Assert.assertEquals((long)ad1.getMinOccurs(), (long)ad2.getMinOccurs());
            Assert.assertEquals((long)ad1.getMaxOccurs(), (long)ad2.getMaxOccurs());
            if (!(ad1 instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd1 = (GeometryDescriptor)ad1;
            GeometryDescriptor gd2 = (GeometryDescriptor)ad2;
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)gd1.getCoordinateReferenceSystem(), (Object)gd2.getCoordinateReferenceSystem()));
        }
    }

    @Test
    public void testRemoveFromFrontAndClose() throws Throwable {
        OGRDataStore sds = this.createDataStore();
        String typeName = sds.getTypeNames()[0];
        int idx = this.loadFeatures((DataStore)sds, typeName).size();
        while (idx > 0) {
            try (FeatureWriter writer = sds.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);){
                writer.next();
                writer.remove();
            }
            Assert.assertEquals((long)(--idx), (long)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        }
    }

    @Test
    public void testRemoveFromBackAndClose() throws Throwable {
        OGRDataStore sds = this.createDataStore();
        String typeName = sds.getTypeNames()[0];
        int idx = this.loadFeatures((DataStore)sds, typeName).size();
        Assert.assertEquals((long)idx, (long)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        while (idx > 0) {
            try (FeatureWriter writer = sds.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);){
                while (writer.hasNext()) {
                    writer.next();
                }
                writer.remove();
            }
            Assert.assertEquals((long)(--idx), (long)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        }
    }

    @Test
    public void testCreateSchema() throws Exception {
        String[] fileNames = this.shapeFileNames("test");
        this.cleanFiles(fileNames);
        String absolutePath = new File(fileNames[0]).getAbsolutePath();
        OGRDataStore ds = this.createDataStore(absolutePath, "ESRI shapefile");
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)"geom:MultiPolygon,count:int,level1:double,level2:float,chars:string");
        ds.createSchema(schema);
        Assert.assertEquals((long)1L, (long)ds.getTypeNames().length);
        Assert.assertEquals((Object)"test", (Object)ds.getTypeNames()[0]);
        SimpleFeatureType ogrSchema = ds.getSchema(ds.getTypeNames()[0]);
        Assert.assertEquals((Object)schema.getGeometryDescriptor().getType().getBinding(), (Object)ogrSchema.getGeometryDescriptor().getType().getBinding());
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor at = schema.getDescriptor(i);
            if (at == schema.getGeometryDescriptor()) continue;
            Assert.assertEquals((Object)at.getName(), (Object)ogrSchema.getDescriptor(i).getName());
            Assert.assertEquals((String)("Wrong type for attribute " + String.valueOf(at.getName())), (Object)at.getType().getBinding(), (Object)ogrSchema.getDescriptor(i).getType().getBinding());
        }
    }

    @Test
    public void testCreateWriteRead() throws Exception {
        SimpleFeature f;
        String typeName = "testw";
        String[] files = this.shapeFileNames(typeName);
        this.cleanFiles(files);
        File file = new File(files[0]);
        OGRDataStore ds = this.createDataStore(file.getAbsolutePath(), "ESRI shapefile");
        SimpleFeatureType schema = DataUtilities.createType((String)typeName, (String)"geom:Point,cat:int,name:string");
        ds.createSchema(schema);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature[] features = new SimpleFeature[20];
        for (int i = 0; i < features.length; ++i) {
            features[i] = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{gf.createPoint(new Coordinate((double)i, (double)i)), i, "" + i}, null);
        }
        try (FeatureWriter writer = ds.getFeatureWriterAppend("testw", Transaction.AUTO_COMMIT);){
            for (SimpleFeature simpleFeature : features) {
                Assert.assertFalse((boolean)writer.hasNext());
                f = (SimpleFeature)writer.next();
                f.setAttributes(simpleFeature.getAttributes());
                writer.write();
            }
        }
        try (FeatureReader reader = ds.getFeatureReader(new Query("testw"), null);){
            for (SimpleFeature feature : features) {
                Assert.assertTrue((boolean)reader.hasNext());
                f = (SimpleFeature)reader.next();
                for (int j = 0; j < schema.getAttributeCount(); ++j) {
                    if (f.getAttribute(j) instanceof Geometry) {
                        Geometry a = (Geometry)f.getAttribute(j);
                        Geometry b = (Geometry)feature.getAttribute(j);
                        Assert.assertEquals((Object)a, (Object)b);
                        continue;
                    }
                    Assert.assertEquals((Object)f.getAttribute(j), (Object)feature.getAttribute(j));
                }
            }
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testAttributesWritingShapefile() throws Exception {
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-shp", ".shp");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "ESRI shapefile");
        this.writeFeatures((DataStore)s, (FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
    }

    @Test
    public void testAttributesWritingGeoJSON() throws Exception {
        if (!this.ogrSupports("GeoJSON")) {
            LOGGER.warning("Skipping GeoJSON writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-geojson", ".json");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GeoJSON");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource(s.getTypeNames()[0]).getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingCsv() throws Exception {
        if (!this.ogrSupports("CSV")) {
            LOGGER.warning("Skipping CSV writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-csv", ".csv");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "CSV");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"GEOMETRY=AS_WKT"});
        Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        String typeName = tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".csv"));
        ContentFeatureCollection fc = s.getFeatureSource(typeName).getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingGmt() throws Exception {
        if (!this.ogrSupports("GMT")) {
            LOGGER.warning("Skipping GMT writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gmt", ".gmt");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GMT");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        String typeName = tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".gmt"));
        ContentFeatureCollection fc = s.getFeatureSource(typeName).getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingGpx() throws Exception {
        if (!this.ogrSupports("GPX")) {
            LOGGER.warning("Skipping GPX writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gpx", ".gpx");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GPX");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"GPX_USE_EXTENSIONS=YES"});
        try {
            Assert.assertEquals((long)5L, (long)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("waypoints").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingGML() throws Exception {
        if (!this.ogrSupports("GML")) {
            LOGGER.warning("Skipping GML writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gml", ".gml");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GML");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingKML() throws Exception {
        if (!this.ogrSupports("KML")) {
            LOGGER.warning("Skipping KML writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-kml", ".kml");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "KML");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingGeoRSS() throws Exception {
        if (!this.ogrSupports("GeoRSS")) {
            LOGGER.warning("Skipping GeoRSS writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-georss", ".rss");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GeoRSS");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"FORMAT=RSS", "GEOM_DIALECT=SIMPLE", "USE_EXTENSIONS=YES", "TITLE=f", "DESCRIPTION=f"});
        try {
            Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("georss").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributeFilters() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = s.getFeatureSource(s.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equal((Expression)ff.property("STATE_NAME"), (Expression)ff.literal((Object)"New York"), true);
        Assert.assertEquals((long)1L, (long)fs.getFeatures((Filter)f).size());
        f = ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal(10000000));
        Assert.assertEquals((long)6L, (long)fs.getFeatures((Filter)f).size());
        f = ff.and((Filter)f, (Filter)ff.like((Expression)ff.property("STATE_NAME"), "C*"));
        Assert.assertEquals((long)1L, (long)fs.getFeatures((Filter)f).size());
    }

    @Test
    public void testAttributesWritingSqlite() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-sql", ".sqlite");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingSqliteWithSorting() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-sql", ".sqlite");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Query query = new Query();
        query.setSortBy(new SortBy[]{ff.sort("float", SortOrder.ASCENDING)});
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures(query);
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    @Test
    public void testAttributesWritingSqliteFromUpperCaseAttributes() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollectionWithUpperCaseAttributes();
        File tmpFile = this.getTempFile("test-sqlite", ".db");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        Assert.assertEquals((long)1L, (long)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource("points").getFeatures();
        Assert.assertEquals((long)features.size(), (long)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Assert.assertNotNull((Object)f);
                Assert.assertNotNull((Object)f.getDefaultGeometry());
                Assert.assertNotNull((Object)f.getAttribute("name"));
                ++c;
            }
        }
        Assert.assertEquals((long)fc.size(), (long)c);
    }

    protected ListFeatureCollection createFeatureCollectionWithUpperCaseAttributes() throws Exception {
        SimpleFeatureTypeBuilder tbuilder = new SimpleFeatureTypeBuilder();
        tbuilder.setName("points");
        tbuilder.add("geom", Point.class);
        tbuilder.add("NAME", String.class);
        SimpleFeatureType type = tbuilder.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        ListFeatureCollection features = new ListFeatureCollection(type);
        int ii = 20;
        for (int i = 0; i < ii; ++i) {
            features.add(fb.buildFeature(null, new Object[]{new GeometryFactory().createPoint(new Coordinate(1.0, -1.0)), "Point" + String.valueOf(i)}));
        }
        return features;
    }

    @Test
    public void testGeometryFilters() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = s.getFeatureSource(s.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX f = ff.bbox("the_geom", -75.102613, 40.212597, -72.361859, 41.512517, null);
        int numberOfFeatures = fs.getFeatures((Filter)f).size();
        Assert.assertEquals((long)(s.ogr.IsGEOSEnabled() ? 4L : 5L), (long)numberOfFeatures);
        f = ff.and((Filter)f, (Filter)ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal((Object)"10000000")));
        Assert.assertEquals((long)6L, (long)fs.getFeatures((Filter)f).size());
    }

    @Test
    public void testGeot5588() throws Exception {
        String tabFile = this.getAbsolutePath("geot5588/geot5588a.tab");
        OGRDataStore s = this.createDataStore(tabFile, "MapInfo File");
        SimpleFeatureType schema = s.getSchema("geot5588a");
        Assert.assertEquals(Short.class, (Object)schema.getDescriptor("byte_field").getType().getBinding());
        Assert.assertEquals(Integer.class, (Object)schema.getDescriptor("short_field").getType().getBinding());
        Assert.assertEquals(BigInteger.class, (Object)schema.getDescriptor("int_field_0").getType().getBinding());
        ContentFeatureSource fs = s.getFeatureSource("geot5588a");
        try (FeatureIterator iterator = fs.getFeatures().features();){
            Assert.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            Assert.assertEquals((Object)999, (Object)feature.getAttribute("byte_field"));
            Assert.assertEquals((Object)99999, (Object)feature.getAttribute("short_field"));
            Assert.assertEquals((Object)BigInteger.valueOf(257L), (Object)feature.getAttribute("int_field_0"));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    public OGRDataStore createDataStore(String tabFile, String s) throws IOException {
        OGRDataStore store = new OGRDataStore(tabFile, s, null, this.ogr);
        this.stores.add(store);
        return store;
    }

    private int countFeatures(SimpleFeatureCollection features) {
        int count = 0;
        try (SimpleFeatureIterator fi = features.features();){
            while (fi.hasNext()) {
                fi.next();
                ++count;
            }
        }
        return count;
    }

    protected SimpleFeatureCollection loadFeatures(String resource, Query query) throws Exception {
        SimpleFeatureSource fs = this.loadSource(resource, query);
        return fs.getFeatures(query);
    }

    private SimpleFeatureSource loadSource(String resource, Query query) throws IOException {
        Assert.assertNotNull((Object)query);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath(resource), null);
        return s.getFeatureSource(s.getTypeNames()[0]);
    }

    protected SimpleFeatureCollection loadFeatures(DataStore store, String typeName) throws Exception {
        SimpleFeatureSource fs = store.getFeatureSource(typeName);
        return fs.getFeatures();
    }

    protected ListFeatureCollection createFeatureCollection() throws Exception {
        SimpleFeatureTypeBuilder tbuilder = new SimpleFeatureTypeBuilder();
        tbuilder.setName("junk");
        tbuilder.add("point", Point.class);
        tbuilder.add("byte", Byte.class);
        tbuilder.add("short", Short.class);
        tbuilder.add("double", Double.class);
        tbuilder.add("float", Float.class);
        tbuilder.add("string", String.class);
        tbuilder.add("date", Date.class);
        tbuilder.add("boolean", Boolean.class);
        tbuilder.add("number", Number.class);
        tbuilder.add("long", Long.class);
        tbuilder.add("bigdecimal", BigDecimal.class);
        tbuilder.add("biginteger", BigInteger.class);
        SimpleFeatureType type = tbuilder.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        ListFeatureCollection features = new ListFeatureCollection(type);
        int ii = 20;
        for (int i = 0; i < ii; ++i) {
            features.add(fb.buildFeature(null, new Object[]{new GeometryFactory().createPoint(new Coordinate(1.0, -1.0)), (byte)i, (short)i, (double)i, Float.valueOf(i), i + " ", new Date(i), Boolean.TRUE, 22, 1234567890123456789L, new BigDecimal(new BigInteger("12345678901234567890123456789"), 2), new BigInteger("12345678901234567890123456789")}));
        }
        return features;
    }

    private void writeFeatures(DataStore s, FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        s.createSchema((FeatureType)schema);
        try (FeatureWriter fw = s.getFeatureWriter(s.getTypeNames()[0], Transaction.AUTO_COMMIT);
             FeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature sf = (SimpleFeature)it.next();
                ((SimpleFeature)fw.next()).setAttributes(sf.getAttributes());
                fw.write();
            }
        }
    }

    private OGRDataStore createDataStore(File f) throws Exception {
        ListFeatureCollection fc = this.createFeatureCollection();
        f.delete();
        OGRDataStore sds = this.createDataStore(f.getAbsolutePath(), "ESRI shapefile");
        this.writeFeatures((DataStore)sds, (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc);
        return sds;
    }

    private OGRDataStore createDataStore() throws Exception {
        return this.createDataStore(this.getTempFile("test-shp", ".shp"));
    }

    private String[] shapeFileNames(String typeName) {
        typeName = "target/" + (String)typeName;
        return new String[]{(String)typeName + ".shp", (String)typeName + ".dbf", (String)typeName + ".shp", (String)typeName + ".shx", (String)typeName + ".prj"};
    }

    private void cleanFiles(String[] files) {
        for (String file : files) {
            File f = new File(file);
            if (!f.exists()) continue;
            f.delete();
        }
    }
}

