/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.geotools.ogcapi.Link;

public class TileMatrixSet
extends org.geotools.ows.wmts.model.TileMatrixSet {
    static JsonFactory factory = new JsonFactory();
    private String title;
    private String supportedCRS;
    private ArrayList<Link> links = new ArrayList();

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSupportedCRS(String supportedCRS) {
        this.supportedCRS = supportedCRS;
    }

    public static ArrayList<TileMatrixSet> buildTileMatrixSetList(URL url) throws IOException, JsonParseException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        try (JsonParser parser = factory.createParser(url);){
            JsonToken token = parser.nextToken();
            ArrayList<TileMatrixSet> ret = new ArrayList<TileMatrixSet>();
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"tileMatrixSets".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new UnsupportedOperationException("Was expecting an array of links");
                }
                while (parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)mapper.readTree(parser);
                    ret.add(TileMatrixSet.buildMatrixSet(node));
                }
            }
            ArrayList<TileMatrixSet> arrayList = ret;
            return arrayList;
        }
    }

    static TileMatrixSet buildMatrixSet(ObjectNode node) {
        TileMatrixSet tileMatrix = new TileMatrixSet();
        tileMatrix.setIdentifier(node.get("identifier").asText());
        if (node.has("title")) {
            tileMatrix.setTitle(node.get("title").asText());
        }
        if (node.has("supportedCRS")) {
            tileMatrix.setSupportedCRS(node.get("supportedCRS").asText());
        }
        if (node.has("links")) {
            for (JsonNode l : node.get("links")) {
                tileMatrix.getLinks().add(Link.buildLink((ObjectNode)l));
            }
        }
        return tileMatrix;
    }

    public String toString() {
        String name = this.getCoordinateReferenceSystem() != null ? this.getCoordinateReferenceSystem().getName().toString() : this.supportedCRS;
        return this.getIdentifier() + ", " + name + ", " + this.title;
    }
}

