/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.geotools.ogcapi.OgcApiUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TileMatrix
extends org.geotools.ows.wmts.model.TileMatrix {
    static JsonFactory factory = new JsonFactory();
    static GeometryFactory gf = new GeometryFactory();
    private String title;
    private CoordinateReferenceSystem crs;
    private String supportedCRS;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSupportedCRS(String supportedCRS) {
        this.supportedCRS = supportedCRS;
        this.crs = OgcApiUtils.parseCRS(supportedCRS);
    }

    public String getSupportedCRS() {
        return this.supportedCRS;
    }

    public static ArrayList<TileMatrix> buildTileMatrixList(URL url) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        try (JsonParser parser = factory.createParser(url);){
            JsonToken token = parser.nextToken();
            ArrayList<TileMatrix> ret = new ArrayList<TileMatrix>();
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"tileMatrix".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new UnsupportedOperationException("Was expecting an array of links");
                }
                while (parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)mapper.readTree(parser);
                    ret.add(TileMatrix.buildMatrix(node));
                }
            }
            ArrayList<TileMatrix> arrayList = ret;
            return arrayList;
        }
    }

    private static TileMatrix buildMatrix(ObjectNode node) {
        TileMatrix tileMatrix = new TileMatrix();
        tileMatrix.setIdentifier(node.get("identifier").asText());
        if (node.has("scaleDenominator")) {
            tileMatrix.setDenominator(node.get("scaleDenominator").asDouble());
        }
        if (node.has("topLeftCorner")) {
            double[] coords = new double[2];
            JsonNode tlCorner = node.get("topLeftCorner");
            int i = 0;
            for (JsonNode c : tlCorner) {
                coords[i++] = c.asDouble();
            }
            tileMatrix.setTopLeft(gf.createPoint(new Coordinate(coords[0], coords[1])));
        }
        if (node.has("tileWidth")) {
            tileMatrix.setTileWidth(node.get("tileWidth").asInt());
        }
        if (node.has("tileHeight")) {
            tileMatrix.setTileHeight(node.get("tileHeight").asInt());
        }
        if (node.has("matrixWidth")) {
            tileMatrix.setMatrixWidth(node.get("matrixWidth").asInt());
        }
        if (node.has("matrixHeight")) {
            tileMatrix.setMatrixHeight(node.get("matrixHeight").asInt());
        }
        return tileMatrix;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }
}

