/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class OgcApiUtils {
    private OgcApiUtils() {
    }

    public static CoordinateReferenceSystem parseCRS(String supportedCRS) {
        for (char seperator : new char[]{'/', ':'}) {
            int index = supportedCRS.lastIndexOf(seperator);
            if (index < 6) continue;
            String code = supportedCRS.substring(index + 1);
            String remainder = supportedCRS.substring(0, index - 1);
            index = remainder.lastIndexOf(seperator);
            remainder = remainder.substring(0, index);
            index = remainder.lastIndexOf(seperator);
            String auth = remainder.substring(index + 1);
            if (code.equalsIgnoreCase("900913")) {
                code = "3857";
            }
            if ("EPSG".equalsIgnoreCase(auth)) {
                try {
                    return CRS.decode((String)(auth + ":" + code));
                }
                catch (FactoryException factoryException) {
                    continue;
                }
            }
            if (!"CRS84".equalsIgnoreCase(code)) continue;
            return DefaultGeographicCRS.WGS84;
        }
        return null;
    }
}

