/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.geotools.ogcapi.Link;

public class FeaturesType {
    String title;
    String description;
    ArrayList<Link> links = new ArrayList();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public void setLinks(ArrayList<Link> links) {
        this.links = links;
    }

    public static FeaturesType fetchContents(URL featureURL) throws JsonParseException, IOException {
        FeaturesType ret = new FeaturesType();
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        try (JsonParser parser = factory.createParser(featureURL);){
            JsonToken token = parser.nextToken();
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (JsonToken.FIELD_NAME.equals((Object)token) && "title".equalsIgnoreCase(parser.currentName())) {
                    token = parser.nextToken();
                    ret.setTitle(parser.getValueAsString());
                }
                if (JsonToken.FIELD_NAME.equals((Object)token) && "description".equalsIgnoreCase(parser.currentName())) {
                    token = parser.nextToken();
                    ret.setDescription(parser.getValueAsString());
                }
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"links".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new UnsupportedOperationException("Was expecting an array of links");
                }
                while (parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)mapper.readTree(parser);
                    ret.links.add(Link.buildLink(node));
                }
            }
            FeaturesType featuresType = ret;
            return featuresType;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OGCAPI Features:\n").append("\tTitle: " + this.title + "\n").append("\tDesc: " + this.description + "\n");
        sb.append("\tLinks:\n");
        for (Link l : this.links) {
            sb.append("\t\t" + l.toString()).append("\n");
        }
        return sb.toString();
    }
}

