/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geotools.ogcapi.CollectionType;
import org.geotools.ogcapi.OgcApiUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CollectionsType {
    private static final String APPLICATION_JSON = "application/json";
    static JsonFactory factory = new JsonFactory();
    Map<String, CollectionType> collections = new HashMap<String, CollectionType>();
    ArrayList<CoordinateReferenceSystem> crs = new ArrayList();

    public String toString() {
        return "collections=" + this.collections;
    }

    static CollectionsType buildCollections(URL url) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        try (JsonParser parser = factory.createParser(url);){
            JsonToken token = parser.nextToken();
            CollectionsType ret = new CollectionsType();
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                ObjectNode node;
                if (JsonToken.FIELD_NAME.equals((Object)token) && "collections".equalsIgnoreCase(parser.currentName())) {
                    token = parser.nextToken();
                    if (!JsonToken.START_ARRAY.equals((Object)token)) {
                        throw new UnsupportedOperationException("Was expecting an array of collections");
                    }
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        node = (ObjectNode)mapper.readTree(parser);
                        if (!node.has("links")) continue;
                        JsonNode links = node.get("links");
                        for (JsonNode link : links) {
                            if (!"self".equalsIgnoreCase(link.get("rel").asText()) || !APPLICATION_JSON.equalsIgnoreCase(link.get("type").asText())) continue;
                            CollectionType realCollection = CollectionType.buildRealCollection(new URL(link.get("href").asText()));
                            ret.collections.put(realCollection.getIdentifier(), realCollection);
                        }
                    }
                }
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"crs".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new UnsupportedOperationException("Was expecting an array of CRS Strings");
                }
                while (parser.nextToken() == JsonToken.START_OBJECT) {
                    node = (ObjectNode)mapper.readTree(parser);
                    for (JsonNode c : node) {
                        ret.crs.add(OgcApiUtils.parseCRS(c.asText()));
                    }
                }
            }
            CollectionsType collectionsType = ret;
            return collectionsType;
        }
    }
}

