/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ogcapi;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ogcapi.Link;
import org.geotools.ogcapi.OgcApiUtils;
import org.geotools.ogcapi.StyleType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CollectionType {
    static JsonFactory factory = new JsonFactory();
    String identifier;
    String title;
    String description;
    ReferencedEnvelope extent = new ReferencedEnvelope();
    ArrayList<Link> links = new ArrayList();
    ArrayList<CoordinateReferenceSystem> crs = new ArrayList(0);
    ArrayList<StyleType> styles = new ArrayList();

    public void addStyle(StyleType style) {
        try {
            this.styles.add(style);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReferencedEnvelope getExtent() {
        return this.extent;
    }

    public void setExtent(ReferencedEnvelope extent) {
        this.extent = extent;
    }

    public static CollectionType buildRealCollection(URL url) throws IOException {
        block7: {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JtsModule());
            try (JsonParser parser = factory.createParser(url);){
                JsonToken token = parser.nextToken();
                if (parser.isClosed()) break block7;
                token = parser.nextToken();
                if (token == null) {
                    break block7;
                }
                ObjectNode node = (ObjectNode)mapper.readTree(parser);
                CollectionType collectionType = CollectionType.buildCollection(node);
                return collectionType;
            }
        }
        return null;
    }

    static CollectionType buildCollection(ObjectNode node) throws IOException {
        CollectionType ret = new CollectionType();
        if (node.has("links")) {
            JsonNode links = node.get("links");
            for (JsonNode link : links) {
                ret.links.add(Link.buildLink((ObjectNode)link));
            }
        }
        ret.setIdentifier(node.get("id").asText());
        if (node.has("title")) {
            ret.setTitle(node.get("title").asText());
        }
        if (node.has("description")) {
            ret.setDescription(node.get("description").asText());
        }
        if (node.has("extent")) {
            JsonNode spatial = node.get("extent").get("spatial");
            Iterator crs = OgcApiUtils.parseCRS(spatial.get("crs").asText());
            double[] coords = new double[4];
            int i = 0;
            ArrayNode box = (ArrayNode)spatial.get("bbox");
            for (JsonNode c : box.get(0)) {
                coords[i++] = c.asDouble();
            }
            ret.setExtent(new ReferencedEnvelope(coords[0], coords[2], coords[1], coords[3], (CoordinateReferenceSystem)crs));
        }
        if (node.has("crs")) {
            JsonNode crs = node.get("crs");
            for (JsonNode c : crs) {
                ret.crs.add(OgcApiUtils.parseCRS(c.asText()));
            }
        }
        if (node.has("styles")) {
            for (JsonNode s : node.get("styles")) {
                StyleType style = new StyleType();
                style.setIdentifier(s.get("id").asText());
                style.setTitle(s.get("title").asText());
                JsonNode links = s.get("links");
                for (JsonNode l : links) {
                    if (!"stylesheet".equalsIgnoreCase(l.get("rel").asText()) || !"application/vnd.ogc.sld+xml".equalsIgnoreCase(l.get("type").asText())) continue;
                    style.setSld(new URL(l.get("href").asText()));
                }
                ret.styles.add(style);
            }
        }
        return ret;
    }

    public String toString() {
        return "CollectionType [identifier=" + this.identifier + ", title=" + this.title + ", description=" + this.description + ", styles=" + this.styles + ", extent=" + this.extent + "]";
    }
}

