/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.grid.io.FileSystemFileSetManager;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ObjectFactory;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.imageio.netcdf.MultipleBandsDimensionInfo;
import org.geotools.imageio.netcdf.Slice2DIndex;
import org.geotools.imageio.netcdf.utilities.BaseDirectoryStrategy;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class AncillaryFileManager
implements FileSetManager {
    private FileSetManager fileSetManager;
    private static final Logger LOGGER = Logging.getLogger(AncillaryFileManager.class);
    private static ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    static final String DEFAULT_SCHEMA_NAME = "def";
    private static final Set<String> CUT_EXTENSIONS = new HashSet<String>();
    private static final Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
    private static JAXBContext CONTEXT = null;
    private final Map<String, MultipleBandsDimensionInfo> multipleBandsDimensionsInfo = new HashMap<String, MultipleBandsDimensionInfo>();
    protected static final Map<String, Indexer> INDEXER_CACHE = new SoftValueHashMap();
    protected static final Map<String, DataStoreConfiguration> DATASTORE_CONFIG_CACHE = new SoftValueHashMap();
    private Indexer indexer;
    private static final String INDEX_SUFFIX = ".xml";
    private static final String COVERAGE_NAME = "coverageName";
    private static final String DEFAULT_DATASTORE_PROPERTIES = "mddatastore.properties";
    private final List<Slice2DIndex> slicesIndexList = new ArrayList<Slice2DIndex>();
    Slice2DIndex.Slice2DIndexManager slicesIndexManager;
    Map<String, Indexer.Coverages.Coverage> coveragesMapping = new HashMap<String, Indexer.Coverages.Coverage>();
    Map<Name, String> variablesMap = null;
    boolean imposedSchema = false;
    private Map<String, PropertiesCollector> collectors = null;
    private File destinationDir;
    private File ncFile;
    private File parentDirectory;
    private File slicesIndexFile;
    private File datastoreIndexFile;
    private File indexerFile;

    public AncillaryFileManager(File netcdfFile, String indexFilePath) throws IOException, JAXBException, NoSuchAlgorithmException {
        this(netcdfFile, indexFilePath, null);
    }

    public AncillaryFileManager(File netcdfFile, String indexFilePath, String datastoreFilePath) throws IOException, JAXBException, NoSuchAlgorithmException {
        Utilities.ensureNonNull((String)"file", (Object)netcdfFile);
        if (!netcdfFile.exists()) {
            throw new IllegalArgumentException("The specified file doesn't exist: " + netcdfFile);
        }
        this.fileSetManager = new FileSystemFileSetManager();
        this.ncFile = netcdfFile;
        this.parentDirectory = new File(this.ncFile.getParent());
        File baseDir = BaseDirectoryStrategy.createStrategy().getBaseDirectory(this.parentDirectory);
        String mainFilePath = this.ncFile.getCanonicalPath();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(mainFilePath.getBytes());
        String hashCode = AncillaryFileManager.convertToHex(md.digest());
        String mainName = FilenameUtils.getName((String)mainFilePath);
        String extension = FilenameUtils.getExtension((String)mainName);
        String baseName = AncillaryFileManager.cutExtension(extension) ? FilenameUtils.removeExtension((String)mainName) : mainName;
        String outputLocalFolder = "." + baseName + "_" + hashCode;
        this.destinationDir = new File(baseDir, outputLocalFolder);
        boolean createdDir = false;
        if (!this.destinationDir.exists()) {
            createdDir = this.destinationDir.mkdirs();
            File origin = new File(this.destinationDir, "origin.txt");
            FileUtils.write((File)origin, (CharSequence)this.ncFile.getAbsolutePath(), (String)"UTF-8");
        }
        this.slicesIndexFile = new File(this.destinationDir, baseName + ".idx");
        this.indexerFile = this.lookupFile(indexFilePath, baseName, AuxiliaryFileType.INDEXER_XML);
        if (!createdDir) {
            AncillaryFileManager.checkReset(this.ncFile, this.slicesIndexFile, this.destinationDir);
        }
        this.fileSetManager.addFile(this.destinationDir.getAbsolutePath());
        this.initIndexer();
        this.datastoreIndexFile = this.lookupFile(datastoreFilePath, baseName, AuxiliaryFileType.INDEXER_DATASTORE);
    }

    private File lookupFile(String filePath, String baseName, AuxiliaryFileType type) {
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists() && file.canRead()) {
                return file;
            }
            if (!file.isAbsolute() && (file = new File(this.parentDirectory, filePath)).exists() && file.canRead()) {
                return file;
            }
        }
        return type.lookup(baseName, this.parentDirectory, this.destinationDir);
    }

    private static boolean cutExtension(String extension) {
        return CUT_EXTENSIONS.contains(extension);
    }

    private static void checkReset(File mainFile, File slicesIndexFile, File destinationDir) throws IOException {
        long indexTime;
        long mainFileTime;
        if (slicesIndexFile.exists() && (mainFileTime = mainFile.lastModified()) > (indexTime = slicesIndexFile.lastModified())) {
            Collection listedFiles = FileUtils.listFiles((File)destinationDir, null, (boolean)true);
            for (File file : listedFiles) {
                if (file.getAbsolutePath().endsWith(INDEX_SUFFIX)) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    public void writeToDisk() throws IOException, JAXBException {
        Slice2DIndex.Slice2DIndexManager.writeIndexFile(this.slicesIndexFile, this.slicesIndexList);
        if (!this.indexerFile.exists()) {
            this.storeIndexer(this.indexerFile, this.coveragesMapping);
        }
    }

    private void storeIndexer(File indexerFile, Map<String, Indexer.Coverages.Coverage> coveragesMapping) throws JAXBException {
        if (coveragesMapping == null || coveragesMapping.isEmpty()) {
            throw new IllegalArgumentException("No valid coverages name to be written");
        }
        Indexer indexer = OBJECT_FACTORY.createIndexer();
        Indexer.Coverages coverages = OBJECT_FACTORY.createIndexerCoverages();
        indexer.setCoverages(coverages);
        List coveragesList = coverages.getCoverage();
        Collection<Indexer.Coverages.Coverage> inputCoverages = coveragesMapping.values();
        for (Indexer.Coverages.Coverage cov : inputCoverages) {
            Indexer.Coverages.Coverage coverage = OBJECT_FACTORY.createIndexerCoveragesCoverage();
            coverage.setName(cov.getName());
            coverage.setOrigName(cov.getOrigName());
            coveragesList.add(coverage);
            SchemaType schema = OBJECT_FACTORY.createSchemaType();
            coverage.setSchema(schema);
            SchemaType inputSchema = cov.getSchema();
            schema.setAttributes(inputSchema.getAttributes());
            schema.setName(inputSchema.getName());
        }
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)indexer, indexerFile);
    }

    public Name getCoverageName(String varName) {
        Collection<Indexer.Coverages.Coverage> coverages = this.coveragesMapping.values();
        for (Indexer.Coverages.Coverage cov : coverages) {
            if (!varName.equalsIgnoreCase(cov.getOrigName())) continue;
            return new NameImpl(cov.getName());
        }
        return null;
    }

    public void dispose() {
        try {
            this.slicesIndexList.clear();
            if (this.slicesIndexManager != null) {
                this.slicesIndexManager.dispose();
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Errors Disposing the indexer." + e.getLocalizedMessage());
            }
        }
        finally {
            this.slicesIndexManager = null;
        }
    }

    public Slice2DIndex getSlice2DIndex(int imageIndex) throws IOException {
        Slice2DIndex variableIndex = this.slicesIndexManager != null ? this.slicesIndexManager.getSlice2DIndex(imageIndex) : this.slicesIndexList.get(imageIndex);
        return variableIndex;
    }

    public File getSlicesIndexFile() {
        return this.slicesIndexFile;
    }

    public File getIndexerFile() {
        return this.indexerFile;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public File getDatastoreIndexFile() {
        return this.datastoreIndexFile;
    }

    public void addSlice(Slice2DIndex variableIndex) {
        this.slicesIndexList.add(variableIndex);
    }

    public Indexer.Coverages.Coverage addCoverage(String varName) {
        Indexer.Coverages.Coverage coverage = OBJECT_FACTORY.createIndexerCoveragesCoverage();
        coverage.setName(varName);
        coverage.setOrigName(varName);
        this.addCoverage(coverage);
        return coverage;
    }

    private Indexer.Coverages.Coverage addCoverage(Indexer.Coverages.Coverage coverage) {
        if (this.variablesMap == null) {
            this.variablesMap = new HashMap<Name, String>();
            this.coveragesMapping = new HashMap<String, Indexer.Coverages.Coverage>();
        }
        this.coveragesMapping.put(coverage.getName(), coverage);
        this.variablesMap.put((Name)new NameImpl(coverage.getName()), coverage.getOrigName());
        return coverage;
    }

    public void initSliceManager() throws IOException {
        this.slicesIndexManager = new Slice2DIndex.Slice2DIndexManager(this.slicesIndexFile);
        this.slicesIndexManager.open();
    }

    public void resetSliceManager() throws IOException {
        if (this.slicesIndexManager != null) {
            this.slicesIndexManager.dispose();
        }
        this.slicesIndexList.clear();
    }

    public List<Name> getCoveragesNames() {
        ArrayList<Name> names = new ArrayList<Name>();
        Collection<Indexer.Coverages.Coverage> coverages = this.coveragesMapping.values();
        for (Indexer.Coverages.Coverage cov : coverages) {
            names.add((Name)new NameImpl(cov.getName()));
        }
        return names;
    }

    protected void initIndexer() throws JAXBException {
        String indexerPath = this.indexerFile.getAbsolutePath();
        Indexer cachedIndexer = INDEXER_CACHE.get(indexerPath);
        if (cachedIndexer != null) {
            this.indexer = cachedIndexer;
        } else if (this.indexerFile.exists() && this.indexerFile.canRead()) {
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            if (unmarshaller != null) {
                this.indexer = (Indexer)unmarshaller.unmarshal(this.indexerFile);
                if (this.indexer == null) {
                    throw new IllegalArgumentException("unable to create Indexer for " + indexerPath);
                }
                INDEXER_CACHE.put(this.indexerFile.getAbsolutePath(), this.indexer);
            } else {
                throw new IllegalArgumentException("unable to create Unmarshaller for " + indexerPath);
            }
        }
        if (this.indexer != null) {
            this.initMultipleBandsDimensionsInfo(this.indexer);
            SchemasType schemas = this.indexer.getSchemas();
            HashMap<String, String> schemaMapping = new HashMap<String, String>();
            if (schemas != null) {
                List schemaElements = schemas.getSchema();
                for (SchemaType schemaElement : schemaElements) {
                    schemaMapping.put(schemaElement.getName(), schemaElement.getAttributes());
                }
            }
            this.initPropertiesCollectors();
            this.initCoverages(schemaMapping);
        }
    }

    private void initCoverages(Map<String, String> schemaMapping) {
        Indexer.Coverages coverages = this.indexer.getCoverages();
        if (coverages != null) {
            List coverageElements = coverages.getCoverage();
            for (Indexer.Coverages.Coverage coverageElement : coverageElements) {
                String origName;
                String coverageName = coverageElement.getName();
                if (coverageName == null) {
                    coverageName = this.getCoverageNameFromCollector(coverageElement.getNameCollector());
                }
                origName = (origName = coverageElement.getOrigName()) != null && !origName.isEmpty() ? origName.trim() : coverageName;
                SchemaType coverageSchema = coverageElement.getSchema();
                String coverageSchemaRef = null;
                String schemaAttributes = null;
                if (coverageSchema != null) {
                    this.imposedSchema = true;
                    schemaAttributes = coverageSchema.getAttributes();
                    coverageSchemaRef = coverageSchema.getRef();
                }
                String schemaName = coverageName;
                if (coverageSchemaRef == null || coverageSchemaRef.trim().length() == 0) {
                    schemaMapping.put(coverageName, schemaAttributes);
                } else {
                    schemaName = coverageSchemaRef;
                    schemaAttributes = schemaMapping.get(schemaName);
                }
                Indexer.Coverages.Coverage coverage = this.createCoverage(coverageName, origName, schemaAttributes, schemaName);
                this.addCoverage(coverage);
            }
        }
    }

    private Indexer.Coverages.Coverage createCoverage(String coverageName, String origName, String schemaAttributes, String schemaName) {
        SchemaType schema = OBJECT_FACTORY.createSchemaType();
        Indexer.Coverages.Coverage coverage = OBJECT_FACTORY.createIndexerCoveragesCoverage();
        coverage.setOrigName(origName);
        coverage.setName(coverageName);
        coverage.setSchema(schema);
        schema.setAttributes(schemaAttributes);
        schema.setName(schemaName);
        return coverage;
    }

    private String getCoverageNameFromCollector(String nameCollector) {
        String coverageName = null;
        if (this.collectors != null && this.collectors.containsKey(nameCollector)) {
            HashMap keyValues = new HashMap();
            PropertiesCollector collector = this.collectors.get(nameCollector);
            collector.collect(this.ncFile);
            collector.setProperties(keyValues);
            collector.reset();
            coverageName = (String)keyValues.get(COVERAGE_NAME);
        }
        return coverageName;
    }

    private void initPropertiesCollectors() {
        List collectorList;
        Indexer.Collectors collectors = this.indexer.getCollectors();
        if (collectors != null && (collectorList = collectors.getCollector()) != null) {
            this.collectors = new HashMap<String, PropertiesCollector>();
            for (Indexer.Collectors.Collector collector : collectorList) {
                String collectorName = collector.getName();
                String spiName = collector.getSpi();
                String value = collector.getValue();
                String mapped = collector.getMapped();
                PropertiesCollectorSPI selectedSPI = null;
                for (PropertiesCollectorSPI spi : pcSPIs) {
                    if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(spiName)) continue;
                    selectedSPI = spi;
                    break;
                }
                if (selectedSPI == null) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Unable to find a PropertyCollector for this INTERNAL_STORE_SPI: " + spiName);
                    continue;
                }
                String[] propertyNames = new String[]{mapped != null ? mapped : COVERAGE_NAME};
                PropertiesCollector pc = selectedSPI.create((Object)("regex=" + value), Arrays.asList(propertyNames));
                if (pc == null) continue;
                this.collectors.put(collectorName, pc);
            }
        }
    }

    public String getTypeName(String coverageName) {
        return this.coveragesMapping.get(coverageName).getSchema().getName();
    }

    public String setSchema(Indexer.Coverages.Coverage coverage, String schemaName, String schemaDef) {
        Utilities.ensureNonNull((String)"coverage", (Object)coverage);
        Utilities.ensureNonNull((String)"schemaName", (Object)schemaName);
        if (coverage != null) {
            SchemaType schema = coverage.getSchema();
            if (schema == null) {
                schema = OBJECT_FACTORY.createSchemaType();
                coverage.setSchema(schema);
            }
            schema.setName(schemaName);
            if (schemaDef != null) {
                schema.setAttributes(schemaDef);
            }
            return schemaName;
        }
        return null;
    }

    public boolean acceptsVariable(String varName) {
        Utilities.ensureNonNull((String)"varName", (Object)varName);
        if (this.indexer == null || this.indexer.getCoverages() == null) {
            return true;
        }
        for (Indexer.Coverages.Coverage filteringCoverage : this.indexer.getCoverages().getCoverage()) {
            if (!varName.equalsIgnoreCase(filteringCoverage.getName()) && !varName.equalsIgnoreCase(filteringCoverage.getOrigName())) continue;
            return true;
        }
        return false;
    }

    public boolean isImposedSchema() {
        return this.imposedSchema;
    }

    public void addFile(String filePath) {
        this.fileSetManager.addFile(filePath);
    }

    public List<String> list() {
        return this.fileSetManager.list();
    }

    public void removeFile(String filePath) {
        this.fileSetManager.removeFile(filePath);
    }

    public void purge() {
        try {
            this.resetSliceManager();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        this.fileSetManager.purge();
    }

    public static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte b : data) {
            int halfbyte = b >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                buf.append(0 <= halfbyte && halfbyte <= 9 ? (char)(48 + halfbyte) : (char)(97 + (halfbyte - 10)));
                halfbyte = b & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public DataStoreConfiguration getDatastoreConfiguration() throws IOException {
        DataStoreConfiguration datastoreConfiguration = null;
        if (this.datastoreIndexFile != null) {
            String datastoreFilePath = this.datastoreIndexFile.getAbsolutePath();
            datastoreConfiguration = DATASTORE_CONFIG_CACHE.get(datastoreFilePath);
            if (datastoreConfiguration != null) {
                return datastoreConfiguration;
            }
            URL datastoreURL = URLs.fileToUrl((File)this.datastoreIndexFile);
            Properties properties = CoverageUtilities.loadPropertiesFromURL((URL)datastoreURL);
            if (properties != null) {
                String storeName = properties.getProperty("StoreName");
                if (storeName != null) {
                    datastoreConfiguration = new DataStoreConfiguration(storeName);
                } else {
                    String SPIClass = properties.getProperty("SPI");
                    try {
                        DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Map datastoreParams = Utils.filterDataStoreParams((Properties)properties, (DataStoreFactorySpi)spi);
                        datastoreConfiguration = new DataStoreConfiguration(spi, datastoreParams);
                        datastoreConfiguration.setDatastoreSpi(spi);
                        datastoreConfiguration.setParams(datastoreParams);
                        datastoreConfiguration.setShared(true);
                        this.checkStoreWrapping(datastoreConfiguration);
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException();
                        throw (IOException)ioe.initCause(e);
                    }
                }
                DATASTORE_CONFIG_CACHE.put(datastoreFilePath, datastoreConfiguration);
            }
        } else {
            File parentFile = this.slicesIndexFile.getParentFile();
            String database = FilenameUtils.removeExtension((String)FilenameUtils.getName((String)this.slicesIndexFile.getCanonicalPath())).replace(".", "");
            datastoreConfiguration = new DataStoreConfiguration(DataStoreConfiguration.getDefaultParams((String)database, (File)parentFile));
        }
        return datastoreConfiguration;
    }

    private void checkStoreWrapping(DataStoreConfiguration datastoreConfiguration) throws IOException {
        Map params = datastoreConfiguration.getParams();
        String param = this.getParameter("WrapStore");
        if (param != null && param.trim().equalsIgnoreCase("true")) {
            params.put("WrapStore", true);
            params.put("ParentLocation", URLs.fileToUrl((File)this.getDestinationDir()).toString());
        }
    }

    public String getParameter(String parameterKey) {
        ParametersType indexerParams = this.indexer != null ? this.indexer.getParameters() : null;
        return IndexerUtils.getParam((ParametersType)indexerParams, (String)parameterKey);
    }

    public boolean getParameterAsBoolean(String parameterKey) {
        ParametersType indexerParams = this.indexer != null ? this.indexer.getParameters() : null;
        String param = IndexerUtils.getParam((ParametersType)indexerParams, (String)parameterKey);
        return Boolean.valueOf(param);
    }

    private void initMultipleBandsDimensionsInfo(Indexer indexer) {
        if (indexer.getMultipleBandsDimensions() == null || indexer.getMultipleBandsDimensions().getMultipleBandsDimension() == null) {
            return;
        }
        for (Indexer.MultipleBandsDimensions.MultipleBandsDimension multipleBandsDimension : indexer.getMultipleBandsDimensions().getMultipleBandsDimension()) {
            NetCDFUtilities.addIgnoredDimension(multipleBandsDimension.getName());
            this.multipleBandsDimensionsInfo.put(multipleBandsDimension.getName(), new MultipleBandsDimensionInfo(multipleBandsDimension.getBandsNames()));
        }
    }

    MultipleBandsDimensionInfo getMultipleBandsDimensionInfo(String dimensionName) {
        return this.multipleBandsDimensionsInfo.get(dimensionName);
    }

    public static void clearCache() {
        DATASTORE_CONFIG_CACHE.clear();
        INDEXER_CACHE.clear();
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((String)"org.geotools.gce.imagemosaic.catalog.index");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
        }
        CUT_EXTENSIONS.add("nc");
        CUT_EXTENSIONS.add("ncml");
    }

    static enum AuxiliaryFileType {
        INDEXER_XML{

            @Override
            File lookup(String baseName, File parentDirectory, File destinationDirectory) {
                String optionalAuxiliaryPath = parentDirectory.getAbsolutePath() + File.separator + baseName + AncillaryFileManager.INDEX_SUFFIX;
                File file = new File(optionalAuxiliaryPath);
                if (!(file.exists() && file.canRead() || (file = new File(optionalAuxiliaryPath = parentDirectory.getAbsolutePath() + File.separator + "." + baseName + File.separator + baseName + AncillaryFileManager.INDEX_SUFFIX)).exists() && file.canRead())) {
                    file = null;
                }
                if (file == null) {
                    file = new File(destinationDirectory, baseName + AncillaryFileManager.INDEX_SUFFIX);
                }
                return file;
            }
        }
        ,
        INDEXER_DATASTORE{

            @Override
            File lookup(String baseName, File parentDirectory, File destinationDirectory) {
                String optionalAuxiliaryDatastorePath = parentDirectory.getAbsolutePath() + File.separator + AncillaryFileManager.DEFAULT_DATASTORE_PROPERTIES;
                File file = new File(optionalAuxiliaryDatastorePath);
                if (!(file.exists() && file.canRead() || (file = new File(optionalAuxiliaryDatastorePath = parentDirectory.getAbsolutePath() + File.separator + "." + baseName + File.separator + AncillaryFileManager.DEFAULT_DATASTORE_PROPERTIES)).exists() && file.canRead())) {
                    file = null;
                }
                if (!(file != null || (file = new File(destinationDirectory, AncillaryFileManager.DEFAULT_DATASTORE_PROPERTIES)).exists() && file.canRead())) {
                    file = null;
                }
                return file;
            }
        };


        abstract File lookup(String var1, File var2, File var3);
    }
}

