/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.geotools.util.NIOUtilities;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class MemoryMappedRandomAccessFile
extends RandomAccessFile {
    private static final int BUFFER_MEMORY_LIMIT;
    private static final int MAX_SEARCH_BUFFER_LIMIT;
    private static final int DEFAULT_BUFFER_SIZE = 1;
    private MappedByteBuffer mappedByteBuffer;
    private FileChannel channel;
    private CacheUsage cacheUsage = CacheUsage.NOT_IN_USE;
    private long currentOffset = 0L;
    private FileChannel.MapMode mapMode;

    public MemoryMappedRandomAccessFile(String location, String mode) throws IOException {
        super(MemoryMappedRandomAccessFile.getUriString(location), mode, 1);
        if (!this.readonly) {
            this.reportReadOnly();
        }
        this.initDataBuffer();
        this.cacheUsage = CacheUsage.IN_USE;
    }

    private void initDataBuffer() throws IOException {
        this.channel = this.file.getChannel();
        this.mapMode = FileChannel.MapMode.READ_ONLY;
        long channelSize = this.channel.size();
        this.dataSize = (int)channelSize;
        this.dataEnd = channelSize;
        long initialMapSize = channelSize - this.channel.position() < (long)BUFFER_MEMORY_LIMIT ? channelSize : (long)BUFFER_MEMORY_LIMIT;
        this.mappedByteBuffer = this.channel.map(this.mapMode, 0L, initialMapSize);
        this.mappedByteBuffer.position((int)this.channel.position());
        this.bufferStart = 0L;
        this.filePosition = 0L;
        this.endOfFile = false;
    }

    public void seek(long pos) throws IOException {
        this.filePosition = pos;
        if (this.filePosition < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (this.filePosition < this.dataEnd) {
            if (this.filePosition >= this.currentOffset + (long)BUFFER_MEMORY_LIMIT || this.filePosition < this.currentOffset) {
                this.bufferCheck(-1L);
            } else {
                this.mappedByteBuffer.position((int)(this.filePosition - this.currentOffset));
            }
            this.endOfFile = false;
        } else {
            this.endOfFile = true;
        }
    }

    public void release() {
        this.cacheUsage = CacheUsage.NOT_IN_USE;
        super.release();
    }

    public void reacquire() {
        this.cacheUsage = CacheUsage.IN_USE;
        super.reacquire();
    }

    public synchronized void setFileCache(FileCacheIF fileCache) {
        super.setFileCache(fileCache);
        if (fileCache == null) {
            this.cacheUsage = CacheUsage.NOT_IN_CACHE;
        }
    }

    public int read() throws IOException {
        this.bufferCheck(1L);
        if (this.filePosition < 0L) {
            throw new IOException(String.format("Negative file position %d for %s", new Object[]{this.filePosition, this}));
        }
        if (this.filePosition < this.dataEnd) {
            ++this.filePosition;
            return this.mappedByteBuffer.get() & 0xFF;
        }
        return -1;
    }

    private void bufferCheck(long readSize) throws IOException {
        if ((long)this.mappedByteBuffer.remaining() < readSize || readSize < 0L) {
            long fcPosition = this.filePosition;
            if (this.dataEnd > fcPosition + (long)BUFFER_MEMORY_LIMIT) {
                this.currentOffset = fcPosition;
            } else {
                this.currentOffset = this.dataEnd - (long)BUFFER_MEMORY_LIMIT;
                if (this.currentOffset < 0L) {
                    this.currentOffset = 0L;
                }
            }
            NIOUtilities.clean((ByteBuffer)this.mappedByteBuffer);
            this.mappedByteBuffer = this.channel.map(this.mapMode, this.currentOffset, BUFFER_MEMORY_LIMIT);
            this.mappedByteBuffer.position((int)(fcPosition - this.currentOffset));
        }
    }

    public int readBytes(byte[] dst, int offset, int length) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        if ((length = (int)Math.min((long)length, this.dataEnd - this.filePosition)) > 0) {
            if (this.filePosition < 0L) {
                throw new IOException(String.format("Negative file position %d for %s", new Object[]{this.filePosition, this}));
            }
            this.bufferCheck(length);
            this.mappedByteBuffer.get(dst, offset, length);
            this.filePosition += (long)length;
            if (this.filePosition == this.dataEnd) {
                this.endOfFile = true;
            }
        }
        return length;
    }

    public void write(int b) {
        this.reportReadOnly();
    }

    public void writeBytes(byte[] dst, int offset, int length) {
        this.reportReadOnly();
    }

    private void reportReadOnly() {
        throw new UnsupportedOperationException("Read Only MemoryMappedRandomAccessFile");
    }

    public long length() {
        return this.dataEnd;
    }

    public synchronized void close() throws IOException {
        FileCacheIF cache = MemoryMappedRandomAccessFile.getGlobalFileCache();
        if (cache != null && this.cacheUsage != CacheUsage.NOT_IN_CACHE) {
            if (this.cacheUsage != CacheUsage.IN_USE) {
                return;
            }
            this.cacheUsage = CacheUsage.NOT_IN_USE;
            if (cache.release((FileCacheable)this)) {
                return;
            }
            this.cacheUsage = CacheUsage.NOT_IN_CACHE;
        }
        if (debugLeaks) {
            openFiles.remove(this.location);
            if (showOpen) {
                System.out.println("  close " + this.location);
            }
        }
        if (this.file != null) {
            this.flush();
            this.file.close();
            this.file = null;
        }
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.mappedByteBuffer != null) {
            NIOUtilities.clean((ByteBuffer)this.mappedByteBuffer, (boolean)true);
        }
        this.mappedByteBuffer = null;
        this.channel = null;
    }

    public static String getUriString(String uriString) {
        StringUtil2.replace((String)uriString, (char)'\\', (String)"/");
        if (uriString.startsWith("file:")) {
            uriString = StringUtil2.unescape((String)uriString.substring(5));
        }
        return uriString;
    }

    public boolean searchForward(KMPMatch match, int maxBytes) throws IOException {
        long start = this.getFilePointer();
        long last = maxBytes < 0 ? this.length() : Math.min(this.length(), start + (long)maxBytes);
        long needToScan = last - start;
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            bytesAvailable = (int)(this.dataEnd - this.filePosition);
        }
        int scanBytes = (int)Math.min(Math.min((long)bytesAvailable, needToScan), (long)MAX_SEARCH_BUFFER_LIMIT);
        byte[] tempBuffer = new byte[scanBytes];
        long startPosition = this.mappedByteBuffer.position() % BUFFER_MEMORY_LIMIT;
        this.readBytes(tempBuffer, 0, scanBytes);
        int pos = match.indexOf(tempBuffer, 0, scanBytes);
        long seekPos = last;
        if (pos >= 0) {
            seekPos = this.currentOffset + startPosition + (long)pos;
            this.seek(seekPos);
            return true;
        }
        int matchLen = match.getMatchLength();
        needToScan -= (long)scanBytes;
        while (needToScan > (long)matchLen) {
            scanBytes = (int)Math.min(maxBytes > 0 ? (long)maxBytes : (long)MAX_SEARCH_BUFFER_LIMIT, needToScan);
            this.readBytes(tempBuffer, 0, scanBytes);
            pos = match.indexOf(tempBuffer, 0, scanBytes);
            if (pos > 0) {
                seekPos = this.currentOffset + (long)pos + (long)(this.endOfFile ? BUFFER_MEMORY_LIMIT - scanBytes : 0);
                this.seek(seekPos);
                return true;
            }
            needToScan -= (long)scanBytes;
        }
        this.seek(seekPos);
        return false;
    }

    static {
        long limit = Integer.MAX_VALUE;
        String memoryMappingLimit = System.getProperty("org.geotools.coverage.io.netcdf.memorymaplimit");
        if (!(memoryMappingLimit == null || memoryMappingLimit.isEmpty() || (limit = Long.parseLong(memoryMappingLimit)) >= 0L && limit <= Integer.MAX_VALUE)) {
            limit = Integer.MAX_VALUE;
        }
        BUFFER_MEMORY_LIMIT = (int)limit;
        MAX_SEARCH_BUFFER_LIMIT = Math.min(16384, BUFFER_MEMORY_LIMIT);
    }

    static enum CacheUsage {
        NOT_IN_CACHE,
        IN_USE,
        NOT_IN_USE;

    }
}

