/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import org.geotools.imageio.Identification;
import org.geotools.imageio.netcdf.utilities.NetCDFTimeUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.temporal.Position;
import org.opengis.util.InternationalString;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.format.SimpleUnitFormat;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NetCDFCRSUtilities {
    private static final Logger LOGGER = Logger.getLogger(NetCDFCRSUtilities.class.toString());
    public static final ReferencingFactoryContainer FACTORY_CONTAINER = ReferencingFactoryContainer.instance((Hints)GeoTools.getDefaultHints());
    static final PrecisionModel PRECISION_MODEL = new PrecisionModel(PrecisionModel.FLOATING);
    public static final GeometryFactory GEOM_FACTORY = new GeometryFactory(PRECISION_MODEL);
    private static final String[] DAYS = new String[]{"day", "dd", "days since"};
    private static final String[] DEGREES = new String[]{"degree", "degrees", "deg", "\u00b0"};
    private static final String[] HOURS = new String[]{"hour", "hh", "hours since"};
    private static final String[] METERS = new String[]{"meter", "meters", "metre", "metres", "m"};
    private static final String[] MINUTES = new String[]{"minute", "min", "minutes since"};
    private static final String[] SECONDS = new String[]{"second", "sec", "seconds since"};
    public static final Set<String> VERTICAL_AXIS_NAMES = new HashSet<String>();
    private static final Map<AxisType, String> DIRECTIONS = new HashMap<AxisType, String>(16);
    private static final Map<AxisType, String> OPPOSITES = new HashMap<AxisType, String>(16);
    public static final String CONVERT_AXIS_KM_KEY = "org.geotools.coverage.io.netcdf.convertAxis.km";
    private static final boolean CONVERT_AXIS_KM;
    private static final UnitFormat UNIT_FORMAT;
    public static final CoordinateReferenceSystem WGS84;

    private static void add(AxisType type, String direction, String opposite) {
        if (DIRECTIONS.put(type, direction) != null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        if (OPPOSITES.put(type, opposite) != null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
    }

    static String[] getUnitDirection(CoordinateAxis axis) {
        AxisType type = axis.getAxisType();
        String units = axis.getUnitsString();
        String direction = DIRECTIONS.get(type);
        if (direction != null) {
            int offset;
            if ("down".equalsIgnoreCase(axis.getPositive())) {
                direction = OPPOSITES.get(type);
            }
            if ((offset = units.lastIndexOf(95)) >= 0) {
                String opposite;
                String unitsDirection = units.substring(offset + 1).trim();
                if (unitsDirection.equalsIgnoreCase(opposite = OPPOSITES.get(type))) {
                    direction = opposite;
                }
                if (unitsDirection.equalsIgnoreCase(direction)) {
                    units = units.substring(0, offset).trim();
                }
            }
        }
        return new String[]{units, direction};
    }

    static AxisDirection getDirection(String direction) {
        return AxisDirection.valueOf((String)direction);
    }

    private static boolean contains(String toSearch, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!toSearch.toLowerCase().contains(list[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static VerticalCRS buildVerticalCrs(CoordinateAxis zAxis) {
        VerticalCRS verticalCRS = null;
        try {
            if (zAxis != null) {
                String axisName = zAxis.getFullName();
                if (!VERTICAL_AXIS_NAMES.contains(axisName)) {
                    return null;
                }
                String units = zAxis.getUnitsString();
                AxisType axisType = zAxis.getAxisType();
                String v_crsName = "Unknown";
                String v_datumName = "Unknown";
                String v_datumType = null;
                v_datumName = new Identification("Mean Sea Level", null, null, "EPSG:5100").getName();
                if (axisType == AxisType.RadialAzimuth || axisType == AxisType.GeoZ || axisType == AxisType.RadialElevation) {
                    v_datumType = "geoidal";
                } else if (axisType == AxisType.Height) {
                    if (!zAxis.getShortName().equalsIgnoreCase("height")) {
                        v_datumType = "depth";
                        v_crsName = new Identification("mean sea level depth", null, null, "EPSG:5715").getName();
                    } else {
                        v_datumType = "geoidal";
                        v_crsName = new Identification("mean sea level height", null, null, "EPSG:5714").getName();
                    }
                } else {
                    v_datumType = axisType == AxisType.Pressure ? "barometric" : "other_surface";
                }
                String direction = DIRECTIONS.get(axisType);
                if (direction != null) {
                    int offset;
                    if ("down".equalsIgnoreCase(zAxis.getPositive())) {
                        direction = OPPOSITES.get(axisType);
                    }
                    if ((offset = units.lastIndexOf(95)) >= 0) {
                        String opposite;
                        String unitsDirection = units.substring(offset + 1).trim();
                        if (unitsDirection.equalsIgnoreCase(opposite = OPPOSITES.get(axisType))) {
                            direction = opposite;
                        }
                        if (unitsDirection.equalsIgnoreCase(direction)) {
                            units = units.substring(0, offset).trim();
                        }
                    }
                }
                Map<String, String> csMap = Collections.singletonMap("name", "vertical_CS");
                VerticalCS verticalCS = FACTORY_CONTAINER.getCSFactory().createVerticalCS(csMap, NetCDFCRSUtilities.getAxis(zAxis.getShortName(), NetCDFCRSUtilities.getDirection(direction), units));
                Map<String, String> datumMap = Collections.singletonMap("name", v_datumName);
                VerticalDatum verticalDatum = FACTORY_CONTAINER.getDatumFactory().createVerticalDatum(datumMap, VerticalDatumType.valueOf((String)v_datumType));
                Map<String, String> crsMap = Collections.singletonMap("name", v_crsName);
                verticalCRS = FACTORY_CONTAINER.getCRSFactory().createVerticalCRS(crsMap, verticalDatum, verticalCS);
            }
        }
        catch (FactoryException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse vertical CRS", e);
            }
            verticalCRS = null;
        }
        return verticalCRS;
    }

    public static TemporalCRS buildTemporalCrs(CoordinateAxis timeAxis) {
        TemporalCRS temporalCRS;
        block18: {
            String t_datumName = new Identification("ISO8601", null, null, null).getName();
            temporalCRS = null;
            try {
                if (timeAxis == null) break block18;
                AxisType type = timeAxis.getAxisType();
                String units = timeAxis.getUnitsString();
                String direction = DIRECTIONS.get(type);
                if (direction != null) {
                    int offset;
                    if ("down".equalsIgnoreCase(timeAxis.getPositive())) {
                        direction = OPPOSITES.get(type);
                    }
                    if ((offset = units.lastIndexOf(95)) >= 0) {
                        String opposite;
                        String unitsDirection = units.substring(offset + 1).trim();
                        if (unitsDirection.equalsIgnoreCase(opposite = OPPOSITES.get(type))) {
                            direction = opposite;
                        }
                        if (unitsDirection.equalsIgnoreCase(direction)) {
                            units = units.substring(0, offset).trim();
                        }
                    }
                }
                Date epoch = null;
                String t_originDate = null;
                if (AxisType.Time.equals((Object)type) || AxisType.RunTime.equals((Object)type)) {
                    String origin = null;
                    String[] unitsParts = units.split("(?i)\\s+since\\s+");
                    if (unitsParts.length == 2) {
                        units = unitsParts[0].trim();
                        origin = unitsParts[1].trim();
                    } else {
                        Attribute attribute = timeAxis.findAttribute("time_origin");
                        if (attribute != null) {
                            origin = attribute.getStringValue();
                        }
                    }
                    if (origin != null) {
                        origin = NetCDFTimeUtilities.trimFractionalPart(origin);
                        origin = NetCDFTimeUtilities.checkDateDigits(origin);
                        try {
                            epoch = (Date)NetCDFUtilities.getAxisFormat(type, origin).parseObject(origin);
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(epoch);
                            DefaultInstant instant = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
                            t_originDate = instant.getPosition().getDateTime().toString();
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                }
                String axisName = timeAxis.getShortName();
                String t_csName = "time_CS";
                Map<String, String> csMap = Collections.singletonMap("name", t_csName);
                TimeCS timeCS = FACTORY_CONTAINER.getCSFactory().createTimeCS(csMap, NetCDFCRSUtilities.getAxis(axisName, NetCDFCRSUtilities.getDirection(direction), units));
                if (t_datumName == null) {
                    t_datumName = "Unknown";
                }
                Map<String, String> datumMap = Collections.singletonMap("name", t_datumName);
                DefaultPosition timeOrigin = new DefaultPosition((InternationalString)new SimpleInternationalString(t_originDate));
                TemporalDatum temporalDatum = FACTORY_CONTAINER.getDatumFactory().createTemporalDatum(datumMap, timeOrigin.getDate());
                String crsName = "time_CRS";
                Map<String, String> crsMap = Collections.singletonMap("name", crsName);
                temporalCRS = FACTORY_CONTAINER.getCRSFactory().createTemporalCRS(crsMap, temporalDatum, timeCS);
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to parse temporal CRS", e);
                }
                temporalCRS = null;
            }
            catch (ParseException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to parse temporal CRS", e);
                }
                temporalCRS = null;
            }
        }
        return temporalCRS;
    }

    public static CoordinateSystem getCoordinateSystem(VariableDS variableDS) {
        List systems = variableDS.getCoordinateSystems();
        if (systems.isEmpty()) {
            throw new RuntimeException("Coordinate system for Variable " + variableDS.getFullName() + " haven't been found");
        }
        return (CoordinateSystem)systems.get(0);
    }

    static CoordinateSystemAxis getAxis(String axisName, AxisDirection direction, String unitName) throws FactoryException {
        if (axisName == null) {
            return null;
        }
        DefaultCoordinateSystemAxis axisFound = DefaultCoordinateSystemAxis.getPredefined((String)axisName, (AxisDirection)direction);
        if (axisFound != null) {
            return axisFound;
        }
        Unit<?> unit = NetCDFCRSUtilities.getUnit(unitName);
        Map<String, String> map = Collections.singletonMap("name", axisName);
        try {
            return FACTORY_CONTAINER.getCSFactory().createCoordinateSystemAxis(map, axisName, direction, unit);
        }
        catch (FactoryException e) {
            throw new FactoryException(e.getLocalizedMessage());
        }
    }

    static Unit<?> getUnit(String unitName) throws FactoryException {
        if (NetCDFCRSUtilities.contains(unitName, METERS)) {
            return SI.METRE;
        }
        if (NetCDFCRSUtilities.contains(unitName, DEGREES)) {
            return NonSI.DEGREE_ANGLE;
        }
        if (NetCDFCRSUtilities.contains(unitName, SECONDS)) {
            return SI.SECOND;
        }
        if (NetCDFCRSUtilities.contains(unitName, MINUTES)) {
            return SI.MINUTE;
        }
        if (NetCDFCRSUtilities.contains(unitName, HOURS)) {
            return SI.HOUR;
        }
        if (NetCDFCRSUtilities.contains(unitName, DAYS)) {
            return SI.DAY;
        }
        try {
            return UNIT_FORMAT.parse((CharSequence)unitName);
        }
        catch (UnsupportedOperationException e) {
            throw new FactoryException("Unit not known : " + unitName, (Throwable)e);
        }
    }

    public static boolean isConvertAxisKm() {
        return CONVERT_AXIS_KM;
    }

    static {
        NetCDFCRSUtilities.add(AxisType.Time, "future", "past");
        NetCDFCRSUtilities.add(AxisType.RunTime, "future", "past");
        NetCDFCRSUtilities.add(AxisType.GeoX, "east", "west");
        NetCDFCRSUtilities.add(AxisType.GeoY, "north", "south");
        NetCDFCRSUtilities.add(AxisType.GeoZ, "up", "down");
        NetCDFCRSUtilities.add(AxisType.Lat, "north", "south");
        NetCDFCRSUtilities.add(AxisType.Lon, "east", "west");
        NetCDFCRSUtilities.add(AxisType.Height, "up", "down");
        NetCDFCRSUtilities.add(AxisType.Pressure, "up", "down");
        VERTICAL_AXIS_NAMES.add("elevation");
        VERTICAL_AXIS_NAMES.add("height");
        VERTICAL_AXIS_NAMES.add("z");
        VERTICAL_AXIS_NAMES.add("depth");
        VERTICAL_AXIS_NAMES.add("pressure");
        CONVERT_AXIS_KM = Boolean.parseBoolean(System.getProperty(CONVERT_AXIS_KM_KEY, "false"));
        UNIT_FORMAT = SimpleUnitFormat.getInstance();
        CoordinateReferenceSystem internalWGS84 = null;
        try {
            internalWGS84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            internalWGS84 = DefaultGeographicCRS.WGS84;
        }
        WGS84 = internalWGS84;
    }
}

