/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.imageio.Identification;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFTimeUtilities;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.SimpleInternationalString;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.util.InternationalString;
import ucar.nc2.dataset.CoordinateAxis;

public class ClimatologicalTimeCoordinateVariable
extends CoordinateVariable<Date> {
    private static final String ORIGIN_DATE = "0000-01-01T00:00:00";
    private static final Logger LOGGER = Logger.getLogger(ClimatologicalTimeCoordinateVariable.class.toString());

    public ClimatologicalTimeCoordinateVariable(CoordinateAxis coordinateAxis) {
        super(Date.class, coordinateAxis);
        this.init();
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    protected synchronized TemporalCRS buildCoordinateReferenceSystem() {
        String t_datumName = new Identification("ISO8601", null, null, null).getName();
        TemporalCRS temporalCRS = null;
        String axisName = this.coordinateAxis.getFullName();
        try {
            String t_csName = "time_CS";
            Map<String, String> csMap = Collections.singletonMap("name", t_csName);
            TimeCS timeCS = NetCDFCRSUtilities.FACTORY_CONTAINER.getCSFactory().createTimeCS(csMap, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.getPredefined((String)axisName, (AxisDirection)AxisDirection.FUTURE));
            if (t_datumName == null) {
                t_datumName = "Unknown";
            }
            Map<String, String> datumMap = Collections.singletonMap("name", t_datumName);
            DefaultPosition timeOrigin = new DefaultPosition((InternationalString)new SimpleInternationalString(ORIGIN_DATE));
            TemporalDatum temporalDatum = NetCDFCRSUtilities.FACTORY_CONTAINER.getDatumFactory().createTemporalDatum(datumMap, timeOrigin.getDate());
            String crsName = "time_CRS";
            Map<String, String> crsMap = Collections.singletonMap("name", crsName);
            temporalCRS = NetCDFCRSUtilities.FACTORY_CONTAINER.getCRSFactory().createTemporalCRS(crsMap, temporalDatum, timeCS);
        }
        catch (FactoryException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse temporal CRS", e);
            }
            temporalCRS = null;
        }
        catch (ParseException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to parse temporal CRS", e);
            }
            temporalCRS = null;
        }
        return temporalCRS;
    }

    @Override
    protected Date convertValue(Object o) {
        String coordVal = (String)o;
        GregorianCalendar cal = new GregorianCalendar(NetCDFTimeUtilities.UTC_TIMEZONE);
        cal.set(1, Integer.parseInt(coordVal.substring(0, 4)));
        cal.set(2, Integer.parseInt(coordVal.substring(4, 6)) - 1);
        cal.set(5, Integer.parseInt(coordVal.substring(6, 8)));
        cal.set(11, Integer.parseInt(coordVal.substring(8, 10)));
        cal.set(12, Integer.parseInt(coordVal.substring(10, 12)));
        cal.set(13, Integer.parseInt(coordVal.substring(12, 14)));
        cal.set(14, 0);
        return cal.getTime();
    }
}

