/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.coverage.io.netcdf.tools.H2Migrate;
import org.geotools.coverage.io.netcdf.tools.H2MigrateConfiguration;
import org.geotools.coverage.io.netcdf.tools.LocationFeatureCollection;
import org.geotools.coverage.io.netcdf.tools.LogWriter;
import org.geotools.coverage.io.netcdf.tools.MigrationException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.imageio.netcdf.AncillaryFileManager;
import org.geotools.jdbc.Index;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class H2Migrator {
    static final Logger LOGGER = Logging.getLogger(H2Migrate.class);
    public static final String NETCDF_DATASTORE_PROPERTIES = "netcdf_datastore.properties";
    private final H2MigrateConfiguration configuration;

    public H2Migrator(H2MigrateConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(this.configuration.getConcurrency());
        DataStore targetStore = H2MigrateConfiguration.getDataStore(this.configuration.getTargetStoreConfiguration());
        File logDirectory = this.configuration.getLogDirectory();
        try (LogWriter netcdfWriter = new LogWriter(new File(logDirectory, "migrated.txt"));
             LogWriter h2Writer = new LogWriter(new File(logDirectory, "h2.txt"));){
            targetStore.getTypeNames();
            LinkedHashSet<String> filePaths = new LinkedHashSet<String>();
            String[] coverages = this.configuration.getSourceStoreConfiguration() != null ? this.getFilesFromStore(filePaths) : this.getFilesFromReader(filePaths);
            HashMap<String, Future<Void>> futures = new HashMap<String, Future<Void>>();
            for (String string : filePaths) {
                futures.put(string, executorService.submit(() -> this.migrateNetcdf(path, coverages, targetStore, netcdfWriter, h2Writer)));
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    ((Future)entry.getValue()).get();
                }
                catch (Exception e) {
                    if (this.configuration.isFailureIgnored()) {
                        LOGGER.log(Level.WARNING, "Failed to migrate file: " + (String)entry.getKey(), e);
                        continue;
                    }
                    throw new MigrationException("Failed to migrate file: " + (String)entry.getKey(), e);
                }
            }
            this.updateMosaicConfiguration(coverages);
            LOGGER.info("Migration complete with success!");
        }
        finally {
            executorService.shutdown();
            if (targetStore != null) {
                targetStore.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFilesFromStore(LinkedHashSet<String> filePaths) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
        DataStore sourceStore = H2MigrateConfiguration.getDataStore(this.configuration.getSourceStoreConfiguration());
        String[] indexTables = this.configuration.getIndexTables() != null ? this.configuration.getIndexTables() : this.getCoverageNames();
        try {
            List<String> typeNames = Arrays.asList(sourceStore.getTypeNames());
            for (String indexTable : indexTables) {
                if (!typeNames.contains(indexTable)) {
                    throw new MigrationException("Could not find source index table " + indexTable + ", the available ones are " + typeNames);
                }
                List<String> coverageFiles = this.collectFilesFromTable(sourceStore, indexTable);
                filePaths.addAll(coverageFiles);
            }
        }
        finally {
            if (sourceStore != null) {
                sourceStore.dispose();
            }
        }
        return indexTables;
    }

    private String[] getCoverageNames() {
        String[] names = this.configuration.getCoverageNames();
        if (names == null) {
            File mosaicDirectory = this.configuration.getMosaicDirectory();
            names = (String[])Arrays.stream(mosaicDirectory.list((dir, name) -> {
                if (!name.endsWith(".properties")) {
                    return false;
                }
                String baseName = FilenameUtils.getBaseName((String)name);
                return new File(dir, baseName + "sample_image.dat").exists() || new File(dir, baseName + "sample_image").exists();
            })).map(f -> FilenameUtils.getBaseName((String)f)).toArray(String[]::new);
        }
        return names;
    }

    private List<String> collectFilesFromTable(DataStore sourceStore, String table) throws IOException {
        SimpleFeatureSource featureSource = sourceStore.getFeatureSource(table);
        Properties properties = this.getCoverageConfiguration(table);
        String locationAttribute = this.getProperty(properties, "LocationAttribute", "location");
        PathType pathType = PathType.valueOf((String)this.getProperty(properties, "PathType", PathType.ABSOLUTE.name()));
        Query q = new Query(table);
        q.setPropertyNames(new String[]{locationAttribute});
        UniqueVisitor uniqueLocations = new UniqueVisitor(locationAttribute);
        featureSource.getFeatures(q).accepts((FeatureVisitor)uniqueLocations, null);
        Set locations = uniqueLocations.getUnique();
        return locations.stream().map(l -> pathType.resolvePath(this.configuration.getMosaicDirectory().getPath(), l)).map(url -> URLs.urlToFile((URL)url).getAbsolutePath()).collect(Collectors.toList());
    }

    private String getProperty(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Properties getCoverageConfiguration(String coverage) {
        File mosaicDirectory = this.configuration.getMosaicDirectory();
        File coverageConfig = new File(mosaicDirectory, coverage + ".properties");
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(coverageConfig);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new MigrationException("Could not open the image mosaic configuration file " + coverageConfig, e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFilesFromReader(LinkedHashSet<String> filePaths) throws IOException {
        ImageMosaicReader reader = null;
        try {
            String[] coverages;
            reader = new ImageMosaicReader((Object)this.configuration.getMosaicDirectory());
            for (String coverage : coverages = reader.getGridCoverageNames()) {
                List<String> coverageFiles = this.collectFilesFromTable(reader, coverage);
                filePaths.addAll(coverageFiles);
            }
            String[] stringArray = coverages;
            return stringArray;
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private List<String> collectFilesFromTable(ImageMosaicReader reader, String coverage) throws IOException {
        String mosaicDirectoryPath = this.configuration.getMosaicDirectory().getAbsolutePath();
        GranuleSource granuleSource = reader.getGranules(coverage, true);
        MosaicConfigurationBean configuration = reader.getRasterManager(coverage).getConfiguration();
        CatalogConfigurationBean catalogConfiguration = configuration.getCatalogConfigurationBean();
        PathType pathType = catalogConfiguration.getPathType();
        if (pathType != PathType.ABSOLUTE && pathType != PathType.RELATIVE) {
            throw new MigrationException("Cannot perform migration with path type " + pathType);
        }
        String locationAttribute = catalogConfiguration.getLocationAttribute();
        Query q = new Query(coverage);
        q.setPropertyNames(new String[]{locationAttribute});
        UniqueVisitor uniqueLocations = new UniqueVisitor(locationAttribute);
        SimpleFeatureCollection granules = granuleSource.getGranules(q);
        granules.accepts((FeatureVisitor)uniqueLocations, null);
        Set locations = uniqueLocations.getUnique();
        return locations.stream().map(l -> pathType.resolvePath(mosaicDirectoryPath, l)).map(url -> URLs.urlToFile((URL)url).getAbsolutePath()).collect(Collectors.toList());
    }

    private void updateMosaicConfiguration(String[] coverageNames) throws JAXBException, IOException {
        File netcdfStore = new File(this.configuration.getMosaicDirectory(), NETCDF_DATASTORE_PROPERTIES);
        try (FileOutputStream os = new FileOutputStream(netcdfStore);){
            if (this.configuration.getIndexStoreName() != null) {
                Properties properties = new Properties();
                properties.put("StoreName", this.configuration.getIndexStoreName());
                properties.store(os, null);
            } else {
                this.configuration.getTargetStoreConfiguration().store(os, null);
            }
        }
        File indexerFile = new File(this.configuration.getMosaicDirectory(), "indexer.xml");
        Indexer indexer = Utils.unmarshal((File)indexerFile);
        List parameters = indexer.getParameters().getParameter();
        Optional<ParametersType.Parameter> indexerParameter = this.getParameter("AuxiliaryDatastoreFile", parameters);
        if (indexerParameter.isPresent()) {
            indexerParameter.get().setValue(NETCDF_DATASTORE_PROPERTIES);
        } else {
            ParametersType.Parameter param = new ParametersType.Parameter();
            param.setName("AuxiliaryDatastoreFile");
            param.setValue(NETCDF_DATASTORE_PROPERTIES);
            parameters.add(param);
        }
        Optional<ParametersType.Parameter> auxParameter = this.getParameter("AuxiliaryFile", parameters);
        if (!auxParameter.isPresent()) {
            ParametersType.Parameter param = new ParametersType.Parameter();
            param.setName("AuxiliaryFile");
            param.setValue("_auxiliary.xml");
            parameters.add(param);
        }
        Utils.marshal((Indexer)indexer, (File)indexerFile);
        LOGGER.info("Indexer.xml updated with auxiliary data store!");
        for (String coverageName : coverageNames) {
            File configFile = new File(this.configuration.getMosaicDirectory(), coverageName + ".properties");
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(configFile);){
                properties.load(is);
            }
            properties.put("AuxiliaryDatastoreFile", NETCDF_DATASTORE_PROPERTIES);
            if (properties.get("AuxiliaryFile") == null) {
                properties.put("AuxiliaryFile", "_auxiliary.xml");
            }
            try (FileOutputStream os = new FileOutputStream(configFile);){
                properties.store(os, null);
            }
            LOGGER.info(configFile.getName() + " updated with auxiliary data store!");
        }
    }

    private Optional<ParametersType.Parameter> getParameter(String name, List<ParametersType.Parameter> parameters) {
        return parameters.stream().filter(p -> name.equalsIgnoreCase(p.getName())).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Void migrateNetcdf(String path, String[] coverages, DataStore targetStore, LogWriter netcdfWriter, LogWriter h2Writer) throws IOException, JAXBException, NoSuchAlgorithmException {
        AncillaryFileManager provider = new AncillaryFileManager(new File(path), null){

            @Override
            protected void initIndexer() {
            }
        };
        DataStoreConfiguration config = provider.getDatastoreConfiguration();
        if (!(config.getDatastoreSpi() instanceof H2DataStoreFactory)) {
            throw new MigrationException("The NetCDF index datastore is not a H2, but " + config.getDatastoreSpi() + ", the migration was not designed to handle that case");
        }
        DataStore sourceDataStore = config.getDatastoreSpi().createDataStore(config.getParams());
        DefaultTransaction t = new DefaultTransaction();
        try {
            HashSet<String> typeNames = new HashSet<String>(Arrays.asList(sourceDataStore.getTypeNames()));
            ArrayList<String> shuffledCoverages = new ArrayList<String>(Arrays.asList(coverages));
            Collections.shuffle(shuffledCoverages);
            for (String coverage : shuffledCoverages) {
                if (!typeNames.contains(coverage)) continue;
                LOGGER.info("Migrating " + path + ":" + coverage);
                SimpleFeatureSource source = sourceDataStore.getFeatureSource(coverage);
                SimpleFeatureStore store = this.getTargetFeatureStore((SimpleFeatureType)source.getSchema(), targetStore, coverage);
                LocationFeatureCollection indexWithLocation = new LocationFeatureCollection(source.getFeatures(), path, (SimpleFeatureType)store.getSchema());
                store.setTransaction((Transaction)t);
                store.addFeatures((FeatureCollection)indexWithLocation);
                LOGGER.info("Migration for " + path + ":" + coverage + " succesfull");
            }
            t.commit();
            netcdfWriter.addLines(path);
            h2Writer.addLines(this.collectH2Files(config));
        }
        finally {
            t.close();
            if (sourceDataStore != null) {
                sourceDataStore.dispose();
            }
        }
        return null;
    }

    private String[] collectH2Files(DataStoreConfiguration config) throws IOException {
        String database = (String)config.getParams().get("database");
        if (database.startsWith("file:")) {
            database = database.substring("file:".length());
        }
        File auxDirectory = new File(database).getParentFile();
        String databaseName = new File(database).getName();
        return (String[])Files.list(auxDirectory.toPath()).filter(p -> this.isH2DatabaseFile(databaseName, (Path)p)).map(p -> p.toAbsolutePath().toString()).toArray(String[]::new);
    }

    private boolean isH2DatabaseFile(String databaseName, Path p) {
        Path pfn = p.getFileName();
        if (pfn == null) {
            return false;
        }
        String fileName = pfn.toString();
        boolean result = fileName.startsWith(databaseName) && fileName.endsWith(".db");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeatureStore getTargetFeatureStore(SimpleFeatureType sourceSchema, DataStore targetStore, String coverage) throws IOException {
        List<String> existingTypeNames = Arrays.asList(targetStore.getTypeNames());
        if (!existingTypeNames.contains(coverage)) {
            String string = coverage;
            synchronized (string) {
                existingTypeNames = Arrays.asList(targetStore.getTypeNames());
                if (!existingTypeNames.contains(coverage)) {
                    SimpleFeatureType schema = this.buildTargetSchema(sourceSchema);
                    targetStore.createSchema((FeatureType)schema);
                    if (targetStore instanceof JDBCDataStore) {
                        ((JDBCDataStore)targetStore).createIndex(new Index(schema.getTypeName(), schema.getTypeName() + "_loc_idx", true, new String[]{"location", "imageindex"}));
                    }
                }
            }
        }
        return (SimpleFeatureStore)targetStore.getFeatureSource(coverage);
    }

    private SimpleFeatureType buildTargetSchema(SimpleFeatureType sourceSchema) {
        if (sourceSchema.getDescriptor("location") != null) {
            return sourceSchema;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(sourceSchema);
        tb.add("location", String.class);
        return tb.buildFeatureType();
    }
}

