/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.crs;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.coverage.io.netcdf.crs.NetCDFProjection;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.AlbersEqualArea;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.Mercator1SP;
import org.geotools.referencing.operation.projection.Mercator2SP;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.referencing.operation.projection.RotatedPole;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;

public enum NetCDFCoordinateReferenceSystemType {
    WGS84{

        @Override
        public NetCDFCoordinate[] getCoordinates() {
            return NetCDFCoordinate.LATLON_COORDS;
        }

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return null;
        }
    }
    ,
    SPATIAL_REF{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return null;
        }
    }
    ,
    ALBERS_EQUAL_AREA{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.ALBERS_EQUAL_AREA;
        }
    }
    ,
    LAMBERT_AZIMUTHAL_EQUAL_AREA{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.LAMBERT_AZIMUTHAL_EQUAL_AREA;
        }
    }
    ,
    LAMBERT_CONFORMAL_CONIC_1SP{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.LAMBERT_CONFORMAL_CONIC_1SP;
        }
    }
    ,
    LAMBERT_CONFORMAL_CONIC_2SP{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.LAMBERT_CONFORMAL_CONIC_2SP;
        }
    }
    ,
    MERCATOR_1SP{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.MERCATOR_1SP;
        }
    }
    ,
    MERCATOR_2SP{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.MERCATOR_2SP;
        }
    }
    ,
    TRANSVERSE_MERCATOR{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.TRANSVERSE_MERCATOR;
        }
    }
    ,
    ORTHOGRAPHIC{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.ORTHOGRAPHIC;
        }
    }
    ,
    POLAR_STEREOGRAPHIC{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.POLAR_STEREOGRAPHIC;
        }
    }
    ,
    STEREOGRAPHIC{

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.STEREOGRAPHIC;
        }
    }
    ,
    ROTATED_POLE{

        @Override
        public NetCDFCoordinate[] getCoordinates() {
            return NetCDFCoordinate.RLATLON_COORDS;
        }

        @Override
        public NetCDFProjection getNetCDFProjection() {
            return NetCDFProjection.ROTATED_POLE;
        }
    };

    private static final Logger LOGGER;

    public static NetCDFCoordinateReferenceSystemType parseCRS(CoordinateReferenceSystem crs) {
        NetCDFCoordinateReferenceSystemType crsType = null;
        if (crs instanceof DefaultGeographicCRS) {
            crsType = WGS84;
        } else {
            if (crs instanceof DefaultDerivedCRS && ((DefaultDerivedCRS)crs).getConversionFromBase().getMathTransform() instanceof RotatedPole) {
                return ROTATED_POLE;
            }
            if (crs instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)crs;
                if (NetCDFCoordinateReferenceSystemType.hasConcatenatedTransform(projectedCRS)) {
                    Projection projection = projectedCRS.getConversionFromBase();
                    MathTransform mt = projection.getMathTransform();
                    ConcatenatedTransform cmt = (ConcatenatedTransform)mt;
                    crsType = NetCDFCoordinateReferenceSystemType.extractProjectionType(cmt);
                } else {
                    crsType = NetCDFCoordinateReferenceSystemType.getProjectionType(projectedCRS);
                }
            } else {
                crsType = SPATIAL_REF;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using a NetCDF CRS based on " + (Object)((Object)crsType));
        }
        return crsType;
    }

    private static NetCDFCoordinateReferenceSystemType extractProjectionType(ConcatenatedTransform cmt) {
        NetCDFCoordinateReferenceSystemType projectionType;
        if (!(cmt.transform1 instanceof ConcatenatedTransform) && !(cmt.transform2 instanceof ConcatenatedTransform) && (projectionType = NetCDFCoordinateReferenceSystemType.getProjectionType(cmt.transform1)) != null) {
            return projectionType;
        }
        throw new IllegalArgumentException("The specified projection's transformation is not supported: " + cmt);
    }

    private static boolean hasConcatenatedTransform(ProjectedCRS projectedCRS) {
        Projection projection = projectedCRS.getConversionFromBase();
        MathTransform mt = projection.getMathTransform();
        return mt instanceof ConcatenatedTransform;
    }

    private static NetCDFCoordinateReferenceSystemType getProjectionType(ProjectedCRS projectedCRS) {
        Projection projection = projectedCRS.getConversionFromBase();
        MathTransform transform = projection.getMathTransform();
        NetCDFCoordinateReferenceSystemType projectionType = NetCDFCoordinateReferenceSystemType.getProjectionType(transform);
        if (projectionType == null) {
            throw new IllegalArgumentException("The specified projection is not supported: " + transform.getClass());
        }
        return projectionType;
    }

    private static NetCDFCoordinateReferenceSystemType getProjectionType(MathTransform transform) {
        if (transform instanceof TransverseMercator) {
            return TRANSVERSE_MERCATOR;
        }
        if (transform instanceof LambertConformal1SP) {
            return LAMBERT_CONFORMAL_CONIC_1SP;
        }
        if (transform instanceof LambertConformal2SP) {
            return LAMBERT_CONFORMAL_CONIC_2SP;
        }
        if (transform instanceof LambertAzimuthalEqualArea) {
            return LAMBERT_AZIMUTHAL_EQUAL_AREA;
        }
        if (transform instanceof Orthographic) {
            return ORTHOGRAPHIC;
        }
        if (transform instanceof PolarStereographic) {
            return POLAR_STEREOGRAPHIC;
        }
        if (transform instanceof Stereographic) {
            return STEREOGRAPHIC;
        }
        if (transform instanceof Mercator1SP) {
            return MERCATOR_1SP;
        }
        if (transform instanceof Mercator2SP) {
            return MERCATOR_2SP;
        }
        if (transform instanceof AlbersEqualArea) {
            return ALBERS_EQUAL_AREA;
        }
        if (transform instanceof RotatedPole) {
            return ROTATED_POLE;
        }
        return null;
    }

    public NetCDFCoordinate[] getCoordinates() {
        return NetCDFCoordinate.YX_COORDS;
    }

    public abstract NetCDFProjection getNetCDFProjection();

    public NetCDFCoordinate[] getCoordinates(CoordinateReferenceSystem crs) {
        ProjectedCRS projectedCrs;
        NetCDFCoordinate[] axisCoordinates = this.getCoordinates();
        if (this != WGS84 && crs instanceof ProjectedCRS && NetCDFCoordinateReferenceSystemType.hasConcatenatedTransform(projectedCrs = (ProjectedCRS)crs)) {
            Unit unit = crs.getCoordinateSystem().getAxis(0).getUnit();
            NetCDFCoordinate[] newAxisCoordinates = new NetCDFCoordinate[2];
            for (int i = 0; i < 2; ++i) {
                newAxisCoordinates[i] = new NetCDFCoordinate(axisCoordinates[i]);
                newAxisCoordinates[i].setUnits(unit.toString());
            }
            axisCoordinates = newAxisCoordinates;
        }
        return axisCoordinates;
    }

    static {
        LOGGER = Logging.getLogger(NetCDFCoordinateReferenceSystemType.class);
    }

    public static class NetCDFCoordinate {
        private static final NetCDFCoordinate LAT_COORDINATE = new NetCDFCoordinate("lat", "latitude", "latitude", "lat", "degrees_north");
        private static final NetCDFCoordinate LON_COORDINATE = new NetCDFCoordinate("lon", "longitude", "longitude", "lon", "degrees_east");
        private static final NetCDFCoordinate RLAT_COORDINATE = new NetCDFCoordinate("rlat", "grid_latitude", "grid_latitude", "rlat", "degrees");
        private static final NetCDFCoordinate RLON_COORDINATE = new NetCDFCoordinate("rlon", "grid_longitude", "grid_longitude", "rlon", "degrees");
        private static final NetCDFCoordinate X_COORDINATE = new NetCDFCoordinate("x", "x coordinate of projection", "projection_x_coordinate", "x", "m");
        private static final NetCDFCoordinate Y_COORDINATE = new NetCDFCoordinate("y", "y coordinate of projection", "projection_y_coordinate", "y", "m");
        public static final NetCDFCoordinate[] LATLON_COORDS = new NetCDFCoordinate[]{LAT_COORDINATE, LON_COORDINATE};
        public static final NetCDFCoordinate[] RLATLON_COORDS = new NetCDFCoordinate[]{RLAT_COORDINATE, RLON_COORDINATE};
        public static final NetCDFCoordinate[] YX_COORDS = new NetCDFCoordinate[]{Y_COORDINATE, X_COORDINATE};
        private String shortName;
        private String dimensionName;
        private String longName;
        private String units;
        private String standardName;

        public NetCDFCoordinate(NetCDFCoordinate that) {
            this.shortName = that.getShortName();
            this.longName = that.getLongName();
            this.dimensionName = that.getDimensionName();
            this.standardName = that.getStandardName();
            this.units = that.getUnits();
        }

        public String getShortName() {
            return this.shortName;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public String getLongName() {
            return this.longName;
        }

        public void setName(String longName) {
            this.longName = longName;
        }

        public String getStandardName() {
            return this.standardName;
        }

        public void setStandardName(String standardName) {
            this.standardName = standardName;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String toString() {
            return "NetCDFCoordinate [shortName=" + this.shortName + ", dimensionName=" + this.dimensionName + ", longName=" + this.longName + ", units=" + this.units + ", standardName=" + this.standardName + "]";
        }

        public NetCDFCoordinate(String shortName, String longName, String standardName, String dimensionName, String units) {
            this.shortName = shortName;
            this.longName = longName;
            this.standardName = standardName;
            this.dimensionName = dimensionName;
            this.units = units;
        }
    }
}

