/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.crs;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.crs.CRSAuthorityFactory;

public class NetCDFCRSAuthorityFactory
extends FactoryUsingWKT
implements CRSAuthorityFactory {
    public static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "netcdf.projections.file";

    public NetCDFCRSAuthorityFactory() {
        this(null);
    }

    public NetCDFCRSAuthorityFactory(Hints userHints) {
        this(userHints, 95);
    }

    public NetCDFCRSAuthorityFactory(Hints userHints, int priority) {
        super(userHints, priority);
    }

    protected URL getDefinitionsURL() {
        String cust_proj_file = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        if (cust_proj_file != null) {
            File proj_file = new File(cust_proj_file);
            if (proj_file.exists()) {
                URL url = URLs.fileToUrl((File)proj_file);
                if (url != null) {
                    return url;
                }
                LOGGER.log(Level.SEVERE, "Had troubles converting " + cust_proj_file + " to URL");
            }
        } else {
            cust_proj_file = "netcdf.projections.properties";
            return NetCDFCRSAuthorityFactory.class.getResource(cust_proj_file);
        }
        return null;
    }

    public String toString() {
        return super.toString() + "\nDefinition URL = " + this.getDefinitionsURL();
    }
}

