/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.imageio.netcdf.AncillaryFileManager;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class NetCDFAuxiliaryStoreFactory
implements DataStoreFactorySpi {
    public static final String AUXILIARY_STORE_KEY = "org.geotools.coverage.io.netcdf.auxiliary.store";
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("File", File.class, "NetCDF File Path", true, null, Collections.emptyMap());
    public static final DataAccessFactory.Param INDEX_PARAM = new DataAccessFactory.Param("Index", String.class, "Index File Path", false, null, Collections.emptyMap());
    public static final DataAccessFactory.Param DS_PARAM = new DataAccessFactory.Param("DataStore", String.class, "DataStore File Path", false, null, Collections.emptyMap());
    public static final DataAccessFactory.Param NS_PARAM = new DataAccessFactory.Param("namespace", String.class, "Namespace", false, null, Collections.emptyMap());

    public String getDisplayName() {
        return "NetCDF Auxiliary Store";
    }

    public String getDescription() {
        return "Published NetCDF Index Data";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM, INDEX_PARAM, DS_PARAM, NS_PARAM};
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            File file = (File)FILE_PARAM.lookUp(params);
            String indexPath = (String)INDEX_PARAM.lookUp(params);
            String dsPath = (String)DS_PARAM.lookUp(params);
            AncillaryFileManager ancilaryFileManager = new AncillaryFileManager(file, indexPath, dsPath);
            DataStoreConfiguration datastoreConfig = ancilaryFileManager.getDatastoreConfiguration();
            return datastoreConfig.getDatastoreSpi().canProcess(datastoreConfig.getParams());
        }
        catch (IOException | NoSuchAlgorithmException | JAXBException e) {
            return false;
        }
    }

    public boolean isAvailable() {
        return "true".equalsIgnoreCase(System.getProperty(AUXILIARY_STORE_KEY));
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        File file = (File)FILE_PARAM.lookUp(params);
        String indexPath = (String)INDEX_PARAM.lookUp(params);
        String dsPath = (String)DS_PARAM.lookUp(params);
        try {
            AncillaryFileManager ancilaryFileManager = new AncillaryFileManager(file, indexPath, dsPath);
            DataStoreConfiguration datastoreConfig = ancilaryFileManager.getDatastoreConfiguration();
            final DataStore delegate = datastoreConfig.getDatastoreSpi().createDataStore(datastoreConfig.getParams());
            String namespace = (String)NS_PARAM.lookUp(params);
            if (namespace != null && delegate instanceof ContentDataStore) {
                ((ContentDataStore)delegate).setNamespaceURI(namespace);
            }
            return new DataStore(){

                public ServiceInfo getInfo() {
                    return delegate.getInfo();
                }

                public void createSchema(SimpleFeatureType featureType) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void removeSchema(Name typeName) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public List<Name> getNames() throws IOException {
                    return delegate.getNames();
                }

                public SimpleFeatureType getSchema(Name name) throws IOException {
                    return (SimpleFeatureType)delegate.getSchema(name);
                }

                public void dispose() {
                }

                public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public void removeSchema(String typeName) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public String[] getTypeNames() throws IOException {
                    return delegate.getTypeNames();
                }

                public SimpleFeatureType getSchema(String typeName) throws IOException {
                    return delegate.getSchema(typeName);
                }

                public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
                    return delegate.getFeatureSource(typeName);
                }

                public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
                    return delegate.getFeatureSource(typeName);
                }

                public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
                    return delegate.getFeatureReader(query, transaction);
                }

                public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public LockingManager getLockingManager() {
                    return delegate.getLockingManager();
                }
            };
        }
        catch (NoSuchAlgorithmException | JAXBException e) {
            throw new IOException(e);
        }
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }
}

