/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.imageio.netcdf.AncillaryFileManager;
import org.geotools.imageio.netcdf.VariableAdapter;
import org.geotools.imageio.netcdf.cv.CoordinateHandlerFinder;
import org.geotools.imageio.netcdf.cv.CoordinateHandlerSpi;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.util.NumberRange;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionConfigBuilder;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.io.RandomAccessFile;

public class NetCDFUtilities {
    public static final boolean CHECK_COORDINATE_PLUGINS;
    public static final String CHECK_COORDINATE_PLUGINS_KEY = "netcdf.coordinates.enablePlugins";
    public static final String NETCDF4_MIMETYPE = "application/x-netcdf4";
    public static final String NETCDF3_MIMETYPE = "application/x-netcdf";
    public static final String NETCDF = "NetCDF";
    public static final String NETCDF4 = "NetCDF4";
    public static final String NETCDF_4C = "NetCDF-4C";
    public static final String NETCDF_3 = "NetCDF-3";
    public static final String STANDARD_PARALLEL_1;
    public static final String STANDARD_PARALLEL_2;
    public static final String CENTRAL_MERIDIAN;
    public static final String LATITUDE_OF_ORIGIN;
    public static final String SCALE_FACTOR;
    public static final String FALSE_EASTING;
    public static final String FALSE_NORTHING;
    public static final String SEMI_MINOR;
    public static final String SEMI_MAJOR;
    public static final String INVERSE_FLATTENING = "inverse_flattening";
    public static final String UNKNOWN = "unknown";
    public static final double DEFAULT_EARTH_RADIUS = 6371229.0;
    public static final Boolean TRACE_ENABLED;
    private static final Logger LOGGER;
    private static final Set<String> UNSUPPORTED_DIMENSIONS;
    private static final Set<String> IGNORED_DIMENSIONS;
    private static boolean IS_GRIB_AVAILABLE;
    private static boolean IS_NC4_LIBRARY_AVAILABLE;
    public static final String EXTERNAL_DATA_DIR;
    public static final String NETCDF_DATA_DIR = "NETCDF_DATA_DIR";
    public static final String FILL_VALUE = "_FillValue";
    public static final String MISSING_VALUE = "missing_value";
    public static final String ACTUAL_RANGE = "actual_range";
    public static final String VALID_RANGE = "valid_range";
    public static final String VALID_MIN = "valid_min";
    public static final String VALID_MAX = "valid_max";
    public static final String LOWER_LEFT_LONGITUDE = "lower_left_longitude";
    public static final String LOWER_LEFT_LATITUDE = "lower_left_latitude";
    public static final String UPPER_RIGHT_LONGITUDE = "upper_right_longitude";
    public static final String UPPER_RIGHT_LATITUDE = "upper_right_latitude";
    public static final String COORDSYS = "latLonCoordSys";
    public static final String Y = "y";
    public static final String Y_COORD_PROJ = "y coordinate of projection";
    public static final String Y_PROJ_COORD = "projection_y_coordinate";
    public static final String X = "x";
    public static final String X_COORD_PROJ = "x coordinate of projection";
    public static final String X_PROJ_COORD = "projection_x_coordinate";
    public static final String LATITUDE = "latitude";
    public static final String LAT = "lat";
    public static final String LONGITUDE = "longitude";
    public static final String LON = "lon";
    public static final String GRID_LATITUDE = "grid_latitude";
    public static final String RLAT = "rlat";
    public static final String GRID_LONGITUDE = "grid_longitude";
    public static final String RLON = "rlon";
    public static final String DEPTH = "depth";
    public static final String ZETA = "z";
    public static final String BOUNDS = "bounds";
    private static final String BNDS = "bnds";
    public static final String HEIGHT = "height";
    public static final String TIME = "time";
    public static final String POSITIVE = "positive";
    public static final String UNITS = "units";
    public static final String NAME = "name";
    public static final String LONG_NAME = "long_name";
    public static final String ELEVATION_DIM;
    public static final String TIME_DIM;
    public static final String STANDARD_NAME = "standard_name";
    public static final String DESCRIPTION = "description";
    public static final String M = "m";
    public static final String BOUNDS_SUFFIX = "_bnds";
    public static final String LON_UNITS = "degrees_east";
    public static final String LAT_UNITS = "degrees_north";
    public static final String RLATLON_UNITS = "degrees";
    public static final String NO_COORDS = "NoCoords";
    public static final String TIME_ORIGIN = "seconds since 1970-01-01 00:00:00 UTC";
    public static final long START_TIME;
    public static final String BOUNDARY_DIMENSION = "nv";
    public static final TimeZone UTC;
    public static final String GRID_MAPPING = "grid_mapping";
    public static final String GRID_MAPPING_NAME = "grid_mapping_name";
    public static final String COORDINATE_AXIS_TYPE = "_CoordinateAxisType";
    public static final String CONVENTIONS = "Conventions";
    public static final String COORD_SYS_BUILDER = "_CoordSysBuilder";
    public static final String COORD_SYS_BUILDER_CONVENTION = "ucar.nc2.dataset.conv.CF1Convention";
    public static final String COORDINATE_TRANSFORM_TYPE = "_CoordinateTransformType";
    public static final String COORDINATES = "coordinates";
    public static final String SPATIAL_REF = "spatial_ref";
    public static final String GEO_TRANSFORM = "GeoTransform";
    public static final String CERP_ESRI_PE_STRING = "esri_pe_string";
    public static final String UNIQUE_TIME_ATTRIBUTE = "uniqueTimeAttribute";
    static final Set<String> EXCLUDED_ATTRIBUTES;
    public static final String ENHANCE_COORD_SYSTEMS = "org.geotools.coverage.io.netcdf.enhance.CoordSystems";
    public static final String ENHANCE_SCALE_MISSING = "org.geotools.coverage.io.netcdf.enhance.ScaleMissing";
    public static final String ENHANCE_CONVERT_ENUMS = "org.geotools.coverage.io.netcdf.enhance.ConvertEnums";
    public static final String ENHANCE_SCALE_MISSING_DEFER = "org.geotools.coverage.io.netcdf.enhance.ScaleMissingDefer";
    public static boolean ENHANCE_SCALE_OFFSET;
    public static final String STORE_NAME = "StoreName";
    protected static final Map<URI, FileFormat> URI_FORMAT_CACHE;
    private static final int GRIB_SEARCH_BYTES = 16000;
    public static final int X_DIMENSION = 1;
    public static final int Y_DIMENSION = 2;
    public static final int Z_DIMENSION = 3;
    public static final Set<DataType> VALID_TYPES;
    public static final String NC4_ERROR_MESSAGE = "Native NetCDF C library is not available. Unable to handle NetCDF4 files on input/output.\nPlease make sure to add the path of the Native NetCDF C libraries to the PATH environment variable\n if you want to support NetCDF4-Classic files";
    public static final String PARAMS_MAX_KEY = "org.geotools.coverage.io.netcdf.param.max";
    public static final String PARAMS_MIN_KEY = "org.geotools.coverage.io.netcdf.param.min";
    private static Set<String> PARAMS_MAX;
    private static Set<String> PARAMS_MIN;

    private NetCDFUtilities() {
    }

    static boolean isLatLon(String bandName) {
        return bandName.equalsIgnoreCase(LON) || bandName.equalsIgnoreCase(LAT);
    }

    private static Set<String> initializeIgnoreSet() {
        Set<CoordinateHandlerSpi> handlers = CoordinateHandlerFinder.getAvailableHandlers();
        Iterator<CoordinateHandlerSpi> iterator = handlers.iterator();
        HashSet<String> ignoredSet = new HashSet<String>();
        while (iterator.hasNext()) {
            CoordinateHandlerSpi handler = iterator.next();
            Set<String> ignored = handler.getIgnoreSet();
            if (ignored == null || ignored.isEmpty()) continue;
            ignoredSet.addAll(ignored);
        }
        if (!ignoredSet.isEmpty()) {
            return ignoredSet;
        }
        return new HashSet<String>();
    }

    public static boolean isValidDir(File file) {
        String dir = file.getAbsolutePath();
        if (!file.exists()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property doesn't refer to an existing folder. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.isDirectory()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property doesn't refer to a directory. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.canWrite()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified NETCDF_DATA_DIR property refers to a directory which can't be written. Please check the path and the permissions for: " + dir);
            }
            return false;
        }
        return true;
    }

    public static int getZDimensionLength(Variable var) {
        int rank = var.getRank();
        if (rank > 2) {
            return var.getDimension(rank - 3).getLength();
        }
        return 0;
    }

    public static int getDimensionLength(Variable var, int dimensionIndex) {
        return var.getDimension(dimensionIndex).getLength();
    }

    public static int getRawDataType(VariableIF variable) {
        VariableDS ds = (VariableDS)variable;
        DataType type = Boolean.getBoolean(ENHANCE_SCALE_MISSING) ? ds.getDataType() : ds.getOriginalDataType();
        return NetCDFUtilities.transcodeNetCDFDataType(type, variable.isUnsigned());
    }

    public static int transcodeNetCDFDataType(DataType type, boolean unsigned) {
        if (DataType.BOOLEAN.equals((Object)type) || DataType.BYTE.equals((Object)type)) {
            return 0;
        }
        if (DataType.CHAR.equals((Object)type)) {
            return 1;
        }
        if (DataType.SHORT.equals((Object)type)) {
            return unsigned ? 1 : 2;
        }
        if (DataType.INT.equals((Object)type)) {
            return 3;
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return 4;
        }
        if (DataType.LONG.equals((Object)type) || DataType.DOUBLE.equals((Object)type)) {
            return 5;
        }
        return 32;
    }

    public static boolean isVariableAccepted(Variable var, CheckType checkType) {
        return NetCDFUtilities.isVariableAccepted(var, checkType, null);
    }

    public static boolean isVariableAccepted(Variable var, CheckType checkType, NetcdfDataset dataset) {
        if (var instanceof CoordinateAxis1D) {
            return false;
        }
        if (checkType == CheckType.NOSCALARS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getFullName(), CheckType.NONE);
        }
        if (checkType == CheckType.ONLYGEOGRIDS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            int twoDimensionalCoordinates = 0;
            for (Dimension dimension : dimensions) {
                String dimName = dimension.getFullName();
                Group group = dimension.getGroup();
                if (group == null) {
                    return false;
                }
                if (IGNORED_DIMENSIONS.contains(dimName)) continue;
                Variable dimVariable = group.findVariable(dimName);
                if (dimVariable == null && dataset != null) {
                    dimVariable = NetCDFUtilities.getAuxiliaryCoordinate(dataset, group, var, dimName);
                }
                if (!(dimVariable instanceof CoordinateAxis1D)) continue;
                CoordinateAxis1D axis = (CoordinateAxis1D)dimVariable;
                AxisType axisType = axis.getAxisType();
                if (axisType == null) {
                    return false;
                }
                switch (axisType) {
                    case GeoX: 
                    case GeoY: 
                    case Lat: 
                    case Lon: {
                        ++twoDimensionalCoordinates;
                        break;
                    }
                }
            }
            if (twoDimensionalCoordinates < 2) {
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getFullName(), CheckType.NONE);
        }
        return NetCDFUtilities.isVariableAccepted(var.getFullName(), checkType);
    }

    private static Variable getAuxiliaryCoordinate(NetcdfDataset dataset, Group group, Variable var, String dimName) {
        Variable coordinateVariable = null;
        Attribute attribute = var.findAttribute(COORDINATES);
        if (attribute != null) {
            String[] coords;
            String coordinates = attribute.getStringValue();
            for (String coord : coords = coordinates.split(" ")) {
                Variable coordVar = dataset.findVariable(group, coord);
                List varDimensions = coordVar.getDimensions();
                if (varDimensions == null || varDimensions.size() != 1 || !((Dimension)varDimensions.get(0)).getFullName().equalsIgnoreCase(dimName)) continue;
                coordinateVariable = coordVar;
                break;
            }
        }
        return coordinateVariable;
    }

    public static boolean isVariableAccepted(String name, CheckType checkType) {
        if (checkType == CheckType.NONE) {
            return true;
        }
        return !name.equalsIgnoreCase(LATITUDE) && !name.equalsIgnoreCase(LONGITUDE) && !name.equalsIgnoreCase(LON) && !name.equalsIgnoreCase(LAT) && !name.equalsIgnoreCase(TIME) && !name.equalsIgnoreCase(DEPTH) && !name.equalsIgnoreCase(ZETA) && !name.equalsIgnoreCase(HEIGHT) && !name.toLowerCase().contains(COORDSYS.toLowerCase()) && !name.endsWith(BOUNDS) && !name.endsWith(BNDS) && !UNSUPPORTED_DIMENSIONS.contains(name);
    }

    public static FileFormat getFormat(URI uri) throws IOException {
        FileFormat format = URI_FORMAT_CACHE.get(uri);
        if (format != null) {
            return format;
        }
        format = NetCDFUtilities.getFormatFromUri(uri);
        URI_FORMAT_CACHE.put(uri, format);
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileFormat getFormatFromUri(URI uri) throws IOException {
        try (InputStream input = uri.toURL().openStream();){
            byte[] b = new byte[16000];
            int count = input.read(b);
            if (count < 3) {
                FileFormat fileFormat = FileFormat.NONE;
                return fileFormat;
            }
            if (b[0] == 67 && b[1] == 68 && b[2] == 70) {
                FileFormat fileFormat = FileFormat.CDF;
                return fileFormat;
            }
            if (b[0] == -119 && b[1] == 72 && b[2] == 68) {
                FileFormat fileFormat = FileFormat.HDF5;
                return fileFormat;
            }
            for (int i = 0; i < count - 3; ++i) {
                if (b[i] != 71 || b[i + 1] != 82 || b[i + 2] != 73 || b[i + 3] != 66) continue;
                FileFormat fileFormat = FileFormat.GRIB;
                return fileFormat;
            }
        }
        input = uri.toURL().openStream();
        try {
            StreamSource streamSource = null;
            XMLStreamReader reader = null;
            try {
                streamSource = new StreamSource(input);
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                reader = inputFactory.createXMLStreamReader(streamSource);
                reader.nextTag();
                if ("netcdf".equals(reader.getName().getLocalPart())) {
                    FileFormat fileFormat = FileFormat.NCML;
                    return fileFormat;
                }
                if ("featureCollection".equals(reader.getName().getLocalPart())) {
                    FileFormat fileFormat = FileFormat.FC;
                    return fileFormat;
                }
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            finally {
                if (reader != null) {
                    if (streamSource.getInputStream() != null) {
                        streamSource.getInputStream().close();
                    }
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return FileFormat.NONE;
    }

    public static NetcdfDataset acquireFeatureCollection(String path) throws IOException {
        Formatter formatter = new Formatter(System.err);
        FeatureCollectionConfigBuilder builder = new FeatureCollectionConfigBuilder(formatter);
        FeatureCollectionConfig config = builder.readConfigFromFile(path.toString());
        Fmrc fmrc = Fmrc.open((FeatureCollectionConfig)config, (Formatter)formatter);
        NetcdfDataset dataset = new NetcdfDataset();
        fmrc.getDataset2D(dataset);
        dataset.setLocation(path);
        return dataset;
    }

    public static NetcdfDataset acquireDataset(URI uri) throws IOException {
        if (NetCDFUtilities.getFormat(uri) == FileFormat.FC) {
            return NetCDFUtilities.acquireFeatureCollection(uri.toString());
        }
        return NetcdfDataset.acquireDataset((String)uri.toString(), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetcdfDataset getDataset(Object input) throws IOException {
        NetcdfDataset dataset = null;
        if (input instanceof URI) {
            return NetCDFUtilities.acquireDataset((URI)input);
        }
        if (input instanceof File) {
            File file = (File)input;
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetCDFUtilities.acquireDataset(file.toURI());
        }
        if (input instanceof String) {
            File file = new File((String)input);
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetCDFUtilities.acquireDataset(file.toURI());
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                File file = ImageIOUtilities.urlToFile((URL)tempURL);
                if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
                return NetCDFUtilities.acquireDataset(file.toURI());
            }
            if (!protocol.equalsIgnoreCase("http")) {
                if (!protocol.equalsIgnoreCase("dods")) return dataset;
            }
            try {
                return NetCDFUtilities.acquireDataset(tempURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        if (!(input instanceof AccessibleStream)) return dataset;
        AccessibleStream stream = (AccessibleStream)input;
        if (stream.getBinding().isAssignableFrom(File.class)) {
            AccessibleStream as = (AccessibleStream)input;
            File file = (File)as.getTarget();
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetCDFUtilities.acquireDataset(file.toURI());
        }
        if (!stream.getBinding().isAssignableFrom(URI.class)) return dataset;
        AccessibleStream as = (AccessibleStream)input;
        URI uri = (URI)as.getTarget();
        return NetCDFUtilities.acquireDataset(uri);
    }

    public static File getFile(Object input) throws IOException {
        AccessibleStream stream;
        File guessedFile = null;
        if (input instanceof File) {
            guessedFile = (File)input;
        } else if (input instanceof String) {
            guessedFile = new File((String)input);
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                guessedFile = ImageIOUtilities.urlToFile((URL)tempURL);
            }
        } else if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            String uri = uriInStream.getUri().toString();
            guessedFile = new File(uri);
        } else if (input instanceof AccessibleStream && (stream = (AccessibleStream)input).getBinding().isAssignableFrom(File.class)) {
            AccessibleStream as = (AccessibleStream)input;
            guessedFile = (File)as.getTarget();
        }
        if (guessedFile != null && guessedFile.exists() && !guessedFile.isDirectory()) {
            return guessedFile;
        }
        return null;
    }

    public static Format getAxisFormat(AxisType type, String prototype) {
        int lastColon;
        if (!type.equals((Object)AxisType.Time) && !type.equals((Object)AxisType.RunTime)) {
            return NumberFormat.getNumberInstance(Locale.ENGLISH);
        }
        char dateSeparator = '-';
        boolean twoDigitYear = false;
        boolean yearLast = false;
        boolean namedMonth = false;
        boolean monthFirst = false;
        boolean addT = false;
        boolean appendZ = false;
        int dateLength = 0;
        if (prototype != null) {
            int field = 1;
            int digitCount = 0;
            int length = prototype.length();
            for (int i = 0; i < length; ++i) {
                char c = prototype.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!monthFirst || field != true) break;
                    ++dateLength;
                } else {
                    if (Character.isDigit(c)) {
                        ++digitCount;
                        ++dateLength;
                        continue;
                    }
                    if (Character.isLetter(c) && field <= 2) {
                        if (field == 1) {
                            yearLast = true;
                            monthFirst = true;
                        }
                        namedMonth = true;
                        ++dateLength;
                        continue;
                    }
                    if (field == 1 || monthFirst && field == 2) {
                        dateSeparator = c;
                        ++dateLength;
                    } else if (c == dateSeparator) {
                        ++dateLength;
                    } else if (c == 'T') {
                        addT = true;
                    } else if (c == 'Z' && i == length - 1) {
                        appendZ = true;
                    }
                }
                if ((field == 1 || yearLast && field == 3) && digitCount <= 2) {
                    twoDigitYear = true;
                }
                digitCount = 0;
                ++field;
            }
            if (digitCount >= 4) {
                yearLast = true;
                twoDigitYear = false;
            }
        }
        Object pattern = null;
        if (yearLast) {
            pattern = (String)(monthFirst ? "MMM dd-" : "dd-" + (namedMonth ? "MMM-" : "MM-")) + (twoDigitYear ? "yy" : "yyyy");
        } else {
            pattern = (twoDigitYear ? "yy-" : "yyyy-") + (namedMonth ? "MMM-" : "MM-") + "dd";
            if (dateLength < ((String)pattern).length()) {
                pattern = ((String)pattern).substring(0, dateLength);
            }
        }
        pattern = ((String)pattern).replace('-', dateSeparator);
        int n = lastColon = prototype != null ? prototype.lastIndexOf(":") : -1;
        if (lastColon != -1) {
            pattern = (String)pattern + (addT ? "'T'" : " ");
            pattern = (String)pattern + (prototype != null && lastColon >= 16 ? "HH:mm:ss" : "HH:mm");
        }
        pattern = (String)pattern + (appendZ ? "'Z'" : "");
        SimpleDateFormat format = new SimpleDateFormat((String)pattern, Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static CheckType getCheckType(NetcdfDataset dataset) {
        CheckType ct = CheckType.UNSET;
        if (dataset != null) {
            ct = CheckType.ONLYGEOGRIDS;
        }
        return ct;
    }

    public static SimpleFeatureType createFeatureType(String schemaName, String schemaDef, CoordinateReferenceSystem crs) {
        SimpleFeatureType indexSchema = null;
        if (schemaDef == null) {
            throw new IllegalArgumentException("Unable to create feature type from null definition!");
        }
        schemaDef = schemaDef.trim();
        try {
            indexSchema = DataUtilities.createType((String)schemaName, (String)schemaDef);
            indexSchema = DataUtilities.createSubType((SimpleFeatureType)indexSchema, (String[])DataUtilities.attributeNames((SimpleFeatureType)indexSchema), (CoordinateReferenceSystem)crs);
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            indexSchema = null;
        }
        return indexSchema;
    }

    public static boolean isGribAvailable() {
        return IS_GRIB_AVAILABLE;
    }

    public static boolean isNC4CAvailable() {
        return IS_NC4_LIBRARY_AVAILABLE;
    }

    public static boolean isCheckCoordinatePlugins() {
        return CHECK_COORDINATE_PLUGINS;
    }

    public static Set<String> getUnsupportedDimensions() {
        return UNSUPPORTED_DIMENSIONS;
    }

    public static Set<String> getIgnoredDimensions() {
        return Collections.unmodifiableSet(IGNORED_DIMENSIONS);
    }

    public static void addIgnoredDimension(String dimensionName) {
        IGNORED_DIMENSIONS.add(dimensionName);
    }

    public static Number getNodata(Variable var) {
        if (var != null) {
            List attributes = var.getAttributes();
            for (Attribute attribute : attributes) {
                String fullName = attribute.getFullName();
                if (!fullName.equalsIgnoreCase(FILL_VALUE) && !fullName.equalsIgnoreCase(MISSING_VALUE)) continue;
                return attribute.getNumericValue();
            }
        }
        return null;
    }

    public static NumberRange getRange(Variable var) {
        if (var != null) {
            double min = Double.NaN;
            double max = Double.NaN;
            DataType dataType = null;
            Attribute rangeAttribute = var.findAttribute(ACTUAL_RANGE);
            if (rangeAttribute == null) {
                rangeAttribute = var.findAttribute(VALID_RANGE);
            }
            if (rangeAttribute != null) {
                dataType = rangeAttribute.getDataType();
                min = rangeAttribute.getNumericValue(0).doubleValue();
                max = rangeAttribute.getNumericValue(1).doubleValue();
            } else {
                Attribute minAttribute = var.findAttribute(VALID_MIN);
                Attribute maxAttribute = var.findAttribute(VALID_MAX);
                if (minAttribute != null && maxAttribute != null) {
                    dataType = minAttribute.getDataType();
                    min = minAttribute.getNumericValue().doubleValue();
                    max = maxAttribute.getNumericValue().doubleValue();
                }
            }
            if (!Double.isNaN(min) && !Double.isNaN(max)) {
                Number noData;
                if ((dataType == DataType.BYTE || dataType == DataType.INT || dataType == DataType.SHORT || dataType == DataType.LONG) && (noData = NetCDFUtilities.getNodata(var)) != null && (double)noData.intValue() == min) {
                    min += 1.0;
                }
                return NumberRange.create((double)min, (double)max);
            }
        }
        return null;
    }

    public static DataType getNetCDFDataType(String classDataType) {
        if (NetCDFUtilities.isATime(classDataType)) {
            return DataType.DOUBLE;
        }
        if (classDataType.endsWith("Integer")) {
            return DataType.INT;
        }
        if (classDataType.endsWith("Double")) {
            return DataType.DOUBLE;
        }
        if (classDataType.endsWith("String")) {
            return DataType.STRING;
        }
        return DataType.STRING;
    }

    public static DataType transcodeImageDataType(int dataType) {
        switch (dataType) {
            case 0: {
                return DataType.BYTE;
            }
            case 2: {
                return DataType.SHORT;
            }
            case 3: {
                return DataType.INT;
            }
            case 5: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.FLOAT;
            }
        }
        throw new IllegalArgumentException("Invalid input data type:" + dataType);
    }

    public static final boolean isATime(String classDataType) {
        return classDataType.endsWith("Timestamp") || classDataType.endsWith("Date");
    }

    public static Array getArray(int[] dimensions, DataType varDataType) {
        if (dimensions == null) {
            throw new IllegalArgumentException("Illegal dimensions");
        }
        int nDims = dimensions.length;
        switch (nDims) {
            case 7: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D7(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5], dimensions[6]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D7(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5], dimensions[6]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D7(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5], dimensions[6]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D7(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5], dimensions[6]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D7(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5], dimensions[6]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 6: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D6(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4], dimensions[5]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 5: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D5(dimensions[0], dimensions[1], dimensions[2], dimensions[3], dimensions[4]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 4: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 3: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 2: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D2(dimensions[0], dimensions[1]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D2(dimensions[0], dimensions[1]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
            case 1: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D1(dimensions[0]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D1(dimensions[0]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D1(dimensions[0]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D1(dimensions[0]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D1(dimensions[0]);
                }
                throw new IllegalArgumentException("unsupported Datatype");
            }
        }
        throw new IllegalArgumentException("Unable to create a proper array unsupported Datatype; nDims not between 1 and 7");
    }

    public static Number transcodeNumber(DataType type, Number value) {
        if (DataType.DOUBLE.equals((Object)type)) {
            return value.doubleValue();
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return Float.valueOf(value.floatValue());
        }
        if (DataType.LONG.equals((Object)type)) {
            return value.longValue();
        }
        if (DataType.INT.equals((Object)type)) {
            return value.intValue();
        }
        if (DataType.SHORT.equals((Object)type)) {
            return value.shortValue();
        }
        if (DataType.BYTE.equals((Object)type)) {
            return value.byteValue();
        }
        throw new IllegalArgumentException("Unsupported type or value: type = " + type.toString() + " value = " + String.valueOf(value));
    }

    public static void refreshParameterBehaviors() {
        PARAMS_MAX = new HashSet<String>();
        String maxProperty = System.getProperty(PARAMS_MAX_KEY);
        if (maxProperty != null) {
            for (String param : maxProperty.split(",")) {
                PARAMS_MAX.add(param.trim().toUpperCase());
            }
        }
        String minProperty = System.getProperty(PARAMS_MIN_KEY);
        PARAMS_MIN = new HashSet<String>();
        if (minProperty != null) {
            for (String param : minProperty.split(",")) {
                PARAMS_MIN.add(param.trim().toUpperCase());
            }
        }
    }

    public static ParameterBehaviour getParameterBehaviour(String parameter) {
        if (PARAMS_MAX.contains(parameter.toUpperCase())) {
            return ParameterBehaviour.MAX;
        }
        if (PARAMS_MIN.contains(parameter.toUpperCase())) {
            return ParameterBehaviour.MIN;
        }
        return ParameterBehaviour.DO_NOTHING;
    }

    private static void clearCache() {
        URI_FORMAT_CACHE.clear();
    }

    public static void clearCaches() {
        NetCDFUtilities.clearCache();
        AncillaryFileManager.clearCache();
        VariableAdapter.clearCache();
    }

    static {
        String dir;
        File file;
        STANDARD_PARALLEL_1 = MapProjection.AbstractProvider.STANDARD_PARALLEL_1.getName().getCode();
        STANDARD_PARALLEL_2 = MapProjection.AbstractProvider.STANDARD_PARALLEL_2.getName().getCode();
        CENTRAL_MERIDIAN = MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode();
        LATITUDE_OF_ORIGIN = MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode();
        SCALE_FACTOR = MapProjection.AbstractProvider.SCALE_FACTOR.getName().getCode();
        FALSE_EASTING = MapProjection.AbstractProvider.FALSE_EASTING.getName().getCode();
        FALSE_NORTHING = MapProjection.AbstractProvider.FALSE_NORTHING.getName().getCode();
        SEMI_MINOR = MapProjection.AbstractProvider.SEMI_MINOR.getName().getCode();
        SEMI_MAJOR = MapProjection.AbstractProvider.SEMI_MAJOR.getName().getCode();
        TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.netcdf.trace"));
        LOGGER = Logger.getLogger(NetCDFUtilities.class.toString());
        ELEVATION_DIM = ImageMosaicFormat.ELEVATION.getName().toString();
        TIME_DIM = ImageMosaicFormat.TIME.getName().toString();
        EXCLUDED_ATTRIBUTES = new HashSet<String>();
        ENHANCE_SCALE_OFFSET = false;
        URI_FORMAT_CACHE = new SoftValueHashMap();
        VALID_TYPES = new HashSet<DataType>(12);
        EnumSet<NetcdfDataset.Enhance> defaultEnhanceMode = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
        if (System.getProperty(ENHANCE_COORD_SYSTEMS) != null && !Boolean.getBoolean(ENHANCE_COORD_SYSTEMS)) {
            defaultEnhanceMode.remove(NetcdfDataset.Enhance.CoordSystems);
        }
        if (Boolean.getBoolean(ENHANCE_SCALE_MISSING)) {
            defaultEnhanceMode.add(NetcdfDataset.Enhance.ScaleMissing);
            ENHANCE_SCALE_OFFSET = true;
        }
        if (Boolean.getBoolean(ENHANCE_CONVERT_ENUMS)) {
            defaultEnhanceMode.add(NetcdfDataset.Enhance.ConvertEnums);
        }
        if (Boolean.getBoolean(ENHANCE_SCALE_MISSING_DEFER)) {
            defaultEnhanceMode.add(NetcdfDataset.Enhance.ScaleMissingDefer);
        }
        NetcdfDataset.setDefaultEnhanceMode(defaultEnhanceMode);
        if (Boolean.getBoolean("org.geotools.coverage.io.netcdf.cachefile")) {
            int minElements = Integer.getInteger("org.geotools.coverage.io.netcdf.cache.min", 200);
            int maxElements = Integer.getInteger("org.geotools.coverage.io.netcdf.cache.max", 300);
            int period = Integer.getInteger("org.geotools.coverage.io.netcdf.cache.cleanup.period", 720);
            NetcdfDataset.initNetcdfFileCache((int)minElements, (int)maxElements, (int)period);
            RandomAccessFile.setGlobalFileCache((FileCacheIF)new FileCache(minElements, maxElements, period));
        }
        String property = System.getProperty(CHECK_COORDINATE_PLUGINS_KEY);
        CHECK_COORDINATE_PLUGINS = Boolean.getBoolean(CHECK_COORDINATE_PLUGINS_KEY);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Value of Check Coordinate Plugins:" + property);
            LOGGER.info("Should check for coordinate handler plugins:" + CHECK_COORDINATE_PLUGINS);
        }
        IGNORED_DIMENSIONS = NetCDFUtilities.initializeIgnoreSet();
        GregorianCalendar calendar = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        UTC = TimeZone.getTimeZone("UTC");
        calendar.setTimeZone(UTC);
        START_TIME = calendar.getTimeInMillis();
        EXCLUDED_ATTRIBUTES.add(UNITS);
        EXCLUDED_ATTRIBUTES.add(LONG_NAME);
        EXCLUDED_ATTRIBUTES.add(DESCRIPTION);
        EXCLUDED_ATTRIBUTES.add(STANDARD_NAME);
        HashSet<String> unsupportedSet = new HashSet<String>();
        unsupportedSet.add("OSEQD");
        UNSUPPORTED_DIMENSIONS = Collections.unmodifiableSet(unsupportedSet);
        VALID_TYPES.add(DataType.BOOLEAN);
        VALID_TYPES.add(DataType.BYTE);
        VALID_TYPES.add(DataType.SHORT);
        VALID_TYPES.add(DataType.INT);
        VALID_TYPES.add(DataType.LONG);
        VALID_TYPES.add(DataType.FLOAT);
        VALID_TYPES.add(DataType.DOUBLE);
        String externalDir = System.getProperty(NETCDF_DATA_DIR);
        String finalDir = null;
        if (externalDir != null && NetCDFUtilities.isValidDir(file = new File(dir = externalDir))) {
            finalDir = dir;
        }
        EXTERNAL_DATA_DIR = finalDir;
        try {
            Class.forName("ucar.nc2.grib.collection.GribIosp");
            Class.forName("org.geotools.coverage.io.grib.GribUtilities");
            IS_GRIB_AVAILABLE = true;
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No Grib library found on classpath. GRIB will not be supported");
            }
            IS_GRIB_AVAILABLE = false;
        }
        IS_NC4_LIBRARY_AVAILABLE = Nc4Iosp.isClibraryPresent();
        if (!IS_NC4_LIBRARY_AVAILABLE && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(NC4_ERROR_MESSAGE);
        }
        NetCDFUtilities.refreshParameterBehaviors();
    }

    public static enum ParameterBehaviour {
        DO_NOTHING,
        MAX,
        MIN;

    }

    public static enum FileFormat {
        NONE,
        CDF,
        HDF5,
        GRIB,
        NCML,
        FC;

    }

    public static enum CheckType {
        NONE,
        UNSET,
        NOSCALARS,
        ONLYGEOGRIDS;

    }

    public static enum Axis {
        X,
        Y,
        Z,
        T;

    }
}

