/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class NetCDFTimeUtilities {
    public static final int JGREG = 588829;
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final Set<String> MONTH_SET = new HashSet<String>();
    public static final Set<String> DAY_SET = new HashSet<String>();
    public static final Set<String> HOUR_SET = new HashSet<String>();
    public static final Set<String> MINUTE_SET = new HashSet<String>();
    public static final Set<String> SECOND_SET = new HashSet<String>();

    private NetCDFTimeUtilities() {
    }

    public static String checkDateDigits(String origin) {
        Object datePart;
        int l;
        String[] originDateParts;
        String tmp;
        Object digitsCheckedOrigin = "";
        if (origin.indexOf("-") > 0) {
            tmp = origin.indexOf(" ") > 0 ? origin.substring(0, origin.indexOf(" ")) : origin;
            originDateParts = tmp.split("-");
            for (l = 0; l < originDateParts.length; ++l) {
                datePart = originDateParts[l];
                while (((String)datePart).length() % 2 != 0) {
                    datePart = "0" + (String)datePart;
                }
                digitsCheckedOrigin = (String)digitsCheckedOrigin + (String)datePart;
                digitsCheckedOrigin = (String)digitsCheckedOrigin + (l < originDateParts.length - 1 ? "-" : "");
            }
        }
        if (origin.indexOf(":") > 0) {
            digitsCheckedOrigin = (String)digitsCheckedOrigin + " ";
            tmp = origin.indexOf(" ") > 0 ? origin.substring(origin.indexOf(" ") + 1) : origin;
            originDateParts = tmp.split(":");
            for (l = 0; l < originDateParts.length; ++l) {
                datePart = originDateParts[l];
                while (((String)datePart).length() % 2 != 0) {
                    datePart = "0" + (String)datePart;
                }
                digitsCheckedOrigin = (String)digitsCheckedOrigin + (String)datePart;
                digitsCheckedOrigin = (String)digitsCheckedOrigin + (l < originDateParts.length - 1 ? ":" : "");
            }
        }
        if (((String)digitsCheckedOrigin).length() > 0) {
            return digitsCheckedOrigin;
        }
        return origin;
    }

    public static GregorianCalendar fromJulian(double injulian) {
        int ja = (int)injulian;
        if (ja >= 588829) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    public static int getTimeSubUnitsValue(String units, Double vd) {
        int subUnit;
        if (units == null || units.isEmpty()) {
            return 0;
        }
        String unit = units.toLowerCase();
        if (MONTH_SET.contains(unit)) {
            int subUnit2 = NetCDFTimeUtilities.getTimeUnits(units, vd);
            if (subUnit2 == 5) {
                double days = vd * 30.0;
                return (int)days;
            }
            if (subUnit2 == 10) {
                double hours = vd * 30.0 * 24.0;
                return (int)hours;
            }
            if (subUnit2 == 12) {
                double minutes = vd * 30.0 * 24.0 * 60.0;
                return (int)minutes;
            }
            if (subUnit2 == 13) {
                double seconds = vd * 30.0 * 24.0 * 60.0 * 60.0;
                return (int)seconds;
            }
            if (subUnit2 == 14) {
                double milliseconds = vd * 30.0 * 24.0 * 60.0 * 60.0 * 1000.0;
                return (int)milliseconds;
            }
        } else if (DAY_SET.contains(unit)) {
            int subUnit3 = NetCDFTimeUtilities.getTimeUnits(units, vd);
            if (subUnit3 == 10) {
                double hours = vd * 24.0;
                return (int)hours;
            }
            if (subUnit3 == 12) {
                double minutes = vd * 24.0 * 60.0;
                return (int)minutes;
            }
            if (subUnit3 == 13) {
                double seconds = vd * 24.0 * 60.0 * 60.0;
                return (int)seconds;
            }
            if (subUnit3 == 14) {
                double milliseconds = vd * 24.0 * 60.0 * 60.0 * 1000.0;
                return (int)milliseconds;
            }
        } else if (HOUR_SET.contains(unit)) {
            int subUnit4 = NetCDFTimeUtilities.getTimeUnits(units, vd);
            if (subUnit4 == 12) {
                double minutes = vd * 60.0;
                return (int)minutes;
            }
            if (subUnit4 == 13) {
                double seconds = vd * 60.0 * 60.0;
                return (int)seconds;
            }
            if (subUnit4 == 14) {
                double milliseconds = vd * 60.0 * 60.0 * 1000.0;
                return (int)milliseconds;
            }
        } else if (MINUTE_SET.contains(unit)) {
            int subUnit5 = NetCDFTimeUtilities.getTimeUnits(units, vd);
            if (subUnit5 == 13) {
                double seconds = vd * 60.0;
                return (int)seconds;
            }
            if (subUnit5 == 14) {
                double milliseconds = vd * 60.0 * 1000.0;
                return (int)milliseconds;
            }
        } else if (SECOND_SET.contains(unit) && (subUnit = NetCDFTimeUtilities.getTimeUnits(units, vd)) == 14) {
            double milliseconds = vd * 1000.0;
            return (int)milliseconds;
        }
        return 0;
    }

    public static int getTimeUnits(String units, Double vd) {
        if (units == null || units.isEmpty()) {
            return -1;
        }
        String unit = units.toLowerCase();
        if (MONTH_SET.contains(unit)) {
            if (vd == null || vd == 0.0) {
                return 2;
            }
            double days = vd * 30.0;
            if (days - Math.floor(days) == 0.0) {
                return 5;
            }
            double hours = days * 24.0;
            if (hours - Math.floor(hours) == 0.0) {
                return 10;
            }
            double minutes = hours * 60.0;
            if (minutes - Math.floor(minutes) == 0.0) {
                return 12;
            }
            double seconds = minutes * 60.0;
            if (seconds - Math.floor(seconds) == 0.0) {
                return 13;
            }
            return 14;
        }
        if (DAY_SET.contains(unit)) {
            if (vd == null || vd == 0.0) {
                return 5;
            }
            double hours = vd * 24.0;
            if (hours - Math.floor(hours) == 0.0) {
                return 10;
            }
            double minutes = vd * 24.0 * 60.0;
            if (minutes - Math.floor(minutes) == 0.0) {
                return 12;
            }
            double seconds = vd * 24.0 * 60.0 * 60.0;
            if (seconds - Math.floor(seconds) == 0.0) {
                return 13;
            }
            return 14;
        }
        if (HOUR_SET.contains(unit)) {
            if (vd == null || vd == 0.0) {
                return 10;
            }
            double minutes = vd * 60.0;
            if (minutes - Math.floor(minutes) == 0.0) {
                return 12;
            }
            double seconds = vd * 60.0 * 60.0;
            if (seconds - Math.floor(seconds) == 0.0) {
                return 13;
            }
            return 14;
        }
        if (MINUTE_SET.contains(unit)) {
            if (vd == null || vd == 0.0) {
                return 12;
            }
            double seconds = vd * 60.0;
            if (seconds - Math.floor(seconds) == 0.0) {
                return 13;
            }
            return 14;
        }
        if (SECOND_SET.contains(unit)) {
            if (vd == null || vd == 0.0) {
                return 13;
            }
            return 14;
        }
        return -1;
    }

    public static String trimFractionalPart(String value) {
        value = value.trim();
        int i = value.length();
        block4: while (--i >= 0) {
            switch (value.charAt(i)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    return value.substring(0, i);
                }
            }
            return value;
        }
        return value;
    }

    public static void addTimeUnit(Calendar cal, int unit, int val) {
        NetCDFTimeUtilities.addTimeUnit(cal, unit, (long)val);
    }

    public static void addTimeUnit(Calendar cal, int unit, long val) {
        if (unit == 5) {
            cal.setTimeInMillis(cal.getTimeInMillis() + TimeUnit.DAYS.toMillis(val));
        } else if (unit == 10) {
            cal.setTimeInMillis(cal.getTimeInMillis() + TimeUnit.HOURS.toMillis(val));
        } else if (unit == 12) {
            cal.setTimeInMillis(cal.getTimeInMillis() + TimeUnit.MINUTES.toMillis(val));
        } else if (unit == 13) {
            cal.setTimeInMillis(cal.getTimeInMillis() + TimeUnit.SECONDS.toMillis(val));
        } else if (unit == 14) {
            cal.setTimeInMillis(cal.getTimeInMillis() + val);
        } else {
            int intVal = (int)val;
            if ((long)intVal != val) {
                throw new IllegalArgumentException("Can't convert " + val + " to an int without losing data");
            }
            cal.add(unit, intVal);
        }
    }

    static {
        MONTH_SET.add("month");
        MONTH_SET.add("months");
        DAY_SET.add("d");
        DAY_SET.add("day");
        DAY_SET.add("days");
        HOUR_SET.add("h");
        HOUR_SET.add("hr");
        HOUR_SET.add("hrs");
        HOUR_SET.add("hour");
        HOUR_SET.add("hours");
        MINUTE_SET.add("min");
        MINUTE_SET.add("mins");
        MINUTE_SET.add("minute");
        MINUTE_SET.add("minutes");
        SECOND_SET.add("s");
        SECOND_SET.add("sec");
        SECOND_SET.add("secs");
        SECOND_SET.add("second");
        SECOND_SET.add("seconds");
    }
}

